#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>
#include <errno.h>

int _closedir(DIR * dir)
{
  int fd;

  if (!dir) {
    errno = EBADF;
    return -1;
  }
  fd = dir->dd_fd;
  free(dir->dd_buf);
  free(dir);
  return _close(fd);
}


#ifdef ELF_LIBRARY
__asm__(".weak closedir; closedir = _closedir");
#endif
