/* Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include <localeinfo.h>
#include <errno.h>
#include <locale.h>
#include <string.h>

#if 1
#include <ctype.h>

extern CONST unsigned short int __ctype_b_C[];
extern CONST struct ctype_info __ctype_C;

extern CONST unsigned short int __ctype_b_ISO_8859_1[];
extern CONST struct ctype_info __ctype_ISO_8859_1;

#endif


/* Switch to the locale called NAME in CATEGORY.
   Return a string describing the locale.  This string can
   be used as the NAME argument in a later call.
   If NAME is NULL, don't switch locales, but return the current one.
   If NAME is "", switch to a locale based on the environment variables,
   as per POSIX.  Return NULL on error.  */
char *
DEFUN(setlocale, (category, name), int category AND CONST char *name)
{
#if 1
  /* Don't ask me why I did this. H.J. */

  /* The default locale is C. */
  static CONST char * current_locale = "C";

  /* Return the current locale. */
  if (name == NULL || name[0] == '\0')
    return (char *) current_locale;

  /* For POSIX, we do nothing. */
  if (!strcmp(name, "POSIX"))
    return (char *) name;

  /* Change locale */
  if (strcmp (name, current_locale))
  {
    /* For C, we use the C char set. */
    if (!strcmp(name, "C"))
    {
      memcpy(__ctype, __ctype_b_C, 521);
      _ctype_info = &__ctype_C;
      current_locale = name;
      return (char *) name;
    }

    /* For ISO-8859-1, we use the ISO-8859-1 char set. */
    if (!strcmp(name, "ISO-8859-1"))
    {
      memcpy(__ctype, __ctype_b_ISO_8859_1, 521);
      _ctype_info = &__ctype_ISO_8859_1;
      current_locale = name;
      return (char *) name;
    }
  }
#else

  /* Braindead implementation until I finish the fancy one.  */

  if (name == NULL || name[0] == '\0')
    return (char *) "C";

  if (!strcmp(name, "C") || !strcmp(name, "POSIX"))
    return (char *) name;
#endif

  errno = EINVAL;
  return NULL;
}
