/*
 *  Copyright (c) 1992, 1995 John E. Davis  (davis@space.mit.edu)
 *  All Rights Reserved.
 */
#if !defined (msdos) && !defined (__os2__)

#include <config.h>
#include <slang.h>

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#include <signal.h>
#ifndef VMS
#include <sys/types.h>
#endif

#include "sig.h"
#include "file.h"
#include "sysdep.h"
#include "misc.h"
#include "screen.h"
#include "cmds.h"
#include "hooks.h"

static int signal_in_progress = 0;
static int last_signal_code;

#ifdef __cplusplus
#define SIGNAL(a,b) signal((a), (SIG_PF)(b))
#else
#define SIGNAL signal
#endif

#ifndef VMS
#ifdef SIGWINCH
static void resize_display(int sig)
{
   int r, c;
   (void) sig;
   get_term_dimensions(&c, &r);
   if (r > MAX_SCREEN_SIZE) r = MAX_SCREEN_SIZE;
   change_screen_size(c, r);
   SIGNAL (SIGWINCH, resize_display);
}
#endif
#endif

#ifndef VMS
static void my_signal(int sig)
{
   char buf[48];
   last_signal_code = sig;
   /* set signal to point to default */
   SIGNAL(sig, SIG_DFL);

   if (signal_in_progress)
     kill(getpid(), last_signal_code);
   
   if (signal_in_progress) abort();

   signal_in_progress = 1;
   auto_save_all ();
   
   sprintf (buf, "Killed by signal %d.", sig);
   exit_error (buf, 0);
   kill (getpid (), last_signal_code);
   exit (-1);
}

/* a control-G puts us here */
static void my_interrupt(int sig)
{
   SLKeyBoard_Quit = 1;
   if (Ignore_User_Abort == 0) SLang_Error = 2;
   SIGNAL (SIGINT, my_interrupt);
}

#ifdef SIGTSTP
int Signal_Sys_Spawn_Flag = 0;
/* This should only be called from outside disturbance */
void sig_sys_spawn_cmd(int sig)
{
   Signal_Sys_Spawn_Flag = 1;
   sys_spawn_cmd();
   update(NULL, 1, 0);		       /* force update */
   Signal_Sys_Spawn_Flag = 0;
}
#endif
#endif /* NOT VMS */

#ifdef SIGTTIN
static void background_read (int sig)
{
   if (Stdin_Is_TTY == 0) 
     {
	exit_error ("Attempt to read from background-- exiting.", 0);
     }
   sig_sys_spawn_cmd (0);
}
#endif

void init_signals (void)
{
#ifndef VMS
#ifdef SIGWINCH
   if (X_Get_Term_Size_Hook == NULL) (void) SIGNAL(SIGWINCH,resize_display);
#endif
   SIGNAL (SIGINT, my_interrupt);
   SIGNAL (SIGHUP, my_signal);
   SIGNAL (SIGQUIT, my_signal);
   SIGNAL (SIGILL, my_signal);
   SIGNAL (SIGTRAP, my_signal);
#if 0
   SIGNAL (SIGIOT, my_signal);  /* used by abort */
#endif
#ifdef SIGPIPE
   SIGNAL (SIGPIPE, my_signal);
#endif
   /* SIGNAL (SIGFPE, my_signal); */
#ifdef SIGBUS
   SIGNAL (SIGBUS, my_signal);
#endif
   SIGNAL (SIGSEGV, my_signal);
#ifdef SIGSYS
    SIGNAL (SIGSYS, my_signal);
#endif
    SIGNAL (SIGTERM, my_signal);
#ifdef SIGTSTP
   SIGNAL (SIGTSTP, sig_sys_spawn_cmd);
#endif
#ifdef SIGTTOU
   SIGNAL (SIGTTOU, SIG_IGN);
#endif
#ifdef SIGTTIN
   SIGNAL (SIGTTIN, background_read);
#endif
#endif /* VMS */
}
#endif
