.\"========================================================================
.\"
.\" Name - xgrabsc.man
.\"
.\" ccs version: 1.24
.\"
.\" ccsid:	@(#)xgrabsc.man	1.24 - 08/16/95 08:16:46
.\" from: 	ccs/s.xgrabsc.man
.\" date: 	11/07/95 11:31:41
.\"
.\" Copyright (C) 1990-95 Bruce Schuchardt
.\" See the end of this document for full copyright information.
.\"
.\" Description:  Man page for xgrabsc
.\"
.\"========================================================================
.\"
.TH XGRABSC 1X
.\"
.SH NAME
xgrabsc \- grab rectangular screen images and store in files
.\"
.SH SYNOPSIS
.in +8n
.ti -8n
\fIxgrabsc\fR
[\fB\-d\fP\ \fIdisplay\fP]
[\fB\-id\fP\ \fIwindowId\fP]
[\fB\-colorwin\fP\ \fIwindowId\fP]
[\fB\-o\fP\ \fIoutputFile\fP]
[\fB\-s\fP\ \fIseconds\fP]
[\fB\-post\fP\ \fIseconds\fP]
[\fB\-b\fP\ \fIpercent\fP]
[\fB\-and\fP\ \fIandBits\fP]
[\fB\-or\fP\ \fIorBits\fP]
[\fB\-page\fP\ \fIwidthxheight-hmarg-vmarg\fP]
[\fB\-bell -grab -verbose -borders -frame -key -stretch -root -click
-coords \fP\fIwidthxheight+x+y\fP
\fB-offset \fP\fIwidthxheight+x+y\fP
.br
\fB-reverse -bw -mdither -dither -halftone
.br
-ps -cps -simple -xwd -ppm -xwdxy -bm -bm2 -bm3 -puzzle
.br
-bin -comp -eps -l -limit -preview -prev -previewonly -colproc\fP]
.in -8n
.\"
.\"
.\"
.SH DESCRIPTION
\fIxgrabsc\fR lets you grab arbitrary rectangular images from an
X server and writes them to standard output in a variety of formats.
.PP
Command line options also allow reduction of colormaps, halftoning
and dithering of color images, and direct mapping of color images
to monochrome.
.PP
Options must be seperated with spaces or tabs.  They
may be preceded with a dash, but this optional and provided for Un*x
addicts.  Many may also be prefixed with 'no', or an additional dash, to
turn them off.
.PP
The default output format is gray-scale non-encapsulated Postscript, with
image compression (if image compression significantly reduces the amount of
output).
.PP
If you desire an output format not produced by xgrabsc, try using the
PBM package by Jef Poskanzer to convert xgrabsc to that format.  PBM
can read xgrabsc's PPM and XWD output formats and convert them to a lot
of different formats.
.\"
.\"
.\"
.\"
.SH GENERAL OPTIONS
.TP 8
-d \fIdisplayName\fP or -display \fIdisplayName\fP
.br
Use an alternate display.  If no display is specified on the command line,
xgrabsc looks for the environment variable DISPLAY for the name of the
display and screen to grab from.  Note that you must have permission to
access the display on another computer.
.TP
-bell
The display's bell is normally rung while the screen is being accessed.
This turns the bell on or off (\fI-nobell\fP will turn it \fIoff\fP).
.TP
-grab
Enable server grabs.  Normally xgrabsc will "grab" the server so
that the screen is frozen while a rectangle is selected and the image
is extracted.  If the screen is not frozen, rubber-banding may cause
video droppings on portions of the screen that are changing.  Use \fI-nograb\fP
to turn off server grabs.
.br
Server grabs are automatically disabled if \fBverbose\fP output is requested
to avoid freezing up the system.
.TP
-o \fIoutput-file\fP or -output \fIoutput-file\fP
.br
Write output to \fIoutput-file\fP instead of standard output.  The
output-file name, minus directory and extension, is used as the internal
name for the image in formats supporting image names.  Postscript,
xwd, pixmap and bitmap formats all support image names.
.TP
-s \fIseconds\fP or -sleep \fIseconds\fP
.br
Sleep for \fIseconds\fP seconds before commencing operation.  This
should be used if you need some time to get the target image ready.
.TP
-post \fIseconds\fP
Sleep for \fIseconds\fP seconds after window/rectangle selection.  This is
commonly used to pop up menus after a window has been selected but before
xgrabsc takes its snapshot.
.TP
-verbose
Display processing information on standard error output (stderr).
.sp 3
.\"
.\"
.\"
.\"
.\"
.SH SELECTION OPTIONS
.TP
-id \fIwindow ID\fP
Dump the window with the given ID.  ID numbers can be in decimal, or hexidecimal
(prefixed with "0x").  The name of a window can be given instead of an ID
number, and xgrabsc will look for the first window with that name.
.TP
-key
Select the window under the mouse when the Control key is pressed.  This
option is normally used in getting images of menus.  Pop up the menu,
optionally move the pointer to the window containing the menu, and strike
the Control key to begin the dump.
.TP
-root
Dump the entire screen (root window).
.TP
-stretch
Use rubber-band rectangle to select region to grab.  This is the
default.
.TP
-click
Wait for a click on a window and dump the selected window.
.TP
-coords \fIwidthxheight+x+y\fP
Selects the given area of the screen, without mouse or keyboard interaction.
Use this if you need to grab the same area of the screen over and over again.
Standard X coordinate notation can be used, but a width and height must be
given.
.TP
-coords \fIwidthxheight+x+y\fP
Offsets the area to be grabbed by x@y and changes the area's width and
height to widthxheight.  Using this you can grab a sub-area of the source
area, or even grab an area adjacent to the source area.
.\"
.\"
.\"
.\"
.\"
.sp 3
.SH IMAGE PROCESSING OPTIONS
.TP
-nobdrs or -noborders
.br
Remove window borders from window images.  This option applies only to
selection by ID (\fI\-id\fP) or xwd-style selection (\fI-click\fP).
.br
Note that Motif-style window frames are not window borders.  To remove these
you should use the \fI-noframe\fP option.  The xgrab window interface's
\fIInclude Borders\fP option removes both frames and borders.
.TP
-bdrs or -borders
.br
Include window-manager borders in window images.  This option
applies only to selection by ID (\fI\-id\fP) or xwd-style selection
(\fI-click\fP).  Use \fI-nobdrs\fP or \fI-noborders\fP to turn it off.
.TP
-b \fIpercent\fR or -brighten \fIpercent\fR
.br
brighten or darken the image by \fIpercent\fR.  Percentages are given
as integers. 100 is the base and a larger number will brighten the image
while a smaller number will darken the image.
.TP
-and \fIandBits\fR
Clear all colormap bits up to the given plane.  This has the effect of
darkening the image somewhat and shrinking the apparent depth of the image
(and, consequently, the size of the color table).  \fIAndBits\fR should
be in the range [1-8] inclusive.
.TP
-or \fIorBits\fR
Set all colormap bits up to the given plane.  This brightens the image
somewhat and also shrinks the apparent depth of the image.  When
both \-A and \-O are specified, ANDing will occur before ORing.
.TP
-reverse
Reverse the colors in the image.  The bits of each color used in the
image are inverted.
.TP
-bw
Convert the source color image to a monochrome bitmap.  All colors
falling below the average color intensity are mapped to black.  Others
are mapped to white.
.TP
-halftone
Convert the source color image to a halftoned monchrome bitmap.
Resolution is maintained by increasing the size of the image by
a factor of four on both axes.
.TP
-mdither
Convert the source color image to a dithered monochrome bitmap.
This is like halftoning, but resolution is sacrificed to keep the
resulting image the same size as the original.  The matrix dithering
algorithm used with this option is most suitable for line-drawings
and text.  For more complex graphics the \fI-dither\fR option is recommended.
.TP
-dither
Convert the source color image to a dithered monochrome bitmap with
the Floyd-Steinberg algorithm.
.TP
-nodither
Turns off any dithering.  Use this if your \fBXGRABSC\fP environment variable
specifies dithering and you want to override it to produce an undithered
image.
.TP
-colorWin \fIwindowId\fP
Specifies a window id (in hex) whose colormap should be used for the grabbed
image.  Generally xgrabsc will find the correct colormap for your image.
If you have lots of private colormaps around you may need to use this option
to ensure that xgrabsc selects the proper one.
.br
ID numbers can be in decimal, or hexidecimal (prefixed with "0x").  The name
of a window can be given instead of an ID number, and xgrabsc will look for
the first window with that name.
.sp 3
.\"
.\"
.\"
.\"
.SH OUTPUT FORMAT OPTIONS
.TP
-cps
Write output in \fIPostscript\fP format using the colorimage operator
for color printers.
Color to grayscale conversion is bundled into the output so you can actually
use either color or cheaper grayscale printers.  For monochrome displays, the
\fI-ps\fP option will give more compact output.
.TP
-ps
Write output in \fIPostscript\fP format for greyscale printers.
The number of bits per Postscript sample is determined by the depth of the
image.
.TP
-ppm
Write output in \fIPortable Bitmap\fP format.  Unix image viewers such as
\fBxv\fP and \fBImageMagick\fP can accept this format, and the
\fIPortable Bitmap\fP package can convert this to many other image formats.
.TP
-xwd
Write output in \fIxwd\fP format.  Use this if you want to convert to another
output format with \fBPbm+\fP.
.TP
Write output in \FIxwd -xy\fP format.  This is like xwd, but allows black and
white images to be written with eight pixels per byte instead of the default
one pixel per byte.  While xwud and xpr will handle this format, some programs
will not.
.TP
-bm
Write the output in X Bitmap format if the image is black and white, or
X Pixmap format if the image is gray or color.
.TP
-bm2
Write the output in X Bitmap format if the image is black and white, or
X Pixmap format 2 if the image is gray or color.
-bm3
Write the output in X Bitmap format if the image is black and white, or
X Pixmap format 3 if the image is gray or color.
.TP
-puzzle
Write output in a format suitable for loading into the \fIpuzzle\fP
program (see example below).
.sp 2
.\"
.\"
.\"
.\"
.\"
.SH POSTSCRIPT OPTIONS
.TP
-compress
Enable or suppress Postscript image run-length encoding.  Postscript output
is
normally compressed to minimize the size of output.  If your printer
can't handle compressed output, you should use \fI-nocompress\fP to turn
off compression.
.TP
-eps
Create Encapsulated Postscript output, rather than normal stand-alone
Postscript.  This adds EPSF header comments and removes all scaling and
translation of the image.
.TP
-l or -landscape
.br
Use landscape layout (with page width and height exchanged) for Postscript
output.  This option is ignored if Encapsulated Postscript output is requested.
Width and height may be specified with the -page option.
.TP
-bin
Write Postscript output in binary rather than using hexidecimal encoding.
This causes the image portion of the output to use half as much space,
decreasing transmission time to the printer.  Note that not all print
spoolers can handle 8 bit binary data, so this may not work on your system!
.TP
-limit
For Postscript output, check printer memory availability before attempting
to print an image (the code to perform the checks is integrated into the
output of xgrabsc).  This is turned off if Encapsulated Postscript output
is requested, and may be disabled completely when building the xgrabsc
program.  On the command line it may be turned off with \fI-nolimit\fP.
.TP
-preview or -prev
.br
Selects Encapsulated Postscript output with an EPSI preview image in its
header.  The preview image, if necessary, is dithered to black and white
either with
a default dithering algorithm or one you specify on the command line (e.g.,
\fI-mdither\fP).  Programs such as Frame use preview images to display
the postscript image during editing sessions.  If you don't have a preview
image, Frame will display a blank rectangle.  The image will print OK but
you won't see it while editing.
.TP
-previewonly
Like \fI-preview\fP but writes only the preview portion, not the postscript
image.  This may be used to add the preview to an existing EPS file after
having displayed it using a PostScript interpreter.
.TP
-page \fIwidthxheight-marginWidth-marginHeight\fP
Sets the size of the paper and the borders you desire around the edge of the
paper.  Xgrabsc will reduce the image if necessary to keep it within the
borders you specify.  The default page size and margins are set when
xgrabsc is built.  Measurements are in inches (e.g., 8.5x11.0-0.5-0.5)
.sp 3
.\"
.\"
.\"
.\"
.\"
.\"
.\"
.SH PROCESSING ORDER
It is helpful to know the order of processing when multiple processing
options are given on the command line.
.PP
Processing is done in five phases:  1) set up, 2) obtain image,
3) process colors, 4) poly->monochrome conversions, and 5) output conversion.
.PP
The set-up phase includes processing command-line options, sleeping,
connecting to X-Windows, freezing the screen, and grabbing the mouse if
necessary.
.PP
If the mouse is grabbed for rubber-banding, an upper-left-corner cursor is
displayed until the left mouse button is pressed.  A lower-left-corner
cursor is then displayed while drawing rubber-rectangles until the mouse
button is released.
.PP
If the mouse is grabbed for xwd-style window selection, an xwd-style cursor
is displayed until the left mouse button is pressed.
.PP
The mouse is then released.
.PP
The bell is then run and the image is pulled from the screen.
.PP
Following the image-grab, the bell is run twice and the screen is released.
.PP
If the image is not monochrome, the color manipulation functions are
then applied in this order: brighten, AND, and OR, reverse.
.PP
Only one polychrome to monochrome conversion is allowed.  If none of
these is chosen, the color table of a polychrome image is compressed
in preparation for output conversion.
.PP
The output stream is then opened and the image is written in the selected
output format.
.sp 2
.SH ENVIRONMENT
XGRABSC - specifies command line arguments to be processed before those
actually entered on the command line.
.PP
DISPLAY - specifies the name of the display that xgrabsc should grab from.
.sp 2
.SH EXAMPLES
The simplest form of use, giving Postscript output, is
.sp
.ti +5
xgrabsc >outfile.ps
.sp
.PP
To write output in \fIPostscript\fP format and send to the printer,
use
.sp
.ti +5
xgrabsc | lpr
.sp
It is sometimes helpful to brighten an image somewhat before it is
formatted for Postscript output.  E.g., to brighten by 30%
.sp
.ti +5
xgrabsc -b 130 | lpr
.sp
.PP
If your printer supports color, and your display is color, you can
have xgrabsc generate color output instead of gray scale:
.sp
.ti +5
xgrabsc -cps | lpr
.sp
.PP
The default Postscript output attempts to scale the image so that
it will all fit on one page, and is centered on the page.  If you
are grabbing images to include in documents, such as with FrameMaker,
you should ask for Encapsulated Postscript output with the \fI-eps\fP
switch.  For example:
.sp
.ti +5
  xgrabsc -eps -o image1.eps
.PP
To select an entire window, write output in \fIpuzzle\fP format
and read into the puzzle program, use the commands
.sp
.ti +5
xgrabsc -click -puzzle >outfile.pzl
.br
.ti +5
puzzle -picture outfile.pzl
.sp
.PP
To have xgrabsc sleep for three seconds before rubber-banding, display
processing information, and have the result displayed with xwud,
.sp
.ti +5
xgrabsc -xwd -verbose -s 3 | xwud
.sp
.PP
To grab an image from another server and then reduce the colormap
to three bits by ANDing, use
.sp
.ti +5
xgrabsc -d other:0.0 -and 5 -bm >outfile.xpm
.sp
You will, of course, have to go to the other machine to select the
image with that machine's mouse.
.PP
If you know the name or ID number of the window you want to snapshot
you can direct xgrabsc to that window on the command line.  Utilities
like xlswins or xwininfo can be used to find the names and ID numbers
of windows.
.sp
To grab an mpegplay image and display it in xwud, use
.ti +5
xgrabsc -xwd -id "MPEG Play" | xwud
.sp
You can also specify a sub-region to grab, as in
.ti +5
xgrabsc -xwd -id "MPEG Play" -offset 100x100+10+10 | xwud
.PP
Grabbing an area with the /fI-coords/fP option will use the root window's
colormap unless you specify an alternate window to use for color processing.
If your display allows more than one colormap to be installed at once and
you are displaying an mpeg video that uses a private colormap, your output
using the /fI-coords/fP command would be technicolor without a /fI-colorwin/fP
option specifying the mpeg window.  E.g.,
.ti +5
xgrabsc -xwd -coords 300x300+10+10 -colorwin "MPEG Play" | xwud
.sp 2
.SH LIMITATIONS
Colormaps larger than 256 entries are not currently supported. This
means that it won't work with your fancy 24-bit display.
.PP
The default screen visual is used as the visual for the image.
Visuals are associated with particular windows, and xgrabsc pretends
ignorance about any windows but the root.
.PP
This software has been tested with StaticGray and 8-plane PseudoColor
on DECStations (using both UWS 2.2 and X11 Release 4).  It has also
been tested with 8-plane PseudoColor on Sun SparcStations and various
other platforms using X11 Release 4 and Release 5.
.PP
X11 Pixmap format is rather verbose.
You may want to run large images through the \fIcompress\fP utility
before storing them in a file.  E.g.,
.sp
.ti +5
xgrabsc -bm | compress >outfile.xpm.Z
.sp
.SH AUTHOR
.nf
     Bruce Schuchardt
    GemStone Systems, Inc.
      bruce@slc.com
.fi
.sp 2
.SH ACKNOWLEGEMENTS
.PP
Some of the source code for xgrabsc came from
the xloadimage project by Jim Frost (jimf@saber.com) and others.  Jim's
copyright has been included both here and in the source code.
.PP
The idea for using run-length encoding for Postscript output came from
the xwd2ps project by Robert Tatar and Craig A. McGowan.
.PP
The ad2c.sed script that makes it possible to let you run xgrab without
installing XGrab.ad everywhere is part of the ad2c package developed by
George Ferguson.
.sp 2
.SH CONTRIBUTORS
.PP
Yves Arrouye wrote the EPS Preview and page-configuration enhancements.
.sp 2
.SH COPYRIGHT
Copyright (c) 1990-93 Bruce Schuchardt
.PP
\fIXgrabsc\fR is copywritten material with a very loose copyright
allowing unlimited modification and distribution if the copyright
notices are left intact.  Various portions are copywritten by various
people, but all use a modification of the MIT copyright notice.
Please check the cpyright.h for complete copyright information.  The
intent is to keep the source free, not to stifle its distribution, so
please write to me if you have any questions.
.PP
THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
USE OR PERFORMANCE OF THIS SOFTWARE.
.s 2
.SH SEE ALSO
X(1X), xhost(1), xwd(1X), xwud(1X), xwd2ps(1X), xloadimage(1X), xpm(1X),
xpr(1X), puzzle(1X), compress(1), uncompress(1), xv(1X)
