/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class LDAPMatchingRuleSchema
extends LDAPAttributeSchema {
    private String[] attributes;

    public LDAPMatchingRuleSchema(String string, String string2, String string3, String[] stringArray, int n) {
        super(string, string2, string3, n, true);
        this.attrName = "matchingrules";
        this.attributes = new String[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.attributes[n2] = new String(stringArray[n2]);
            ++n2;
        }
    }

    public LDAPMatchingRuleSchema(String string, String string2) {
        this.attrName = "matchingrules";
        this.oid = this.processRule(string);
        String string3 = this.processRule(string2);
        if (string3 != null && this.oid != null && !string3.equals(this.oid)) {
            System.err.println("Rule oid " + this.oid + " differs from use oid " + string3);
        }
        if (this.oid == null) {
            this.oid = string3;
        }
    }

    private String processRule(String string) {
        if (string == null) {
            return null;
        }
        string.trim();
        int n = string.length();
        string = string.substring(2, n - 1);
        n = string.length();
        int n2 = string.indexOf(32);
        String string2 = string.substring(0, n2);
        char[] cArray = new char[n];
        string = string.substring(n2 + 1, n);
        n = string.length();
        string.getChars(0, n, cArray, 0);
        n2 = 0;
        n = cArray.length;
        while (n2 < n) {
            String string3 = "";
            while (cArray[n2] == ' ') {
                ++n2;
            }
            int n3 = n2 + 1;
            while (n3 < n && cArray[n3] != ' ') {
                ++n3;
            }
            if (n2 < n && n3 < n) {
                string3 = new String(cArray, n2, n3 - n2);
                n2 = n3;
            } else {
                n2 = n;
            }
            while (n2 < n && cArray[n2] != '\'' && cArray[n2] != '(') {
                ++n2;
            }
            n3 = n2 + 1;
            while (n3 < n && cArray[n3] != '\'' && cArray[n3] != ')') {
                ++n3;
            }
            if (n2 >= n3 || n3 >= n) continue;
            String string4 = new String(cArray, n2 + 1, n3 - n2 - 1);
            n2 = n3 + 1;
            if (string3.equalsIgnoreCase("NAME")) {
                this.name = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("DESC")) {
                this.description = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("SYNTAX")) {
                this.syntax = this.syntaxCheck(string4);
                continue;
            }
            if (!string3.equalsIgnoreCase("APPLIES")) continue;
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (string5.equals("$")) continue;
                vector.addElement(string5);
            }
            this.attributes = new String[vector.size()];
            vector.copyInto(this.attributes);
            vector.removeAllElements();
            vector = null;
        }
        return string2;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public String getValue() {
        String string = "( " + this.oid + " NAME '" + this.name + "' DESC '" + this.description + "' SYNTAX '";
        string = String.valueOf(string) + this.internalSyntaxToString();
        string = String.valueOf(string) + "' )";
        return string;
    }

    public String getUseValue() {
        String string = "( " + this.oid;
        string = String.valueOf(string) + " APPLIES ( ";
        int n = 0;
        while (n < this.attributes.length) {
            if (n > 0) {
                string = String.valueOf(string) + " $ ";
            }
            string = String.valueOf(string) + this.attributes[n];
            ++n;
        }
        string = String.valueOf(string) + ") )";
        return string;
    }

    protected void update(LDAPConnection lDAPConnection, int n, String string) throws LDAPException {
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[]{new LDAPAttribute("matchingRules", this.getValue()), new LDAPAttribute("matchingRuleUse", this.getUseValue())};
        this.update(lDAPConnection, n, lDAPAttributeArray);
    }

    public String toString() {
        String string = "Name: " + this.name + "; OID: " + this.oid + "; Type: ";
        string = String.valueOf(string) + this.syntaxToString();
        string = String.valueOf(string) + "; Description: " + this.description;
        if (this.attributes != null) {
            string = String.valueOf(string) + "; Applies to: ";
            int n = 0;
            while (n < this.attributes.length) {
                if (n > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + this.attributes[n];
                ++n;
            }
        }
        return string;
    }
}

