#include "E.h"
#ifdef ARRANGE_TEST
#include <gdk/gdk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#endif

int                 ArrangeAddToList(int **array, int current_size, int value);
void                ArrangeSwapList(RectBox * list, int a, int b);

int
ArrangeAddToList(int **array, int current_size, int value)
{
  int                 i, j;

  EDBUG(8, "ArrangeAddToList");
  for (i = 0; i < current_size; i++)
    {
      if (value < (*array)[i])
	{
	  for (j = current_size; j > i; j--)
	    (*array)[j] = (*array)[j - 1];
	  (*array)[i] = value;
	  EDBUG_RETURN(current_size + 1);
	}
      else if (value == (*array)[i])
	EDBUG_RETURN(current_size);
    }
  (*array)[current_size] = value;
  EDBUG_RETURN(current_size + 1);
}

void
ArrangeSwapList(RectBox * list, int a, int b)
{
  RectBox             bb;

  EDBUG(8, "ArrangeSwapList");
  bb.data = list[a].data;
  bb.x = list[a].x;
  bb.y = list[a].y;
  bb.w = list[a].w;
  bb.h = list[a].h;
  list[a].data = list[b].data;
  list[a].x = list[b].x;
  list[a].y = list[b].y;
  list[a].w = list[b].w;
  list[a].h = list[b].h;
  list[b].data = bb.data;
  list[b].x = bb.x;
  list[b].y = bb.y;
  list[b].w = bb.w;
  list[b].h = bb.h;
  EDBUG_RETURN_;
}

void
ArrangeRects(RectBox * fixed, int fixed_count, RectBox * floating,
	     int floating_count, RectBox * sorted, int width, int height,
	     int policy)
{
  int                 num_sorted = 0;
  int                 xsize = 0, ysize = 0;
  int                *xarray = NULL, *yarray = NULL;
  int                *leftover = NULL;
  int                 i, j, k, x, y, x1, x2, y1, y2;
  unsigned char      *filled = NULL;
  RectBox            *spaces = NULL;
  int                 num_spaces = 0;
  int                 sort;
  int                 a1, a2;
  int                 num_leftover = 0;

  EDBUG(7, "ArrangeRects");
  switch (policy)
    {
    case ARRANGE_VERBATIM:
      break;
    case ARRANGE_BY_SIZE:
      sort = 0;
      while (!sort)
	{
	  sort = 1;
	  for (i = 0; i < floating_count - 1; i++)
	    {
	      a1 = floating[i].w * floating[i].h;
	      a2 = floating[i + 1].w * floating[i + 1].h;
	      if (a2 > a1)
		{
		  sort = 0;
		  ArrangeSwapList(floating, i, i + 1);
		}
	    }
	}
      break;
    case ARRANGE_BY_POSITION:
      sort = 0;
      while (!sort)
	{
	  sort = 1;
	  for (i = 0; i < floating_count - 1; i++)
	    {
	      a1 = floating[i].x + floating[i].y;
	      a2 = (floating[i + 1].x + (floating[i + 1].w >> 1)) +
		(floating[i + 1].y + (floating[i + 1].h >> 1));
	      if (a2 < a1)
		{
		  sort = 0;
		  ArrangeSwapList(floating, i, i + 1);
		}
	    }
	}
      break;
    default:
      break;
    }
/* for every floating rect in order, "fit" it into the sorted list */
  i = ((fixed_count + floating_count) * 2) + 2;
  xarray = Emalloc(i * sizeof(int));
  yarray = Emalloc(i * sizeof(int));
  filled = Emalloc(i * i * sizeof(char));

  spaces = Emalloc(i * i * sizeof(RectBox));
  if (floating_count)
    leftover = Emalloc(floating_count * sizeof(int));

  if (!xarray)
    {
      if (yarray)
	Efree(yarray);
      if (filled)
	Efree(filled);
      if (spaces)
	Efree(spaces);
      if (leftover)
	Efree(leftover);
      EDBUG_RETURN_;
    }
  if (!yarray)
    {
      Efree(xarray);
      if (filled)
	Efree(filled);
      if (spaces)
	Efree(spaces);
      if (leftover)
	Efree(leftover);
      EDBUG_RETURN_;
    }
  if (!filled)
    {
      Efree(xarray);
      Efree(yarray);
      if (spaces)
	Efree(spaces);
      if (leftover)
	Efree(leftover);
      EDBUG_RETURN_;
    }
  if (!spaces)
    {
      Efree(xarray);
      Efree(yarray);
      Efree(filled);
      if (leftover)
	Efree(leftover);
      EDBUG_RETURN_;
    }
/* copy "fixed" rects into the sorted list */
  for (i = 0; i < fixed_count; i++)
    {
      sorted[num_sorted].data = fixed[i].data;
      sorted[num_sorted].x = fixed[i].x;
      sorted[num_sorted].y = fixed[i].y;
      sorted[num_sorted].w = fixed[i].w;
      sorted[num_sorted].h = fixed[i].h;
      sorted[num_sorted].p = fixed[i].p;
      num_sorted++;
    }
/* go through each floating rect in order and "fit" it in */
  for (i = 0; i < floating_count; i++)
    {
      xsize = 0;
      ysize = 0;
/* put all the sorted rects into the xy arrays */
      xsize = ArrangeAddToList(&xarray, xsize, 0);
      xsize = ArrangeAddToList(&xarray, xsize, width);
      ysize = ArrangeAddToList(&yarray, ysize, 0);
      ysize = ArrangeAddToList(&yarray, ysize, height);
      for (j = 0; j < num_sorted; j++)
	{
	  if (sorted[j].x < width)
	    xsize = ArrangeAddToList(&xarray, xsize, sorted[j].x);
	  if ((sorted[j].x + sorted[j].w) < width)
	    xsize = ArrangeAddToList(&xarray, xsize, sorted[j].x + sorted[j].w);
	  if (sorted[j].y < height)
	    ysize = ArrangeAddToList(&yarray, ysize, sorted[j].y);
	  if ((sorted[j].y + sorted[j].h) < height)
	    ysize = ArrangeAddToList(&yarray, ysize, sorted[j].y + sorted[j].h);
	}
/* fill the allocation array */
      for (j = 0; j < (xsize - 1) * (ysize - 1); filled[j++] = 0);
      for (j = 0; j < num_sorted; j++)
	{
	  x1 = -1;
	  x2 = -1;
	  y1 = -1;
	  y2 = -1;
	  for (k = 0; k < xsize - 1; k++)
	    {
	      if (sorted[j].x == xarray[k])
		{
		  x1 = k;
		  x2 = k;
		}
	      if (sorted[j].x + sorted[j].w == xarray[k + 1])
		x2 = k;
	    }
	  for (k = 0; k < ysize - 1; k++)
	    {
	      if (sorted[j].y == yarray[k])
		{
		  y1 = k;
		  y2 = k;
		}
	      if (sorted[j].y + sorted[j].h == yarray[k + 1])
		y2 = k;
	    }
	  if ((x1 >= 0) && (x2 >= 0) && (y1 >= 0) && (y2 >= 0))
	    {
	      for (y = y1; y <= y2; y++)
		{
		  for (x = x1; x <= x2; x++)
		    {
		      if (filled[(y * (xsize - 1)) + x] < (sorted[j].p + 1))
			filled[(y * (xsize - 1)) + x] = sorted[j].p + 1;
		    }
		}
	    }
	}
      num_spaces = 0;
/* create list of all "spaces" */
      for (y = 0; y < ysize - 1; y++)
	{
	  for (x = 0; x < xsize - 1; x++)
	    {
/* if the square is empty (lowe prioiryt suares filled) "grow" the space */
	      if (filled[(y * (xsize - 1)) + x] < (floating[i].p + 1))
		{
		  int                 can_expand_x = 1;
		  int                 can_expand_y = 1;

		  x1 = x + 1;
		  y1 = y + 1;
		  filled[(y * (xsize - 1)) + x] = 100;
		  if (x >= xsize - 2)
		    can_expand_x = 0;
		  if (y >= ysize - 2)
		    can_expand_y = 0;
		  while ((can_expand_x) || (can_expand_y))
		    {
		      if (x1 >= xsize - 1)
			can_expand_x = 0;
		      if (y1 >= ysize - 1)
			can_expand_y = 0;
		      if (can_expand_x)
			{
			  for (j = y; j < y1; j++)
			    {
			      if (filled[(j * (xsize - 1)) + x1] >=
				  (floating[i].p + 1))
				can_expand_x = 0;
			    }
			}
		      if (can_expand_x)
			x1++;
		      if (can_expand_y)
			{
			  for (j = x; j < x1; j++)
			    {
			      if (filled[(y1 * (xsize - 1)) + j] >=
				  (floating[i].p + 1))
				can_expand_y = 0;
			    }
			}
		      if (can_expand_y)
			y1++;
		    }
		  spaces[num_spaces].x = xarray[x];
		  spaces[num_spaces].y = yarray[y];
		  spaces[num_spaces].w = xarray[x1] - xarray[x];
		  spaces[num_spaces].h = yarray[y1] - yarray[y];
		  spaces[num_spaces].p = 0;
		  num_spaces++;
		}
	    }
	}
/* find the first space that fits */
      k = -1;
      sort = 0x7fffffff;
      for (j = 0; j < num_spaces; j++)
	{
	  if ((spaces[j].w >= floating[i].w) &&
	      (spaces[j].h >= floating[i].h))
	    {
	      if (policy == ARRANGE_BY_POSITION)
		{
		  a1 = (spaces[j].x + (spaces[j].w >> 1)) -
		    (floating[i].x + (floating[i].w >> 1));
		  a2 = (spaces[j].y + (spaces[j].h >> 1)) -
		    (floating[i].y + (floating[i].h >> 1));
		  if (a1 < 0)
		    a1 = -a1;
		  if (a2 < 0)
		    a2 = -a2;
		  if ((a1 + a2) < sort)
		    {
		      sort = a1 + a2;
		      k = j;
		    }
		}
	      else
		{
		  k = j;
		  j = num_spaces;
		}
	    }
	}
      if (k >= 0)
	{
	  if (policy == ARRANGE_BY_POSITION)
	    {
	      a1 = (spaces[k].x + (spaces[k].w >> 1)) -
		(floating[i].x + (floating[i].w >> 1));
	      a2 = (spaces[k].y + (spaces[k].h >> 1)) -
		(floating[i].y + (floating[i].h >> 1));
	      if (a1 >= 0)
		sorted[num_sorted].x = spaces[k].x;
	      else
		sorted[num_sorted].x = spaces[k].x + spaces[k].w - floating[i].w;
	      if (a2 >= 0)
		sorted[num_sorted].y = spaces[k].y;
	      else
		sorted[num_sorted].y = spaces[k].y + spaces[k].h - floating[i].h;
	    }
	  else
	    {
	      sorted[num_sorted].x = spaces[k].x;
	      sorted[num_sorted].y = spaces[k].y;
	    }
	  sorted[num_sorted].data = floating[i].data;
	  sorted[num_sorted].w = floating[i].w;
	  sorted[num_sorted].h = floating[i].h;
	  sorted[num_sorted].p = floating[i].p;
	  num_sorted++;
	}
      else
	leftover[num_leftover++] = i;
    }
/* ok we cant fit everything in this baby.... time fit the leftovers into the */
/* leftover space */
  for (i = 0; i < num_leftover; i++)
    {
      xsize = 0;
      ysize = 0;
/* put all the sorted rects into the xy arrays */
      xsize = ArrangeAddToList(&xarray, xsize, 0);
      xsize = ArrangeAddToList(&xarray, xsize, width);
      ysize = ArrangeAddToList(&yarray, ysize, 0);
      ysize = ArrangeAddToList(&yarray, ysize, height);
      for (j = 0; j < num_sorted; j++)
	{
	  if (sorted[j].x < width)
	    xsize = ArrangeAddToList(&xarray, xsize, sorted[j].x);
	  if ((sorted[j].x + sorted[j].w) < width)
	    xsize = ArrangeAddToList(&xarray, xsize, sorted[j].x + sorted[j].w);
	  if (sorted[j].y < height)
	    ysize = ArrangeAddToList(&yarray, ysize, sorted[j].y);
	  if ((sorted[j].y + sorted[j].h) < height)
	    ysize = ArrangeAddToList(&yarray, ysize, sorted[j].y + sorted[j].h);
	}
/* fill the allocation array */
      for (j = 0; j < (xsize - 1) * (ysize - 1); filled[j++] = 0);
      for (j = 0; j < num_sorted; j++)
	{
	  x1 = -1;
	  x2 = -1;
	  y1 = -1;
	  y2 = -1;
	  for (k = 0; k < xsize - 1; k++)
	    {
	      if (sorted[j].x == xarray[k])
		{
		  x1 = k;
		  x2 = k;
		}
	      if (sorted[j].x + sorted[j].w == xarray[k + 1])
		x2 = k;
	    }
	  for (k = 0; k < ysize - 1; k++)
	    {
	      if (sorted[j].y == yarray[k])
		{
		  y1 = k;
		  y2 = k;
		}
	      if (sorted[j].y + sorted[j].h == yarray[k + 1])
		y2 = k;
	    }
	  if ((x1 >= 0) && (x2 >= 0) && (y1 >= 0) && (y2 >= 0))
	    {
	      for (y = y1; y <= y2; y++)
		{
		  for (x = x1; x <= x2; x++)
		    {
		      if (filled[(y * (xsize - 1)) + x] < (sorted[j].p + 1))
			filled[(y * (xsize - 1)) + x] = sorted[j].p + 1;
		    }
		}
	    }
	}
      num_spaces = 0;
/* create list of all "spaces" */
      for (y = 0; y < ysize - 1; y++)
	{
	  for (x = 0; x < xsize - 1; x++)
	    {
/* if the square is empty "grow" the space */
	      if (!filled[(y * (xsize - 1)) + x])
		{
		  int                 can_expand_x = 1;
		  int                 can_expand_y = 1;
		  char                fitswin = 1;

		  x1 = x + 1;
		  y1 = y + 1;
		  if (x >= xsize - 2)
		    can_expand_x = 0;
		  if (y >= ysize - 2)
		    can_expand_y = 0;
		  while ((can_expand_x) || (can_expand_y))
		    {
		      if (x1 >= xsize - 1)
			can_expand_x = 0;
		      if (y1 >= ysize - 1)
			can_expand_y = 0;
		      if (can_expand_x)
			{
			  for (j = y; j < y1; j++)
			    {
			      if (filled[(j * (xsize - 1)) + x1] >=
				  (floating[leftover[i]].p + 1))
				{
				  if (filled[(j * (xsize - 1)) + x1] >
				      (floating[leftover[i]].p + 1))
				    fitswin = 0;
				  can_expand_x = 0;
				}
			    }
			}
		      if (can_expand_x)
			x1++;
		      if (can_expand_y)
			{
			  for (j = x; j < x1; j++)
			    {
			      if (filled[(y1 * (xsize - 1)) + j] >=
				  (floating[leftover[i]].p + 1))
				{
				  if (filled[(y1 * (xsize - 1)) + j] >
				      (floating[leftover[i]].p + 1))
				    fitswin = 0;
				  can_expand_y = 0;
				}
			    }
			}
		      if (can_expand_y)
			y1++;
		    }
		  spaces[num_spaces].x = xarray[x];
		  spaces[num_spaces].y = yarray[y];
		  spaces[num_spaces].w = xarray[x1] - xarray[x];
		  spaces[num_spaces].h = yarray[y1] - yarray[y];
		  spaces[num_spaces].p = fitswin;
		  num_spaces++;
		}
	    }
	}
/* find the first space that fits */
      k = -1;
      sort = 0x7fffffff;
      a1 = floating[leftover[i]].w * floating[leftover[i]].h;
      k = -1;
      for (j = 0; j < num_spaces; j++)
	{
	  a2 = spaces[j].w * spaces[j].h;
	  if ((a2 != 0) && ((a1 - a2) < sort) && (spaces[j].p))
	    {
	      k = j;
	      sort = a1 - a2;
	    }
	}
/* if there's a small space ... */
      if (k >= 0)
	{
	  sorted[num_sorted].x = spaces[k].x;
	  sorted[num_sorted].y = spaces[k].y;
	  sorted[num_sorted].data = floating[leftover[i]].data;
	  sorted[num_sorted].w = floating[leftover[i]].w;
	  sorted[num_sorted].h = floating[leftover[i]].h;
	  if ((sorted[num_sorted].x + sorted[num_sorted].w) > width)
	    sorted[num_sorted].x = width - sorted[num_sorted].w;
	  if ((sorted[num_sorted].y + sorted[num_sorted].h) > height)
	    sorted[num_sorted].y = height - sorted[num_sorted].h;
	  if (sorted[num_sorted].x < 0)
	    sorted[num_sorted].x = 0;
	  if (sorted[num_sorted].y < 0)
	    sorted[num_sorted].y = 0;
	  num_sorted++;
	}
/* there is no room - put it centered (but dont put top left off screen) */
      else
	{
	  sorted[num_sorted].data = floating[leftover[i]].data;
	  sorted[num_sorted].x = (width - floating[leftover[i]].w) / 2;
	  sorted[num_sorted].y = (height - floating[leftover[i]].h) / 2;
	  sorted[num_sorted].w = floating[leftover[i]].w;
	  sorted[num_sorted].h = floating[leftover[i]].h;
	  if (sorted[num_sorted].x < 0)
	    sorted[num_sorted].x = 0;
	  if (sorted[num_sorted].y < 0)
	    sorted[num_sorted].y = 0;
	  num_sorted++;
	}
    }
/* free up memory */
  Efree(xarray);
  Efree(yarray);
  Efree(filled);
  Efree(spaces);
  if (leftover)
    Efree(leftover);
  for (i = 0; i < num_sorted; i++)
    {
      if ((sorted[i].x + sorted[i].w) > root.w)
	sorted[i].x = root.w - sorted[i].w;
      if ((sorted[i].y + sorted[i].h) > root.h)
	sorted[i].y = root.h - sorted[i].h;
      if (sorted[i].x < 0)
	sorted[i].x = 0;
      if (sorted[i].y < 0)
	sorted[i].y = 0;
    }
  EDBUG_RETURN_;
}

void
SnapEwin(EWin * ewin, int dx, int dy, int *new_dx, int *new_dy)
{
  EWin              **lst;
  int                 num, i;

  EDBUG(5, "SnapEwin");
  if (!mode.snap)
    {
      *new_dx = dx;
      *new_dy = dy;
      EDBUG_RETURN_;
    }
  lst = (EWin **) ListItemType(&num, LIST_TYPE_EWIN);
  if (dx < 0)
    {
      if IN_BELOW
	(ewin->x + dx, 0, mode.screen_snap_dist)
	  dx = 0 - ewin->x;
      else if (lst)
	{
	  for (i = 0; i < num; i++)
	    {
	      if (((ewin->desktop == lst[i]->desktop) || (lst[i]->sticky)) &&
		  (!(lst[i]->floating)) && (lst[i] != ewin) &&
		  (!(lst[i]->ignorearrange)))
		{
		  if (IN_BELOW(ewin->x + dx, lst[i]->x + lst[i]->w - 1,
			       mode.edge_snap_dist) &&
		      SPANS_COMMON(ewin->y, ewin->h, lst[i]->y, lst[i]->h))
		    {
		      dx = (lst[i]->x + lst[i]->w) - ewin->x;
		      break;
		    }
		}
	    }
	}
      if ((ewin->reqx - ewin->x) > 0)
	dx = 0;
    }
  else if (dx > 0)
    {
      if IN_ABOVE
	(ewin->x + ewin->w + dx, root.w, mode.screen_snap_dist)
	  dx = root.w - (ewin->x + ewin->w);
      else if (lst)
	{
	  for (i = 0; i < num; i++)
	    {
	      if (((ewin->desktop == lst[i]->desktop) || (lst[i]->sticky)) &&
		  (!(lst[i]->floating)) && (lst[i] != ewin) &&
		  (!(lst[i]->ignorearrange)))
		{
		  if (IN_ABOVE(ewin->x + ewin->w + dx - 1, lst[i]->x,
			       mode.edge_snap_dist) &&
		      SPANS_COMMON(ewin->y, ewin->h, lst[i]->y, lst[i]->h))
		    {
		      dx = lst[i]->x - (ewin->x + ewin->w);
		      break;
		    }
		}
	    }
	}
      if ((ewin->reqx - ewin->x) < 0)
	dx = 0;
    }
  if (dy < 0)
    {
      if IN_BELOW
	(ewin->y + dy, 0, mode.screen_snap_dist)
	  dy = 0 - ewin->y;
      else if (lst)
	{
	  for (i = 0; i < num; i++)
	    {
	      if (((ewin->desktop == lst[i]->desktop) || (lst[i]->sticky)) &&
		  (!(lst[i]->floating)) && (lst[i] != ewin) &&
		  (!(lst[i]->ignorearrange)))
		{
		  if (IN_BELOW(ewin->y + dy, lst[i]->y + lst[i]->h - 1,
			       mode.edge_snap_dist) &&
		      SPANS_COMMON(ewin->x, ewin->w, lst[i]->x, lst[i]->w))
		    {
		      dy = (lst[i]->y + lst[i]->h) - ewin->y;
		      break;
		    }
		}
	    }
	}
      if ((ewin->reqy - ewin->y) > 0)
	dy = 0;
    }
  else if (dy > 0)
    {
      if IN_ABOVE
	(ewin->y + ewin->h + dy, root.h, mode.screen_snap_dist)
	  dy = root.h - (ewin->y + ewin->h);
      else if (lst)
	{
	  for (i = 0; i < num; i++)
	    {
	      if (((ewin->desktop == lst[i]->desktop) || (lst[i]->sticky)) &&
		  (!(lst[i]->floating)) && (lst[i] != ewin) &&
		  (!(lst[i]->ignorearrange)))
		{
		  if (IN_ABOVE(ewin->y + ewin->h + dy - 1, lst[i]->y,
			       mode.edge_snap_dist) &&
		      SPANS_COMMON(ewin->x, ewin->w, lst[i]->x, lst[i]->w))
		    {
		      dy = lst[i]->y - (ewin->y + ewin->h);
		      break;
		    }
		}
	    }
	}
      if ((ewin->reqy - ewin->y) < 0)
	dy = 0;
    }
  if (lst)
    Efree(lst);
  *new_dx = dx;
  *new_dy = dy;
  EDBUG_RETURN_;
}

#ifdef ARRANGE_TEST
int
main(int argc, char **argv)
{
  GdkWindowAttr       attr;
  GdkWindow          *win;
  GdkColor            col;
  RectBox            *boxes, *sorted;
  int                 num, pol;
  int                 w, h, i;

  EDBUG(0, "main (arrange.c)");
  gdk_init(&argc, &argv);
  if (argc <= 1)
    {
      printf("Usage:\n arrange number\n");
      exit(1);
    }
  num = atoi(argv[1]);
  pol = atoi(argv[2]);
  w = 640;
  h = 480;
  attr.window_type = GDK_WINDOW_TOPLEVEL;
  attr.wclass = GDK_INPUT_OUTPUT;
  attr.event_mask = GDK_STRUCTURE_MASK;
  attr.width = w;
  attr.height = h;
  win = gdk_window_new(NULL, &attr, 0);
  gdk_window_show(win);
  boxes = Emalloc(num * sizeof(RectBox));
  sorted = Emalloc(num * sizeof(RectBox));
  srand(time(NULL));
  for (i = 0; i < num; i++)
    {
      sorted[i].data = NULL;
      boxes[i].w = (rand() % 40) + 10;
      boxes[i].h = (rand() % 30) + 10;
      boxes[i].x = (rand() % (640 - (boxes[i].w - 1)));
      boxes[i].y = (rand() % (480 - (boxes[i].h - 1)));
      attr.window_type = GDK_WINDOW_CHILD;
      attr.wclass = GDK_INPUT_OUTPUT;
      attr.event_mask = 0;
      attr.width = boxes[i].w;
      attr.height = boxes[i].h;
      attr.x = boxes[i].x;
      attr.y = boxes[i].y;
      boxes[i].data = gdk_window_new(win, &attr, GDK_WA_X | GDK_WA_Y);
      col.pixel = rand() % 65535;
      col.red = rand() % 65535;
      col.green = rand() % 65535;
      col.blue = rand() % 65535;
      gdk_window_set_background(boxes[i].data, &col);
      gdk_window_show(boxes[i].data);

    }
  gdk_flush();
  sleep(1);
  ArrangeRects(NULL, 0, boxes, num, sorted, 640, 480, pol);
  for (i = 0; i < num; i++)
    {
      if (sorted[i].data)
	gdk_window_move(sorted[i].data, sorted[i].x, sorted[i].y);
    }
  gdk_flush();
  sleep(20);
  EDBUG_RETURN(0);
}
#endif
