/*****************************************************************************/
/*  mkdir_dialog.c - make directory dialog box and ftp routines              */
/*  Copyright (C) 1998-1999 Brian Masney <masneyb@seul.org>                  */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include "ftp.h"

static void domkdir (GtkWidget *widget, struct dialog_data *data);

void mkdir_dialog (gpointer data) {
   struct ftp_window_data *wdata;
   
   wdata = (struct ftp_window_data *) data;
   if (!check_status (_("Mkdir"), wdata, 0, 0, 1)) return;

   MakeEditDialog (_("Make Directory"), _("Enter name of directory to create"), NULL, 1, 1,
   	_("Create"), domkdir, wdata, _("  Cancel  "), NULL, NULL);
}
/*****************************************************************************/
static void domkdir(GtkWidget *widget, struct dialog_data *data) {
   struct ftp_window_data *wdata;
   char *edttext;
   int success;
   
   wdata = (struct ftp_window_data *) data->data;
   edttext = gtk_entry_get_text (GTK_ENTRY (data->edit));
   if (*edttext == '\0') {
     ftp_log (gftp_logging_misc, NULL, _("Mkdir: Operation canceled...you must enter a string\n"));
     return;
   }
   if (wdata->local == 1) {
      success = mkdir (edttext, 488) == 0;
      if (!success) {
         ftp_log (gftp_logging_misc, NULL, _("Error: Could not make directory %s: %s\n"), edttext, g_strerror (errno));
      }
      else {
         ftp_log (gftp_logging_misc, NULL, _("Successfully made directory %s\n"), edttext);
      }
   }
   else {
      if (wdata->local == 2 && !ftp_connect (wdata->hdata, 0)) success = 0;
      else success = gftp_make_directory (wdata->hdata->ftpdata, edttext) == 0;
   }
   if (success) refresh ((gpointer) wdata);
}
/*****************************************************************************/
