#include <string.h>
#include "gnomeicu.h"

GtkWidget *contents;
GtkWidget *mainbox;
GtkWidget *next_button;
GtkWidget *window;
int nextid;

void NewUserFinish( GtkWidget *widget, gpointer data );
void NewUserCancel( GtkWidget *widget, gpointer data );
void NewUser2( GtkWidget *widget, GtkRadioButton *radiobutton );
void get_password( gchar *string, gpointer data );
void get_uin( gchar *string, gpointer data );

void NewUserFinish( GtkWidget *widget, gpointer data )
{
	static int been_called = 0;

#ifdef TRACE_FUNCTION
	g_print( "NewUserFinish\n" );
#endif
	
	if( been_called )
		gtk_main_quit();
	else
		been_called = 1;
}

void NewUserCancel( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "NewUserCancel\n" );
#endif

	gtk_main_quit();
	g_error("NewUserCancel()");
}

void NewUser2( GtkWidget *widget, GtkRadioButton *radiobutton )
{
	GtkWidget *pwdlg;

	gboolean selected;

#ifdef TRACE_FUNCTION
	g_print( "NewUser2\n" );
#endif

	selected = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radiobutton));

	if( selected )
		pwdlg = gnome_request_dialog( FALSE, _("Please enter your UIN"), "",
		                              0, (GnomeStringCallback)get_uin,
		                              NULL, GTK_WINDOW( window ) );
	else
		pwdlg = gnome_request_dialog( TRUE, _("Please enter your password"), "",
		                              8, (GnomeStringCallback)get_password,
		                              NULL, GTK_WINDOW( window ) );
	gtk_widget_show( pwdlg );

	if( !selected )
	{
		is_new_user = TRUE;
	}
}

void NewUserSignup( void )
{
	GtkWidget *label;
	GtkWidget *radiobutton;
	GtkWidget *box, *box2;
	GtkWidget *button;

#ifdef TRACE_FUNCTION
	g_print( "NewUserSignup\n" );
#endif

	window = gtk_window_new( GTK_WINDOW_DIALOG );
	gtk_window_set_title( GTK_WINDOW( window ), "GnomeICU: New User" );

	mainbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( window ), mainbox );
	gtk_widget_show( mainbox );
	
	contents = gtk_table_new( 3, 1, FALSE );
	gtk_box_pack_start( GTK_BOX( mainbox ), contents, FALSE, FALSE, 0 );
	
	label = gtk_label_new( "Welcome to GnomeICU" );
	gtk_table_attach( GTK_TABLE( contents ), label, 0, 1, 0, 1,
	                  GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5 );
	gtk_widget_show( label );
	
	box = gtk_vbox_new( FALSE, 0 );

	box2 = gtk_vbox_new( FALSE, 0 );
	gtk_table_attach( GTK_TABLE( contents ), box2, 0, 1, 1, 2,
	                  GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 15, 5 );
	gtk_widget_show( box2 );

	label = gtk_label_new( "Welcome to GnomeICU.  To assist you with" );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.0 );
	gtk_box_pack_start( GTK_BOX( box2 ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( "configuring this program, please fill" );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.0 );
	gtk_box_pack_start( GTK_BOX( box2 ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( "out the following information.  You will" );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.0 );
	gtk_box_pack_start( GTK_BOX( box2 ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( "not need to do this again, unless you" );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.0 );
	gtk_box_pack_start( GTK_BOX( box2 ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( "somehow remove your ~/.icq/gnomeicurc file." );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.0 );
	gtk_box_pack_start( GTK_BOX( box2 ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	box2 = gtk_vbox_new( FALSE, 0 );
	radiobutton = gtk_radio_button_new( NULL );

	label = gtk_label_new( "New ICQ # - Select this if you've never used" );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.0 );
	gtk_box_pack_start( GTK_BOX( box2 ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( "ICQ before, or if you don't remember your" );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.0 );
	gtk_box_pack_start( GTK_BOX( box2 ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	label = gtk_label_new( "nick or password." );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.0 );
	gtk_box_pack_start( GTK_BOX( box2 ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	gtk_container_add( GTK_CONTAINER( radiobutton ), box2 );
	gtk_widget_show( box2 );

	gtk_table_attach( GTK_TABLE( contents ), box, 0, 1, 2, 3,
	                  GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5 );
	gtk_box_pack_start( GTK_BOX( box ), radiobutton, FALSE, FALSE, 10 );
	gtk_widget_show( radiobutton );
	
	box2 = gtk_vbox_new( FALSE, 0 );
	radiobutton = gtk_radio_button_new( gtk_radio_button_group( GTK_RADIO_BUTTON( radiobutton ) ) );

	label = gtk_label_new( "Existing ICQ # - Select this if you already" );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.0 );
	gtk_box_pack_start( GTK_BOX( box2 ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	label = gtk_label_new( "have an account which you'd like to use with" );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.0 );
	gtk_box_pack_start( GTK_BOX( box2 ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	label = gtk_label_new( "GnomeICU." );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.0 );
	gtk_box_pack_start( GTK_BOX( box2 ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	gtk_container_add( GTK_CONTAINER( radiobutton ), box2 );
	gtk_widget_show( box2 );

	gtk_box_pack_start( GTK_BOX( box ), radiobutton, FALSE, FALSE, 10 );
	gtk_widget_show( radiobutton );

	box2 = gtk_hbutton_box_new();
	gtk_button_box_set_layout( GTK_BUTTON_BOX( box2 ),
	                           GTK_BUTTONBOX_SPREAD );
	gtk_box_pack_end( GTK_BOX( mainbox ), box2, FALSE, FALSE, 10 );
	gtk_widget_show( box2 );

	next_button = gtk_button_new_with_label( "Next" );
	gtk_widget_set_usize( next_button, 100, 30 );
	gtk_container_add( GTK_CONTAINER( box2 ), next_button );

	nextid = gtk_signal_connect( GTK_OBJECT( next_button ), "clicked",
	                             GTK_SIGNAL_FUNC( NewUser2 ), radiobutton );
	GTK_WIDGET_SET_FLAGS( next_button, GTK_CAN_DEFAULT );
	gtk_widget_grab_default( next_button );
	gtk_widget_show( next_button );
	
	button = gtk_button_new_with_label( "Cancel" );
	gtk_widget_set_usize( button, 100, 30 );
	gtk_container_add( GTK_CONTAINER( box2 ), button );

	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( NewUserCancel ), NULL );
	gtk_widget_show( button );

	gtk_widget_show( box );
	gtk_widget_show( contents );
	gtk_widget_show( window );

	gtk_main();

	gtk_widget_destroy( window );
}

void get_password( gchar *string, gpointer data )
{
	if( string != NULL && strlen( string ) )
		strcpy( passwd, string );
	else
	{
		gtk_main_quit();
		g_error( "get_password()" );
	}

	gtk_main_quit();
}

void get_uin( gchar *string, gpointer data )
{
	GtkWidget *pwdlg;

	if( string != NULL && strlen( string ) )
		our_info->uin = atoi( string );
	else
	{
		gtk_main_quit();
		g_error("get_uin()");
	}

	pwdlg = gnome_request_dialog( TRUE, _("Please enter your password"), "",
	                              8, (GnomeStringCallback)get_password,
	                              NULL, GTK_WINDOW( window ) );
}
