/*
 *  desktop -- The 3dfx Desktop Demo 
 *  COPYRIGHT 3DFX INTERACTIVE, INC. 1999
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _FLIGHT_H
#define _FLIGHT_H

#define PATHS_RETAINED 4

/* This module implements a flight model for the bird.  */
struct Flight_Model
{
  /* The birds current location */
  float X[3];

  /* The birds current velocity */
  float dX[3];

  /* The birds mass.  This is a fake sort of thing, since the attractors
   * and repellers don't have real masses.  This is basically a scaler for
   * the forces
   */
  float mass;
  
};

typedef struct Flight_Model Flight_Model;

/* This function determines a new velocity in which the bird should travel */
void
flight_update_position (Flight_Model *flight, Demo_State *state);



#endif
