/*
 *  desktop -- The 3dfx Desktop Demo 
 *  COPYRIGHT 3DFX INTERACTIVE, INC. 1999
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _GLOBAL_H
#define _GLOBAL_H

#include <sys/time.h>
#include <glide.h>
#include <glideutl.h>


#include "mathutil.h"
#include "model.h"


#define XPROG
#define GPROG
/* This define lets you know which window is which by drawing the number
 * over the window.  It is great for debugging but I have only made
 * 10 textures for numbers so if you want to use for that you need to
 * make more textures and adjust init.c to load them in load_textures.
 */
/*#define RENDER_WINDOW_NUMBERS*/

#define TITLE "3dfx Desktop"

/* Some interesting debug info */
/*#define PRINT_VERTS*/

/* Useful statistic */
/*#define PRINT_FPS*/

#define HTILES 4
#define VTILES 3

#define MEM_SIZE (256 * 256 * 2)

/* The next 5 all have to match */
#define DESKTOP_WIDTH  1280
#define DESKTOP_HEIGHT 1024 
#define GLIDE_WIDTH 1280
#define GLIDE_HEIGHT 1024
#define RESOLUTION GR_RESOLUTION_1280x1024

#define SQUARE_SIZE ((int)(256 * (float)GLIDE_WIDTH / (float)DESKTOP_WIDTH))

#define SCALE_FACTOR ((float)GLIDE_WIDTH / (float)DESKTOP_WIDTH)

/* This is the largest number of windows I will deal with */
#define WINDOW_MAX 200

#define DEPTH_FACTOR 20

#define DESKTOP_DEPTH (DEPTH_FACTOR * (float)WINDOW_MAX)



#define WAVE_WIDTH  10
#define WAVE_HEIGHT 8
extern GrVertex wave [(WAVE_WIDTH + 1) * (WAVE_HEIGHT + 1)];

/* Minimum size of a window that gets decorated */
#define MIN_WIN_WIDTH 128
#define MIN_WIN_HEIGHT 128

#define NTHUMBS 10


#define REFRESH 70
#define FRAMERATE 30
#define FRAMETIME_us  1000000.f / (FRAMERATE) 

/**********************************************************************
 * Spider Model Stuff
 **********************************************************************/
#define SPIDER_MIN_FRAME 1
#define SPIDER_MAX_FRAME 59

/**********************************************************************
 * Tux Model Stuff
 **********************************************************************/
#define TUX_WALK_MIN_FRAME 1
#define TUX_WALK_MAX_FRAME 89
#define TUX_WALK_FRAMES (TUX_WALK_MAX_FRAME - TUX_WALK_MIN_FRAME + 1)
#define TUX_JUMP_START_MIN_FRAME 1
#define TUX_JUMP_START_MAX_FRAME 90  /* Frame 91 is duplicate of the first in FLY */
#define TUX_JUMP_START_FRAMES (TUX_JUMP_START_MAX_FRAME - TUX_JUMP_START_MIN_FRAME + 1)
#define TUX_JUMP_END_MIN_FRAME 2     /* Frame 1 is duplicate of the last in FLY */
#define TUX_JUMP_END_MAX_FRAME 56    /* Frame 57 is duplicate of the first in WALK */
#define TUX_JUMP_END_FRAMES (TUX_JUMP_END_MAX_FRAME - TUX_JUMP_END_MIN_FRAME+1)
#define TUX_FLY_MIN_FRAME 1
#define TUX_FLY_MAX_FRAME 59
#define TUX_FLY_FRAMES (TUX_FLY_MAX_FRAME - TUX_FLY_MIN_FRAME + 1)
#define TUX_REST_MIN_FRAME 1
#define TUX_REST_MAX_FRAME 268
#define TUX_REST_FRAMES (TUX_REST_MAX_FRAME - TUX_REST_MIN_FRAME + 1)
#define TUX_TURN_MIN_FRAME 2    /* Frame 1 is duplicate of the last in WALK */
#define TUX_TURN_MAX_FRAME 108  /* Frame 109 is duplicate of the first in WALK */
#define TUX_TURN_FRAMES (TUX_TURN_MAX_FRAME - TUX_TURN_MIN_FRAME + 1)

/* Tux animation parameters */
#define TUX_MAX_H_VELOCITY 40
#define TUX_POSITION_TWEAK_Z  -12

/**********************************************************************
 * Bird Model stuff
 *********************************************************************/
#define BIRD_FLY_MIN_FRAME 1
#define BIRD_FLY_MAX_FRAME 24

/* The demo state */
enum Background_Type
{
  BACK_NONE,
  BACK_SKY,
  BACK_WAVE,
  BACK_LAST
};

/* What is tux up to */
enum Tux_State
{
  TUX_WALK,
  TUX_FLY,
  TUX_JUMP_START,
  TUX_JUMP_END,
  TUX_TURN,
  TUX_SIT,
  TUX_IDLE,
  TUX_NONE,
  TUX_LAST
};

typedef enum Background_Type Background_Type;
typedef enum Tux_State Tux_State;


struct Window_State;
struct Flight_Model;

struct Demo_State
{
  Background_Type back;
  int need_clears;

  struct timeval cur_frame_time;
  struct timeval prev_frame_time;
  time_t  delta_time;
  /* And the time as a floating point number */
  float dt;

  GrTexInfo sky;
  FxU32 sky_tex;

  GrTexInfo control;
  FxU32 control_tex;

  GrTexInfo highrise;
  FxU32 highrise_tex;

  GrTexInfo background[NTHUMBS];
  FxU32 background_tex[NTHUMBS];

  GrTexInfo numbers[10];
  FxU32 numbers_tex[10];

  FxU32 texloc;
  FxU32 texmin;
  FxU32 texmax;

  /* Background texturing data */
  FxU32 background_index;
  float background_texture_half_width;
  float background_texture_half_height;
  FxU32 background_clamp_mode;
  char *tile_string;
  
  float one_over_desktop_w;

  /* Data for the wave demo */
  float wave_amplitude;

  /* Window states */
  Window_State *wstates[WINDOW_MAX];
  int n_wstates;

  /* View settings */
  Matrix project, unproject;

  /* Model settings */
  Matrix model;
  Matrix identity;

  /* This is the flight model controling the flying thing */
  Flight_Model *flight;

  /* These are the models involved in the scene */
  Scene *tux_anim[TUX_LAST];
  Scene *spider_walk;
  Scene *bird_fly;

  /* There is one global tux character and this stuff describes him */
  int tux_frame;
  Vector tux_position;
  Vector tux_velocity;
  Vector tux_acceleration;
  Vector tux_destination;
  int tux_total_fly_frames;
  Window_State *tux_window;
  Window_State *tux_destination_window;
  Tux_State tux_state;
  int tux_fly_frame;
  Vector tux_a, tux_b, tux_c;
  float tux_direction;

  /* There is also one global bird and this stuff describes it */
  float bird_time;
  Vector bird_position;
  Window_State *bird_window;
  int bird_frame;

  /* These are matrices to get the basic orientation right for a model
   * */
  Matrix tux_orientation;
  Matrix tux_scale;
  Matrix spider_orientation;
  Matrix bird_orientation;
  Matrix bird_scale;
  Matrix bird_align;
};
typedef struct Demo_State Demo_State;

/* Declared in init.c */
extern char *bg_names[];

/* This stuff is for making glide3x behave like glide2x */
#ifdef USE_GLIDE3
extern FxU32 GR_WDEPTHVALUE_FARTHEST;
#endif

#endif
