/* $Id: droptarget.h,v 1.5 2000/05/02 02:17:15 waba Exp $
   $Log: droptarget.h,v $
   Revision 1.5  2000/05/02 02:17:15  waba
   WABA: Make it compile (kpopmenu / kimgio --> kpopupmenu / kimageio)

   Revision 1.4  1999/11/21 10:32:22  koss
   XPM -> PNG
   In offline mode we now draw offline icon, too.
   Settings are now read/written in class Settings.
   Remove parent, kmain is better.

   Revision 1.3  1999/11/15 20:17:03  koss
   Removed Windows 9x style.

   Revision 1.2  1999/07/01 18:03:44  koss
   merged with 1.1 version - some code cleanups, slotRestore() etc.

   Revision 1.1  1999/05/16 16:58:12  koss
   This is a shaped window, which stays always on top and can be used to
   drop URL's


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DROPTARGET_H
#define _DROPTARGET_H

#include <qwidget.h>
#include <qbitmap.h>
#include <qdragobject.h>

#include <kpopupmenu.h>

class KMainWidget;

class DropTarget : public QWidget {

  Q_OBJECT

public:
  DropTarget();
  ~DropTarget();

  void setAnim( int i1, int i2, int i3, int i4, bool online );

protected:
  virtual void resizeEvent( QResizeEvent * );

  // drag and drop
  void dragEnterEvent( QDragEnterEvent * );
  void dropEvent( QDropEvent * );

private slots:

  void toggleSticky();

  void mousePressEvent(QMouseEvent *e);
  void toggleMinimizeRestore();

private:
  KPopupMenu *popupMenu;
  KMainWidget *parent;

  bool b_sticky;

  int pop_sticky;

  int size[4];

  QPixmap *handpix1;
  QPixmap *handpix2;
  QPixmap *handpix3;

  QBitmap mask;
};

#endif // _DROPTARGET_H
