/* $Id: main.cpp,v 1.29 2000/04/10 20:42:35 koss Exp $
   $Log: main.cpp,v $
   Revision 1.29  2000/04/10 20:42:35  koss
   Reworked version information.
   Now passing aboutdata to khelpmenu.
   Fixed whatsthis, but it works only for menu items and not for
   toolbar. Is it a bug ?
   Some fixes for actions, still not fully working.

   Revision 1.28  2000/04/10 15:08:54  koss
   removed some comments

   Revision 1.27  2000/03/19 17:55:32  koss
   added about data

   Revision 1.26  2000/02/13 19:32:05  faure
   make it compile (damn X headers)

   Revision 1.25  2000/01/14 12:49:35  waba
   WABA: Use KCmdLineArgs

   Revision 1.18  1999/10/22 20:38:21  koss
   Removed all IPC code.
   Switched to KUniqueApplication.

   Revision 1.14  1999/09/23 23:06:12  shausman
   - more cuteidl porting

   Revision 1.13  1999/09/04 19:17:22  shausman
   - catching up with Konqueror's new plugin system

   Revision 1.12  1999/07/01 18:33:44  koss
   fixed signal catching


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <kwin.h>
#include <kdebug.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>

#include <dirent.h>
#include <sys/stat.h>
#include <signal.h>
#include <unistd.h>
#include <stdio.h>

#include "kmainwidget.h"
#include "version.h"
#include "main.h"

static const char *description = 
	I18N_NOOP("An advanced download manager for KDE.");

static const char *version = CAITOOVERSION;


static KCmdLineOptions option[] =
{
   { "+[URL(s)]", I18N_NOOP("URL(s) to download."), 0 },
   { 0, 0, 0 }
};

static void cleanup(void);
static void setSignalHandler(void (*handler)(int));

static msg_handler oldMsgHandler = 0L;

//-----------------------------------------------------------------------------
// Crash recovery signal handler
static void signalHandler( int sigId ) {
  fprintf(stderr, "*** Caitoo got signal %d\n", sigId);

  if ( sigId != SIGSEGV && kmain ) {
    fprintf(stderr, "*** Caitoo saving data\n");
    delete kmain;
  }

  // If Caitoo crashes again below this line we consider the data lost :-|
  // Otherwise Caitoo will end in an infinite loop.
  setSignalHandler(SIG_DFL);
  cleanup();
  exit(1);
}


//-----------------------------------------------------------------------------
static void setSignalHandler( void (*handler)(int) ) {
  signal(SIGSEGV, handler);
  signal(SIGKILL, handler);
  signal(SIGTERM, handler);
  signal(SIGHUP,  handler);
  signal(SIGFPE,  handler);
  signal(SIGABRT, handler);

  // catch also the keyboard interrupt
  signal(SIGINT, handler);
}


static void cleanup( void ) {
  qInstallMsgHandler(oldMsgHandler);
  QString cmd;
}


CaitooApp::CaitooApp( )
  : KUniqueApplication() {

  if (isRestored()) {
    RESTORE(KMainWidget)
  } else {
    new KMainWidget();
  }
  
  setMainWidget(kmain);
}


int CaitooApp::newInstance() {
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  // process arguments
  for(int i = 0; i < args->count(); i++)
  {
     kmain->addTransfer( args->arg(i) );
  }
  args->clear();

  KWin::setActiveWindow( kmain->winId() );
  return 0;
}


/////////////////////////////////////////////////////////////////

int main( int argc, char *argv[] ) {
  KAboutData aboutData( "caitoo", I18N_NOOP("Caitoo"),
			version, description, KAboutData::License_GPL,
			"(c) 1998 - 2000, Matej Koss");
  aboutData.addAuthor("Matej Koss",0, "koss@miesto.sk");

  KCmdLineArgs::init(argc, argv, &aboutData);
  KCmdLineArgs::addCmdLineOptions( option );

  if ( ! CaitooApp::start()) {
    exit(0); // Don't do anything if we are already running TODO: check
  }

  CaitooApp app;
  setSignalHandler(signalHandler);

  app.exec();

  cleanup();
}
