/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _RESULTVIEW_H_
#define _RESULTVIEW_H_


#include <qlistview.h>


class ResultView;

class ResultViewItem : public QListViewItem
{
public:
    ResultViewItem( QListView *parent, QString icon, QString name, QString url,
		    int relevance, QString details );
    virtual QString key(int col, bool ascending) const;
    virtual QString text(int col) const;
    virtual void paintCell(QPainter *p, const QColorGroup &cg,
			   int col, int width, int align);

    enum { NameColumn = 0, RelevanceColumn = 1, SiteColumn = 2 };
private:
    int m_relevance;
    QString m_url;
    QString m_details;
    friend class ResultView;
};


class ResultView : public QListView
{
    Q_OBJECT
    
public:
    ResultView( QWidget *parent=0, const char *name=0 );

    //virtual void widthChanged(const QListViewItem *item, int col);
    void insertItem(QString icon, QString name, QString url,
		    int relevance, QString details);
    
signals:
    void urlActivated(QString url);
    void detailsActivated(QString details);

protected slots:
    void itemActivated(QListViewItem *item);
    void itemSelected(QListViewItem *item);

protected:
    virtual QSizePolicy sizePolicy () const  
        { return QSizePolicy(QSizePolicy::MinimumExpanding,
                             QSizePolicy::MinimumExpanding); }     
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
