
#include<assert.h>

#include<qwidget.h>
#include<qstring.h>
#include<qtooltip.h>
#include<qpainter.h>
#include<qcolor.h>

#include<kiconloader.h>
#include<kglobal.h>
#include<kprocess.h>

#include"kornbutt.h"
#include"maildrop.h"

KornButton::KornButton( QWidget *parent, KMailDrop *box )
	: QToolButton( parent, "kornbutton" ),
	_drawColour( foregroundColor() )
{
	assert( box );

	_box = box;

	_lastNum = 0;
	_reversed = false;
	
	monitorUpdated();

	connect( _box, SIGNAL( changed( int ) ),
			this, SLOT( setNumber( int )));
	connect( _box, SIGNAL(notifyDisconnect()),
			this, SLOT(disconnectMonitor()));
	connect( _box, SIGNAL(configChanged()),
			this, SLOT(monitorUpdated()));

	connect(this, SIGNAL( leftClick() ),	SLOT( runIfUnread() ));
	connect(this, SIGNAL( middleClick() ),	_box,
		SLOT( forceCountZero() ));
	connect(this, SIGNAL( doubleClick() ),	SLOT( runCommand() ));

//	setNumber( _box->count() );
	_box->startMonitor();
}

void KornButton::setNumber(int num)
{

	if( num == _lastNum )
		return;

	if( (num >= _lastNum && !_reversed) || ( !num && _reversed )) {
		_reversed = ! _reversed;	
	}

	if( _box && num > _lastNum && _box->newmailCmd() != 0 ) {
		KShellProcess proc;
		proc << _box->newmailCmd();
		proc.start( KShellProcess::DontCare );
	}
		
	_lastNum = num;

	//	adjustSize();
	repaint();

}

void KornButton::drawButton( QPainter *painter )
{
	QToolButton::drawButton ( painter );
	QString *str= new QString;

	str->setNum(_lastNum);

	if( _reversed ){
		// draw reversed
		painter->fillRect(1, 1, width()-1, height()-1, _drawColour );
		painter->setPen( backgroundColor() );
	}
	else {
		// draw normal
		painter->setPen( _drawColour );
	}

	painter->drawText(0, 0, width(), height(), AlignCenter, str->data() );

	delete str;
}

void KornButton::resizeEvent( QResizeEvent * )
{
	if ( backgroundMode() == FixedPixmap && !_bg.isNull() ) {
		QWMatrix m;

		m.scale( (double)width()/(double)_bg.width(),
				(double)height() / (double)_bg.height() );
		setBackgroundPixmap( _bg.xForm( m ) );
	}
}

void KornButton::runCommand()
{
	if( _box && _box->clickCmd() != 0 ) {
		KShellProcess proc;
		proc << _box->clickCmd();
		proc.start( KShellProcess::DontCare );
	}
}

void KornButton::mouseDoubleClickEvent( QMouseEvent * )
{
	emit doubleClick();
}

void KornButton::mouseReleaseEvent( QMouseEvent *event )
{
	switch ( event->button() ) {
		case LeftButton:	
			emit leftClick();
			break;

		case MidButton:
			emit middleClick();

		default:
			break;
	}

	QToolButton::mouseReleaseEvent( event );
}

void KornButton::mousePressEvent( QMouseEvent *event )
{
	QToolButton::mouseReleaseEvent( event );
//	QToolButton::leaveEvent( event );

	if ( event->button() == RightButton ) {
		emit rightClick();
	}
}

void KornButton::runIfUnread()
{
	if( _box == 0 ) return;

	_box->recheck();

	if( _box->count() != 0 ) {
		runCommand();
	}
}

void KornButton::disconnectMonitor()
{
	_box->stopMonitor();
	_box = 0;

	emit dying( this );
}

void KornButton::monitorUpdated()
{
	QToolTip::remove( this );
	QToolTip::add( this, _box->caption() );

	bool colourSet = false;
	bool clearBack = true;

	if( _box->colour() ) {
		if( _box->hlColour() ) {
		// set highlight colour
			_drawColour = *_box->hlColour();
			colourSet = true;
		}

		if( _box->bgTexture() ) {
		// set texture
			_bg = BarIcon( _box->bgTexture() );

			if ( !_bg.isNull() ) {
				QWMatrix m;

				m.scale( (double)width()/(double)_bg.width(),
					(double)height() / (double)_bg.height() );
				setBackgroundPixmap( _bg.xForm( m ) );

				clearBack = false;
			}
		}
	}

	if ( !colourSet ) {
		_drawColour = foregroundColor();
	}

	if( clearBack ) {
		setBackgroundMode( PaletteBackground );
	}

	if( _lastNum < _box->count() ) {
		_reversed = true;
	}
	_lastNum = _box->count();

	repaint();
}
