/*********************************************************************
 *
 * This is based on code created by Peter Harvey,
 * (pharvey@codebydesign.com).
 *
 * Modified and extended by Nick Gorham
 * (nick@easysoft.com).
 *
 * Any bugs or problems should be considered the fault of Nick and not
 * Peter.
 *
 * copyright (c) 1999 Nick Gorham
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **********************************************************************
 *
 * $Id: SQLDataSources.c,v 1.2 1999/12/10 01:50:32 harvey Exp $
 *
 * $Log: SQLDataSources.c,v $
 * Revision 1.2  1999/12/10 01:50:32  harvey
 * Updated with current sources from unixODBC cvs.
 *
 * Revision 1.7  1999/11/13 23:40:59  ngorham
 *
 * Alter the way DM logging works
 * Upgrade the Postgres driver to 6.4.6
 *
 * Revision 1.6  1999/10/24 23:54:17  ngorham
 *
 * First part of the changes to the error reporting
 *
 * Revision 1.5  1999/09/21 22:34:24  ngorham
 *
 * Improve performance by removing unneeded logging calls when logging is
 * disabled
 *
 * Revision 1.4  1999/07/10 21:10:16  ngorham
 *
 * Adjust error sqlstate from driver manager, depending on requested
 * version (ODBC2/3)
 *
 * Revision 1.3  1999/07/04 21:05:07  ngorham
 *
 * Add LGPL Headers to code
 *
 * Revision 1.2  1999/06/30 23:56:54  ngorham
 *
 * Add initial thread safety code
 *
 * Revision 1.1.1.1  1999/05/29 13:41:05  sShandyb
 * first go at it
 *
 * Revision 1.1.1.1  1999/05/27 18:23:17  pharvey
 * Imported sources
 *
 * Revision 1.2  1999/05/09 23:27:11  nick
 * All the API done now
 *
 * Revision 1.1  1999/04/25 23:06:11  nick
 * Initial revision
 *
 *
 **********************************************************************/

#include "drivermanager.h"

static char const rcsid[]= "$RCSfile: SQLDataSources.c,v $ $Revision: 1.2 $";

#define BUFFERSIZE      1024

SQLRETURN SQLDataSources( SQLHENV environment_handle,
           SQLUSMALLINT direction,
           SQLCHAR *server_name,
           SQLSMALLINT buffer_length1,
           SQLSMALLINT *name_length1,
           SQLCHAR *description,
           SQLSMALLINT buffer_length2,
           SQLSMALLINT *name_length2 )
{
    DMHENV environment = (DMHENV) environment_handle;
    SQLRETURN ret;
    char buffer[ BUFFERSIZE + 1 ];
    char object[ INI_MAX_OBJECT_NAME + 1 ];
    char property[ INI_MAX_PROPERTY_VALUE + 1 ];
    SQLCHAR s0[ 20 ];

    if ( !__validate_env( environment ))
    {
        return SQL_INVALID_HANDLE;
    }

    function_entry( environment );

    if ( environment -> log_handle )
    {
        sprintf( environment -> msg, "\n\t\tEntry:\
            \n\t\t\tEnvironment = %p",
                environment );

        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                environment -> msg );
    }

    thread_protect( SQL_HANDLE_ENV, environment );

    /*
     * check that a version has been requested
     */

    if ( environment -> requested_version == 0 )
    {
        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: HY010" );

        __post_internal_error( &environment -> error,
                ERROR_HY010, NULL,
                environment -> requested_version );

        thread_release( SQL_HANDLE_ENV, environment );

        return function_return( environment, SQL_ERROR );
    }

    if ( buffer_length1 < 0 || buffer_length2 < 0 )
    {
        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: HY090" );

        __post_internal_error( &environment -> error,
                ERROR_HY090, NULL,
                environment -> requested_version );

        thread_release( SQL_HANDLE_ENV, environment );

        return function_return( environment, SQL_ERROR );
    }

    if ( direction != SQL_FETCH_FIRST &&
            direction != SQL_FETCH_FIRST_USER &&
            direction != SQL_FETCH_FIRST_SYSTEM &&
            direction != SQL_FETCH_NEXT )
    {
        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: HY103" );

        __post_internal_error( &environment -> error,
                ERROR_HY103, NULL,
                environment -> requested_version );

        thread_release( SQL_HANDLE_ENV, environment );

        return function_return( environment, SQL_ERROR );
    }

    /*
     * for this function USER = "~/.odbc.ini" and
     * SYSTEM = "/usr/odbc.ini
     */

    if ( direction == SQL_FETCH_FIRST )
    {
        environment -> fetch_mode = ODBC_BOTH_DSN;
        environment -> entry = 0;
    }
    else if ( direction == SQL_FETCH_FIRST_USER )
    {
        environment -> fetch_mode = ODBC_USER_DSN;
        environment -> entry = 0;
    }
    else if ( direction == SQL_FETCH_FIRST_SYSTEM )
    {
        environment -> fetch_mode = ODBC_SYSTEM_DSN;
        environment -> entry = 0;
    }

    /*
     * this is lifted from Peters code
     */

    memset( buffer, 0, sizeof( buffer ));
    memset( object, 0, sizeof( object ));
    SQLSetConfigMode( environment -> fetch_mode );

    SQLGetPrivateProfileString( NULL, NULL, NULL,
            buffer, sizeof( buffer ),
            ".odbc.ini" );

    if ( iniElement( buffer, '\0', '\0',
                environment -> entry,
                object, sizeof( object )) != INI_SUCCESS )
    {
        ret = SQL_NO_DATA;
    }
    else
    {
        memset( buffer, 0, sizeof( buffer ));
        memset( property, 0, sizeof( property ));
        SQLGetPrivateProfileString( object, "Description", "",
                property, sizeof( property ), ".odbc.ini" );
        environment -> entry++;

        if (( server_name &&  buffer_length1 <= strlen( object )) ||
            ( description && buffer_length2 <= strlen( property )))
        {
            __post_internal_error( &environment -> error,
                    ERROR_01004, NULL,
                    environment -> requested_version );
            ret = SQL_SUCCESS_WITH_INFO;
        }
        else
        {
            ret = SQL_SUCCESS;
        }

        if ( server_name )
        {
            if ( buffer_length1 <= strlen( object ))
            {
                memcpy( server_name, object, buffer_length1 );
                server_name[ buffer_length1 - 1 ] = '\0';
            }
            else
            {
                strcpy( server_name, object );
            }
        }

        if ( description )
        {
            if ( buffer_length2 <= strlen( property ))
            {
                memcpy( description, property, buffer_length2 );
                description[ buffer_length1 - 1 ] = '\0';
            }
            else
            {
                strcpy( description, property );
            }
        }

        if ( name_length1 )
        {
            *name_length1 = strlen( object );
        }
        if ( name_length2 )
        {
            *name_length2 = strlen( property );
        }
    }

    /* NEVER FORGET TO RESET THIS TO ODBC_BOTH_DSN */
    SQLSetConfigMode( ODBC_BOTH_DSN );

    if ( environment -> log_handle )
    {
        sprintf( environment -> msg, 
                "\n\t\tExit:[%s]",
                    __get_return_status( SQL_SUCCESS ));

        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                environment -> msg );
    }

    thread_release( SQL_HANDLE_ENV, environment );

    return function_return( environment, ret );
}
