/*********************************************************************
 *
 * This is based on code created by Peter Harvey,
 * (pharvey@codebydesign.com).
 *
 * Modified and extended by Nick Gorham
 * (nick@easysoft.com).
 *
 * Any bugs or problems should be considered the fault of Nick and not
 * Peter.
 *
 * copyright (c) 1999 Nick Gorham
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **********************************************************************
 *
 * $Id: SQLForeignKeys.c,v 1.2 1999/12/10 01:50:34 harvey Exp $
 *
 * $Log: SQLForeignKeys.c,v $
 * Revision 1.2  1999/12/10 01:50:34  harvey
 * Updated with current sources from unixODBC cvs.
 *
 * Revision 1.7  1999/11/13 23:40:59  ngorham
 *
 * Alter the way DM logging works
 * Upgrade the Postgres driver to 6.4.6
 *
 * Revision 1.6  1999/10/24 23:54:18  ngorham
 *
 * First part of the changes to the error reporting
 *
 * Revision 1.5  1999/09/21 22:34:24  ngorham
 *
 * Improve performance by removing unneeded logging calls when logging is
 * disabled
 *
 * Revision 1.4  1999/07/10 21:10:16  ngorham
 *
 * Adjust error sqlstate from driver manager, depending on requested
 * version (ODBC2/3)
 *
 * Revision 1.3  1999/07/04 21:05:07  ngorham
 *
 * Add LGPL Headers to code
 *
 * Revision 1.2  1999/06/30 23:56:54  ngorham
 *
 * Add initial thread safety code
 *
 * Revision 1.1.1.1  1999/05/29 13:41:07  sShandyb
 * first go at it
 *
 * Revision 1.1.1.1  1999/05/27 18:23:17  pharvey
 * Imported sources
 *
 * Revision 1.3  1999/05/03 19:50:43  nick
 * Another check point
 *
 * Revision 1.2  1999/04/30 16:22:47  nick
 * Another checkpoint
 *
 * Revision 1.1  1999/04/25 23:06:11  nick
 * Initial revision
 *
 *
 **********************************************************************/

#include "drivermanager.h"

static char const rcsid[]= "$RCSfile: SQLForeignKeys.c,v $ $Revision: 1.2 $";

SQLRETURN SQLForeignKeys(
    SQLHSTMT           statement_handle,
    SQLCHAR            *szpk_catalog_name,
    SQLSMALLINT        cbpk_catalog_name,
    SQLCHAR            *szpk_schema_name,
    SQLSMALLINT        cbpk_schema_name,
    SQLCHAR            *szpk_table_name,
    SQLSMALLINT        cbpk_table_name,
    SQLCHAR            *szfk_catalog_name,
    SQLSMALLINT        cbfk_catalog_name,
    SQLCHAR            *szfk_schema_name,
    SQLSMALLINT        cbfk_schema_name,
    SQLCHAR            *szfk_table_name,
    SQLSMALLINT        cbfk_table_name )
{
    DMHSTMT statement = (DMHSTMT) statement_handle;
    SQLRETURN ret;
    SQLCHAR s0[ 20 ], s1[ 100 ], s2[ 100 ], s3[ 100 ], s4[ 100 ];
    SQLCHAR s5[ 100 ], s6[ 100 ];

    /*
     * check statement
     */

    if ( !__validate_stmt( statement ))
    {
        return SQL_INVALID_HANDLE;
    }
    
    function_entry( statement );

    if ( statement -> log_handle )
    {
        sprintf( statement -> msg, "\n\t\tEntry:\
            \n\t\t\tStatement = %p\
            \n\t\t\tPK Catalog Name = %s\
            \n\t\t\tPK Schema Name = %s\
            \n\t\t\tPK Table Name = %s\
            \n\t\t\tFK Catalog Name = %s\
            \n\t\t\tFK Schema Name = %s\
            \n\t\t\tFK Table Name = %s",
                statement,
                __string_with_length( s1, szpk_catalog_name, cbpk_catalog_name ), 
                __string_with_length( s2, szpk_schema_name, cbpk_schema_name ), 
                __string_with_length( s3, szpk_table_name, cbpk_table_name ), 
                __string_with_length( s4, szfk_catalog_name, cbfk_catalog_name ), 
                __string_with_length( s5, szfk_schema_name, cbfk_schema_name ), 
                __string_with_length( s6, szfk_table_name, cbfk_table_name ));

        dm_log_write( statement -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                statement -> msg );
    }

    thread_protect( SQL_HANDLE_STMT, statement );

    if (( cbpk_catalog_name < 0 && cbpk_catalog_name != SQL_NTS ) ||
            ( cbpk_schema_name < 0 && cbpk_schema_name != SQL_NTS ) ||
            ( cbpk_table_name < 0 && cbpk_table_name != SQL_NTS ) ||
            ( cbfk_catalog_name < 0 && cbfk_catalog_name != SQL_NTS ) ||
            ( cbfk_schema_name < 0 && cbfk_schema_name != SQL_NTS ) ||
            ( cbfk_table_name < 0 && cbfk_table_name != SQL_NTS ))
    {
        __post_internal_error( &statement -> error,
                ERROR_HY090, NULL,
                statement -> connection -> environment -> requested_version );

        thread_release( SQL_HANDLE_STMT, statement );

        return function_return( statement, SQL_ERROR );
    }

    /*
     * check states
     */

    if ( statement -> state == STATE_S5 ||
            statement -> state == STATE_S6 ||
            statement -> state == STATE_S7 )
    {
        dm_log_write( statement -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: 24000" );

        __post_internal_error( &statement -> error,
                ERROR_24000, NULL,
                statement -> connection -> environment -> requested_version );

        thread_release( SQL_HANDLE_STMT, statement );

        return function_return( statement, SQL_ERROR ); 
    }
    else if ( statement -> state == STATE_S8 ||
            statement -> state == STATE_S9 ||
            statement -> state == STATE_S10 )
    {
        dm_log_write( statement -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: HY010" );

        __post_internal_error( &statement -> error,
                ERROR_HY010, NULL,
                statement -> connection -> environment -> requested_version );

        thread_release( SQL_HANDLE_STMT, statement );

        return function_return( statement, SQL_ERROR );
    }

    if ( statement -> state == STATE_S11 ||
            statement -> state == STATE_S12 )
    {
        if ( statement -> interupted_func != SQL_API_SQLFOREIGNKEYS )
        {
            dm_log_write( statement -> log_handle, 
                    __get_pid( s0 ), 
                    __FILE__, 
                    __LINE__, 
                    LOG_INFO, 
                    LOG_INFO, 
                    "Error: HY010" );

            __post_internal_error( &statement -> error,
                    ERROR_HY010, NULL,
                    statement -> connection -> environment -> requested_version );

            thread_release( SQL_HANDLE_STMT, statement );

            return function_return( statement, SQL_ERROR );
        }
    }

    /*
     * TO_DO Check the SQL_ATTR_METADATA_ID settings
     */

    if ( !CHECK_SQLFOREIGNKEYS( statement -> connection ))
    {
        dm_log_write( statement -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: IM001" );

        __post_internal_error( &statement -> error,
                ERROR_IM001, NULL,
                statement -> connection -> environment -> requested_version );

        thread_release( SQL_HANDLE_STMT, statement );

        return function_return( statement, SQL_ERROR );
    }

    ret = SQLFOREIGNKEYS( statement -> connection ,
            statement -> driver_stmt,
            szpk_catalog_name,
            cbpk_catalog_name,
            szpk_schema_name,
            cbpk_schema_name,
            szpk_table_name,
            cbpk_table_name,
            szfk_catalog_name,
            cbfk_catalog_name,
            szfk_schema_name,
            cbfk_schema_name,
            szfk_table_name,
            cbfk_table_name );

    if ( SQL_SUCCEEDED( ret ))
    {
		/********
		 * Added this to get num cols from drivers which can only tell
		 * us after execute - PAH
		 */
        ret = SQLNUMRESULTCOLS( statement -> connection,
                statement -> driver_stmt, &statement -> numcols );
		/******/
        statement -> state = STATE_S5;
        statement -> prepared = 0;
    }
    else if ( ret == SQL_STILL_EXECUTING )
    {
        statement -> interupted_func = SQL_API_SQLFOREIGNKEYS;
        if ( statement -> state != STATE_S11 &&
                statement -> state != STATE_S12 )
            statement -> state = STATE_S11;
    }
    else
    {
        statement -> state = STATE_S1;
    }

    if ( statement -> log_handle )
    {
        sprintf( statement -> msg, 
                "\n\t\tExit:[%s]",
                    __get_return_status( ret ));

        dm_log_write( statement -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                statement -> msg );
    }

    thread_release( SQL_HANDLE_STMT, statement );

    return function_return( statement, ret );
}
