/*********************************************************************
 *
 * This is based on code created by Peter Harvey,
 * (pharvey@codebydesign.com).
 *
 * Modified and extended by Nick Gorham
 * (nick@easysoft.com).
 *
 * Any bugs or problems should be considered the fault of Nick and not
 * Peter.
 * 
 * copyright (c) 1999 Nick Gorham
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **********************************************************************
 *
 * $Id: SQLGetDescRec.c,v 1.2 1999/12/10 01:50:35 harvey Exp $
 *
 * $Log: SQLGetDescRec.c,v $
 * Revision 1.2  1999/12/10 01:50:35  harvey
 * Updated with current sources from unixODBC cvs.
 *
 * Revision 1.7  1999/11/13 23:40:59  ngorham
 *
 * Alter the way DM logging works
 * Upgrade the Postgres driver to 6.4.6
 *
 * Revision 1.6  1999/10/24 23:54:18  ngorham
 *
 * First part of the changes to the error reporting
 *
 * Revision 1.5  1999/09/21 22:34:25  ngorham
 *
 * Improve performance by removing unneeded logging calls when logging is
 * disabled
 *
 * Revision 1.4  1999/07/10 21:10:16  ngorham
 *
 * Adjust error sqlstate from driver manager, depending on requested
 * version (ODBC2/3)
 *
 * Revision 1.3  1999/07/04 21:05:07  ngorham
 *
 * Add LGPL Headers to code
 *
 * Revision 1.2  1999/06/30 23:56:55  ngorham
 *
 * Add initial thread safety code
 *
 * Revision 1.1.1.1  1999/05/29 13:41:07  sShandyb
 * first go at it
 *
 * Revision 1.1.1.1  1999/05/27 18:23:17  pharvey
 * Imported sources
 *
 * Revision 1.3  1999/05/04 22:41:12  nick
 * and another night ends
 *
 * Revision 1.2  1999/05/03 19:50:43  nick
 * Another check point
 *
 * Revision 1.1  1999/04/25 23:06:11  nick
 * Initial revision
 *
 *
 **********************************************************************/

#include "drivermanager.h"

static char const rcsid[]= "$RCSfile: SQLGetDescRec.c,v $ $Revision: 1.2 $";

SQLRETURN SQLGetDescRec( SQLHDESC descriptor_handle,
           SQLSMALLINT rec_number, 
           SQLCHAR *name,
           SQLSMALLINT buffer_length, 
           SQLSMALLINT *string_length,
           SQLSMALLINT *type, 
           SQLSMALLINT *sub_type, 
           SQLINTEGER *length, 
           SQLSMALLINT *precision, 
           SQLSMALLINT *scale, 
           SQLSMALLINT *nullable )
{
    /*
     * not quite sure how the descriptor can be
     * allocated to a statement, all the documentation talks
     * about state transitions on statement states, but the
     * descriptor may be allocated with more than one statement
     * at one time. Which one should I check ?
     */
    DMHDESC descriptor = (DMHDESC) descriptor_handle;
    SQLRETURN ret;
    SQLCHAR s0[ 20 ], s1[ 100 ], s2[ 100 ], s3[ 100 ], s4[ 100 ];
    SQLCHAR s5[ 100 ], s6[ 100 ], s7[ 100 ];

    /*
     * check descriptor
     */

    if ( !__validate_desc( descriptor ))
    {
        return SQL_INVALID_HANDLE;
    }

    function_entry( descriptor );

    if ( descriptor -> log_handle )
    {
        sprintf( descriptor -> msg, "\n\t\tEntry:\
            \n\t\t\tDescriptor = %p\
            \n\t\t\tRec Number = %d\
            \n\t\t\tName = %p\
            \n\t\t\tBuffer length = %d\
            \n\t\t\tString Length = %p\
            \n\t\t\tType = %p\
            \n\t\t\tSub Type = %p\
            \n\t\t\tLength = %p\
            \n\t\t\tPrecision = %p\
            \n\t\t\tScale = %p\
            \n\t\t\tNullable = %p",
                descriptor,
                rec_number,
                name,
                buffer_length,
                string_length,
                type,
                sub_type,
                length,
                precision,
                scale,
                nullable );

        dm_log_write( descriptor -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                descriptor -> msg );
    }

    thread_protect( SQL_HANDLE_DESC, descriptor );

    if ( !CHECK_SQLGETDESCREC( descriptor -> connection ))
    {
        dm_log_write( descriptor -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: IM001" );

        __post_internal_error( &descriptor -> error,
                ERROR_IM001, NULL,
                descriptor -> connection -> environment -> requested_version );

        thread_protect( SQL_HANDLE_DESC, descriptor );

        return function_return( descriptor, SQL_ERROR );
    }

    ret = SQLGETDESCREC( descriptor -> connection,
            descriptor -> driver_desc,
            rec_number, 
            name,
            buffer_length, 
            string_length,
            type, 
            sub_type, 
            length, 
            precision, 
            scale, 
            nullable );

    if ( descriptor -> log_handle )
    {
        sprintf( descriptor -> msg, 
                "\n\t\tExit:[%s]\
                \n\t\t\tName = %s\
                \n\t\t\tType = %s\
                \n\t\t\tSub Type = %s\
                \n\t\t\tLength = %s\
                \n\t\t\tPrecision = %s\
                \n\t\t\tScale = %s\
                \n\t\t\tNullable = %s",
                    __get_return_status( ret ),
                    __sdata_as_string( s1, SQL_CHAR, 
                        string_length, name ),
                    __sptr_as_string( s2, type ),
                    __sptr_as_string( s3, sub_type ),
                    __ptr_as_string( s4, length ),
                    __sptr_as_string( s5, precision ),
                    __sptr_as_string( s6, scale ),
                    __sptr_as_string( s7, nullable ));

        dm_log_write( descriptor -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                descriptor -> msg );
    }

    thread_protect( SQL_HANDLE_DESC, descriptor );

    return function_return( descriptor, ret );
}
