# -*- tcl -*-
#
# Author:       James Brister <brister@vix.com> -- berkeley-unix --
# Start Date:   Sat, 24 Aug 1996 23:45:34 +0200
# Project:      INN
# File:         innshellvars.tcl
# RCSId:        $Id: innshellvars.tcl.in,v 1.18.2.1 1999/10/26 01:37:54 kondou Exp $
# Description:  Set up any and all variables that an INN tcl script
#               might need.

eval `/usr/lib/news/bin/innconfval -t`

set inn_newshome "$inn_pathnews"
set inn_spooldir "$inn_pathspool"
set inn_most_logs "$inn_pathlog"

set inn_errlog "${inn_most_logs}/errlog"
set inn_log "${inn_most_logs}/news"

set inn_batch "${inn_pathoutgoing}"
set inn_incoming "${inn_pathincoming}"
set inn_spool "${inn_patharticles}"
set inn_overviewdir "${inn_pathoverview}"
set inn_archivedir "${inn_patharchive}"
set inn_badnews "${inn_pathincoming}/bad"
set inn_spoolnews "${inn_pathincoming}"

set inn_newslbin "${inn_newshome}/local"
set inn_innddir "${inn_pathrun}"
set inn_locks "${inn_pathrun}"
set inn_newsbin "${inn_pathbin}"
set inn_newsetc "${inn_newshome}/etc"

set inn_active "${inn_pathdb}/active"
set inn_activetimes "${inn_pathdb}/active.times"
set inn_ctlfile "${inn_newsetc}/control.ctl"
set inn_ctlwatch "${inn_newsetc}/innwatch.ctl"
set inn_history "${inn_pathdb}/history"
set inn_newactive "${inn_pathdb}/active.tmp"
set inn_newsfeeds "${inn_newsetc}/newsfeeds"
set inn_newsgroups "${inn_pathdb}/newsgroups"
set inn_oldactive "${inn_pathdb}/active.old"
set inn_localgroups "${inn_newsetc}/localgroups"
set inn_expirectl "${inn_newsetc}/expire.ctl"
set inn_path_motd "${inn_newsetc}/motd.news"
set inn_path_storagectl "${inn_newsetc}/storage.ctl"
set inn_path_overviewctl "${inn_newsetc}/overview.ctl"

set inn_daily "${inn_locks}/locks/LOCK.news.daily"

set inn_inews "${inn_newsbin}/inews"
set inn_innconfval "${inn_newsbin}/innconfval"
set inn_innd "${inn_newsbin}/innd"
set inn_inndstart "${inn_newsbin}/inndstart"
set inn_innwatch "${inn_newsbin}/innwatch"
set inn_rnews "${inn_newsbin}/rnews"
set inn_controlprogs "${inn_pathcontrol}/control"
set inn_perl_startup_innd "${inn_pathfilter}/startup_innd.pl"
set inn_perl_filter_innd "${inn_pathfilter}/filter_innd.pl"
set inn_perl_filter_nnrpd "${inn_pathfilter}/filter_nnrpd.pl"
set inn_path_tcl_startup "${inn_pathfilter}/startup.tcl"
set inn_path_tcl_filter "${inn_pathfilter}/filter.tcl"

set inn_newscontrol "${inn_innddir}/control"
set inn_nntpconnect "${inn_innddir}/nntpin"
set inn_innwstatus "${inn_innddir}/innwatch.status"
set inn_watchpid "${inn_innddir}/innwatch.pid"
set inn_serverpid "${inn_innddir}/innd.pid"

set inn_awk "/usr/bin/awk"
set inn_sed "/usr/bin/sed"
set inn_perl "/usr/bin/perl"
set inn_pgp "no-pgp-found-during-configure"
set inn_inndf "${inn_newsbin}/inndf"
set inn_egrep "/usr/bin/egrep"
set inn_sort "/usr/bin/sort"
set inn_getftp "/usr/bin/ncftp"
set inn_compress "/usr/bin/compress"
set inn_log_compress "/bin/gzip"
set inn_z ".gz"

set inn_tempsock [ eval exec basename ${inn_innddir}/ctlinndXXXXXX | $inn_sed -e {s/XXXXXX$/*/} ]
set inn_tempsockdir [ exec echo ${inn_innddir}/ctlinndXXXXXX | $inn_sed -e {s@/[^/]*$@@} ]

##  =()<set inn_have_uustat [ expr { "@<HAVE_UUSTAT>@" == "DO" ? 1 : 0 } ]>()=
set inn_have_uustat [ expr { "DO" == "DO" ? 1 : 0 } ]

set inn_newsmaster "news"
set inn_newsuser "news"

set env(TMPDIR) "$inn_pathtmp"
set inn_tmpdir "$inn_pathtmp"
set inn_spooltemp "$inn_pathtmp"

scan "02" "%o" inn_umask

set env(PATH) "$inn_newslbin:$inn_newsbin:$env(PATH):/bin:/usr/bin:/usr/ucb"
