/*****************************
 Dump a packet to the screen
 (c) 1999 Jeremy Wise
 GnomeICU
******************************/

/*** Global header files ***/
#include <ctype.h>

/*** GnomeICU header files ***/
#include "common.h"

#define READ_TCP_COL  "\x1B[1;36m"
#define WRITE_TCP_COL "\x1B[0;34m"
#define READ_UDP_COL  "\x1B[0;31m"
#define WRITE_UDP_COL "\x1B[1;32m"
#define REG_COL       "\x1B[0m"

void packet_print( BYTE *packet, int size, int type, gchar *charid )
{
	int cx;
	gchar condensed[17];

#ifdef TRACE_FUNCTION
	g_print( "packet_print\n" );
#endif

	if( !toggles->packet_udp && (type & PACKET_TYPE_UDP) )
		return;
	if( !toggles->packet_tcp && (type & PACKET_TYPE_TCP) )
		return;

	condensed[16] = 0x00;

	switch( type )
	{
		case ( PACKET_TYPE_TCP | PACKET_DIRECTION_SEND ):
			g_print( WRITE_TCP_COL "Sending packet (TCP) %d:\n", size );
			break;
		case( PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE ):
			g_print( READ_TCP_COL "Recieved packet (TCP) %d:\n", size );
			break;
		case ( PACKET_TYPE_UDP | PACKET_DIRECTION_SEND ):
			g_print( WRITE_UDP_COL "Sending packet (UDP) Size=%d Seq1=%d Seq2=%d:\n", size,
			         Chars_2_Word( ((net_icq_pak*)packet)->head.seq ),
			         Chars_2_Word( ((net_icq_pak*)packet)->head.seq2 ) );
			break;
		case( PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE ):
			g_print( READ_UDP_COL "Received packet (UDP) Size=%d Seq1=%d Seq2=%d:\n", size,
			         Chars_2_Word( ((srv_net_icq_pak*)packet)->head.seq ),
			         Chars_2_Word( ((srv_net_icq_pak*)packet)->head.seq2 ) );
			break;
	}

	strcpy( condensed, "" );
	g_print( "%s\n", charid );

	for( cx = 0; cx < size; cx ++ )
	{
		if( isprint( packet[cx] ) )
			strncat( condensed, &packet[cx], 1 );
		else
			strcat( condensed, "." );

		if( cx % 16 == 4 || cx % 16 == 8 || cx % 16 == 12 )
			g_print( "- " );

		g_print("%02x ", packet[cx] );

		if( cx % 16 == 15 )
		{
			g_print( "    %s\n", condensed );
			condensed[0] = '\x0';
		}
	}

	for( ; cx % 16; cx ++ )
	{
		g_print( "   " );
		if( cx % 16 == 4 || cx % 16 == 8 || cx % 16 == 12 )
			g_print( "  " );
	}
	g_print( "    %s", condensed );
	g_print( REG_COL "\n\n" );
	fflush( stdout );
}
