/*************************************
 Sends various messages to the server
 (c) 1999 Jeremy Wise 
 GnomeICU
**************************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#ifdef HAVE_SOCKS5
#define SOCKS 1
#include <socks.h>
#endif

int search_wait;

DWORD our_session;

/*** Local function declarations ***/
static char *cr_convert( const gchar *text );
static void Wrinkle( void *buf, size_t len );
static void Gen_Checksum( BYTE * buf, DWORD len );
static DWORD Scramble_cc( DWORD cc );
static size_t SOCKWRITE_LOW( void * ptr, size_t len, gchar *charid );
/*void Update_More_User_Info( MORE_INFO_PTR user);*/

/********************************************************
The following data constitutes fair use for compatibility.
*********************************************************/
static const BYTE table[] = {
 0x59, 0x60, 0x37 , 0x6B , 0x65 , 0x62 , 0x46 , 0x48 , 0x53 , 0x61 , 0x4C , 0x59 , 0x60 , 0x57 , 0x5B , 0x3D,
 0x5E, 0x34, 0x6D , 0x36 , 0x50 , 0x3F , 0x6F , 0x67 , 0x53 , 0x61 , 0x4C , 0x59 , 0x40 , 0x47 , 0x63 , 0x39,
 0x50, 0x5F, 0x5F , 0x3F , 0x6F , 0x47 , 0x43 , 0x69 , 0x48 , 0x33 , 0x31 , 0x64 , 0x35 , 0x5A , 0x4A , 0x42,
 0x56, 0x40, 0x67 , 0x53 , 0x41 , 0x07 , 0x6C , 0x49 , 0x58 , 0x3B , 0x4D , 0x46 , 0x68 , 0x43 , 0x69 , 0x48,
 0x33, 0x31, 0x44 , 0x65 , 0x62 , 0x46 , 0x48 , 0x53 , 0x41 , 0x07 , 0x6C , 0x69 , 0x48 , 0x33 , 0x51 , 0x54,
 0x5D, 0x4E, 0x6C , 0x49 , 0x38 , 0x4B , 0x55 , 0x4A , 0x62 , 0x46 , 0x48 , 0x33 , 0x51 , 0x34 , 0x6D , 0x36,
 0x50, 0x5F, 0x5F , 0x5F , 0x3F , 0x6F , 0x47 , 0x63 , 0x59 , 0x40 , 0x67 , 0x33 , 0x31 , 0x64 , 0x35 , 0x5A,
 0x6A, 0x52, 0x6E , 0x3C , 0x51 , 0x34 , 0x6D , 0x36 , 0x50 , 0x5F , 0x5F , 0x3F , 0x4F , 0x37 , 0x4B , 0x35,
 0x5A, 0x4A, 0x62 , 0x66 , 0x58 , 0x3B , 0x4D , 0x66 , 0x58 , 0x5B , 0x5D , 0x4E , 0x6C , 0x49 , 0x58 , 0x3B,
 0x4D, 0x66, 0x58 , 0x3B , 0x4D , 0x46 , 0x48 , 0x53 , 0x61 , 0x4C , 0x59 , 0x40 , 0x67 , 0x33 , 0x31 , 0x64,
 0x55, 0x6A, 0x32 , 0x3E , 0x44 , 0x45 , 0x52 , 0x6E , 0x3C , 0x31 , 0x64 , 0x55 , 0x6A , 0x52 , 0x4E , 0x6C,
 0x69, 0x48, 0x53 , 0x61 , 0x4C , 0x39 , 0x30 , 0x6F , 0x47 , 0x63 , 0x59 , 0x60 , 0x57 , 0x5B , 0x3D , 0x3E,
 0x64, 0x35, 0x3A , 0x3A , 0x5A , 0x6A , 0x52 , 0x4E , 0x6C , 0x69 , 0x48 , 0x53 , 0x61 , 0x6C , 0x49 , 0x58,
 0x3B, 0x4D, 0x46 , 0x68 , 0x63 , 0x39 , 0x50 , 0x5F , 0x5F , 0x3F , 0x6F , 0x67 , 0x53 , 0x41 , 0x25 , 0x41,
 0x3C, 0x51, 0x54 , 0x3D , 0x5E , 0x54 , 0x5D , 0x4E , 0x4C , 0x39 , 0x50 , 0x5F , 0x5F , 0x5F , 0x3F , 0x6F,
 0x47, 0x43, 0x69 , 0x48 , 0x33 , 0x51 , 0x54 , 0x5D , 0x6E , 0x3C , 0x31 , 0x64 , 0x35 , 0x5A , 0x00 , 0x00,
};

/*** Global functions ***/


/****************************************************************
Checks if packets are waiting to be resent and sends them.
*****************************************************************/
void Do_Resend( void )
{
	struct msg *queued_msg;
	SIMPLE_MESSAGE_PTR s_mesg;
	DWORD type; 
	char *data;
	char *tmp;
	char *temp;
	char url_desc[1024], url_data[1024];
	net_icq_pak pak;
	int old_status;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "Do_Resend\n" );
#endif

	if ((queued_msg = msg_queue_pop()) != NULL)
	{
		queued_msg->attempts++;
		if (queued_msg->attempts <= 6)
		{
			temp = g_malloc( queued_msg->len + 3 );
			g_assert( temp != NULL );
			memcpy( temp, queued_msg->body, queued_msg->len);
			SOCKWRITE_LOW( temp, queued_msg->len, "RESEND" );
			g_free(temp);
			queued_msg->exp_time = time(NULL) + 10; 
			msg_queue_push( queued_msg );
		}
		else
		{
			memcpy(&pak.head.ver, queued_msg->body, queued_msg->len);

			if ( CMD_SENDM == Chars_2_Word( pak.head.cmd ) )
			{
				s_mesg = ( SIMPLE_MESSAGE_PTR ) pak.data;

				type = Chars_2_Word(s_mesg->type);
				data = s_mesg->len + 2; 
				if ( type == URL_MESS || type == MRURL_MESS )
				{
					tmp = strchr( data, '\xFE' );
					if ( tmp != NULL )
					{
						*tmp = 0;
						strcpy(url_desc, data);
						tmp++;
						data = tmp;
						strcpy(url_data, data);
					}
				}
			}
			else
			{
				if( ( CMD_LOGIN == Chars_2_Word( pak.head.cmd ) ) ||
				    ( CMD_KEEP_ALIVE == Chars_2_Word( pak.head.cmd ) ) )
				{
					log_window_add( _("Connection unreliable - reconnecting"), our_info->uin );
					Quit = TRUE;
					if( Connected )
					{
						old_status = Current_Status;
						Current_Status = STATUS_OFFLINE;
						Quit_ICQ();
						if( udp_gdk_input )
						{
							gdk_input_remove( udp_gdk_input );
							udp_gdk_input = 0;
						}

						contact = Contacts;

						while( contact != NULL )
						{
							((CONTACT_PTR)contact->data)->last_status = ((CONTACT_PTR)contact->data)->status;
							((CONTACT_PTR)contact->data)->status = STATUS_OFFLINE;
							contact = contact->next;
						}
						Show_Quick_Status();
						seq_num = 1;
						if( MainData->sok )
							close( MainData->sok );

						Connected = FALSE;

						ready_set();

						if( toggles->applet )
						{
							applet_update( Current_Status, NULL );
						}

						msg_queue_clear();

						Current_Status = old_status | (toggles->webpresence*0x10000);
						Done_Login = FALSE;
						MainData->sok = Connect_Remote( server, remote_port, STDERR );
						if( MainData->sok > 0 )
						{
							udp_gdk_input = gdk_input_add( MainData->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, MainData );
							Connected = TRUE;

							Login( passwd, our_ip, our_port );
						}
						else
						{
							MainData->sok = 0;
							Current_Status = STATUS_OFFLINE;
						}

						return;
					}
				}
			}

			g_free(queued_msg->body);
			g_free(queued_msg);
		}

		if ( (queued_msg = msg_queue_peek() ) != NULL )
		{
			next_resend = queued_msg->exp_time; 
		}
		else
		{
			next_resend = G_MAXINT;
		}
	}
	else
   {
		next_resend = G_MAXINT;
	}
}

/*
 * Send a message thru the Server to the UIN
 * 'text' is the message
 */
void icq_sendmsg( UIN_T uin, const gchar *text, gboolean forced )
{
	SIMPLE_MESSAGE msg;
	net_icq_pak pak;
	int size, len; 
	gchar *new_text;

#ifdef TRACE_FUNCTION
	g_print( "icq_sendmsg\n" );
#endif

	if( strlen( text ) == 0 )
	{
		gtk_widget_show( gnome_message_box_new( _( "Cannot send blank message" ),
		                                        GNOME_MESSAGE_BOX_ERROR,
		                                        GNOME_STOCK_BUTTON_OK,
		                                        NULL ) );
		return;
	}

	new_text = cr_convert( text );

	/* Add statement to personal history file */
	add_outgoing_to_history( uin, new_text );
	rus_conv(RUS_KOI_WIN, new_text);

	if( !forced && !toggles->force && TCPSendMessage( uin, new_text) )
	{
		log_window_add(_("Sent Message (TCP)"), uin );
		g_free( new_text );
		return;
	}

	if( strlen( new_text ) + 1 > MAX_UDP_MESSAGE_LENGTH )
		new_text[ MAX_UDP_MESSAGE_LENGTH ] = 0;

	log_window_add(_("Sent Message (UDP)"), uin );

	len = strlen(new_text);
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_SENDM );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );

	DW_2_Chars( msg.uin, uin );
	DW_2_Chars(msg.type, 0x0001 );		/* A type 1 msg*/
	Word_2_Chars( msg.len, len + 1 );	/* length + the NULL */

	memcpy(&pak.data, &msg, sizeof( msg ) );
	memcpy(&pak.data[8], new_text, len + 1);

	size = sizeof( msg ) + len + 1;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "CMD_SENDM(MSG)");

	g_free( new_text );
}

void icq_sendurl( GtkWidget *widget, struct URLInfo *data )
{
	SIMPLE_MESSAGE msg;
	net_icq_pak pak;
	gint size, len; 
	UIN_T uin;
	gchar *new_text;
	gchar *text;
   	gchar *histtext;

#ifdef TRACE_FUNCTION
	g_print( "icq_sendurl\n" );
#endif

	uin = ((CONTACT_PTR)data->contact->data)->uin;
	
	text = g_strdup_printf( "%s\xFE%s",
				gtk_entry_get_text( GTK_ENTRY( data->desc ) ),
				gtk_entry_get_text( GTK_ENTRY( data->url ) ) );
   
   	histtext = g_strdup_printf( "URL: %s \nDescription: %s",
				gtk_entry_get_text( GTK_ENTRY( data->url ) ),
				gtk_entry_get_text( GTK_ENTRY( data->desc ) ) );
   
	new_text = cr_convert( text );
   
	g_free( text );

	/* Add statement to personal history file */
	add_outgoing_to_history( uin, histtext );

   	g_free( histtext );

	if( TCPSendURL( uin, new_text ) )
	{
		log_window_add( _("Sent URL (TCP)"), uin );
		g_free( new_text );
		return;
	}

	log_window_add( _("Sent URL (UDP)") , uin );
	
	len = strlen(new_text);
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_SENDM );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );

	DW_2_Chars( msg.uin, uin );
	DW_2_Chars(msg.type, 0x0004 );		/* A type 4 msg*/
	Word_2_Chars( msg.len, len + 1 );	/* length + the NULL */

	memcpy(&pak.data, &msg, sizeof( msg ) );
	memcpy(&pak.data[8], new_text, len + 1);

	size = sizeof( msg ) + len + 1;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "CMD_SENDM(URL)");

	g_free( new_text );
}

/*
 * Send an authorization to the server so the
 * client can add the user
 */
void icq_sendauthmsg( UIN_T uin)
{
	SIMPLE_MESSAGE msg;
	net_icq_pak pak;
	int size; 

#ifdef TRACE_FUNCTION
	g_print( "icq_sendauthmsg\n" );
#endif

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_SENDM );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );

	DW_2_Chars( msg.uin, uin );
	DW_2_Chars( msg.type, AUTH_MESS );		/* A type authorization msg*/
	Word_2_Chars( msg.len, 2 );		

	memcpy(&pak.data, &msg, sizeof( msg ) );

	pak.data[ sizeof(msg) ]=0x03;
	pak.data[ sizeof(msg) + 1]=0x00;

	size = sizeof( msg ) + 2;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "AUTH_MESS");
}

/* Change User Status */
void icq_change_status( DWORD status )
{
	net_icq_pak pak;
	int size ;

#ifdef TRACE_FUNCTION
	g_print( "icq_change_status\n" );
#endif

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_STATUS_CHANGE );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );

	DW_2_Chars( pak.data, ( status | (toggles->webpresence * 0x10000) ) );
	Current_Status = status | (toggles->webpresence * 0x10000);

	size = 4;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "CMD_STATUS_CHANGE");

	ready_set();

	if( toggles->applet )
	{
		applet_update( Current_Status, NULL );
	}
}

/* Disconnect from ICQ server */
void Quit_ICQ( void )
{
	net_icq_pak pak;
	int size, len;

#ifdef TRACE_FUNCTION
	g_print( "Quit_ICQ\n" );
#endif
   
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_SEND_TEXT_CODE );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
   
	len = strlen( "B_USER_DISCONNECTED" ) + 1;
	*(short * ) pak.data = len;
	size = len + 4;
   
	memcpy( &pak.data[2], "B_USER_DISCONNECTED", len );
	pak.data[ 2 + len ] = 05;
	pak.data[ 3 + len ] = 00;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "B_USER_DISCONNECTED");

	if( MainData->sok )
		SOCKCLOSE( MainData->sok );
}

/* Send a request for Info on a User */
void send_info_req( UIN_T uin )
{
	net_icq_pak pak;
	int size ;

#ifdef TRACE_FUNCTION
	g_print( "send_info_req\n" );
#endif

	info_req_99( uin );
	return;

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_INFO_REQ );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );

	DW_2_Chars( pak.data, uin );

	size = 4;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "CMD_INFO_REQ");
}

/* Start a Server Search for Information Specified */
void start_search( gchar *email, gchar *nick,
                   gchar* first, gchar* last,
                   UIN_T uin )
{
	net_icq_pak pak;
	int size;

#ifdef TRACE_FUNCTION
	g_print( "start_search\n" );
#endif

	if( uin > 0 )
	{
		start_new_info = TRUE;
		show_info_new( uin );
		return;
	}

	rus_conv(RUS_KOI_WIN, nick);
	rus_conv(RUS_KOI_WIN, first);
	rus_conv(RUS_KOI_WIN, last);

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_SEARCH_USER );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );

	size = 0;
	Word_2_Chars( pak.data + size, strlen( nick ) + 1 );
	size += 2;
	strcpy( pak.data + size , nick );
	size += strlen( nick ) + 1;
	Word_2_Chars( pak.data + size, strlen( first ) + 1 );
	size += 2;
	strcpy( pak.data + size , first );
	size += strlen( first ) + 1;
	Word_2_Chars( pak.data + size, strlen( last ) + 1);
	size += 2;
	strcpy( pak.data + size , last );
	size += strlen( last ) +1 ;
	Word_2_Chars( pak.data + size, strlen( email ) + 1  );
	size += 2;
	strcpy( pak.data + size , email );
	size += strlen( email ) + 1;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "CMD_SEARCH_USER");
}

void send_ext_info_req( UIN_T uin )
{
	net_icq_pak pak;
	int size;

#ifdef TRACE_FUNCTION
	g_print( "send_ext_info_req\n" );
#endif

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_EXT_INFO_REQ );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );

	DW_2_Chars( pak.data, uin );
	size = 4;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "CMD_EXT_INFO_REQ");
}

void reg_new_user( gchar *pass )
{
	net_icq_pak pak;
	char len_buf[2];
	int size, len;

#ifdef TRACE_FUNCTION
	g_print( "reg_new_user\n" );
#endif
	rus_conv(RUS_KOI_WIN, pass); /* Bad, but need */

	len = strlen( pass );
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_REG_NEW_USER );
	Word_2_Chars( pak.head.seq, seq_num ++ );
	Word_2_Chars( pak.head.seq2, seq_num - 1 );
	Word_2_Chars( len_buf, len );

   memcpy(&pak.data[0], len_buf, 2 );
   memcpy(&pak.data[2], pass, len + 1);
   DW_2_Chars( &pak.data[2+len], 0xA0 );
   DW_2_Chars( &pak.data[6+len], 0x2461 );
   DW_2_Chars( &pak.data[10+len], 0xa00000 );
   DW_2_Chars( &pak.data[14+len], 0x00 );
   size = len + 18;

	if( our_session == 0 )
	{
		our_session = rand();
		DW_2_Chars( pak.head.session, our_session );
		our_session = 0;
	}
	else
		DW_2_Chars( pak.head.session, our_session );

	DW_2_Chars( pak.head.zero, 0L );
	DW_2_Chars( pak.head.UIN, 0L ); 
         
	SOCKWRITE_LOW( &( pak.head.ver ), size + sizeof( pak.head ) - 2, "CMD_REG_NEW_USER");
}

/***************************************************************
This handles actually sending a packet after it's been assembled.
When V5 is implemented this will wrinkle the packet and calculate 
the checkcode.
Adds packet to the queued messages.
****************************************************************/
size_t SOCKWRITE( void * ptr, size_t len, gchar *charid )
{
   struct msg *msg_to_queue;
	static WORD seq2 = 0;
	WORD temp;
   WORD cmd;

	DW_2_Chars( &((BYTE *)ptr)[2], 0L );
	if ( 0 == our_session )
	{
		our_session = rand() & 0x3fffffff;
	}

	DW_2_Chars( &((BYTE *)ptr)[0x0A], our_session );

	cmd = Chars_2_Word( (((ICQ_PAK_PTR)((BYTE*)ptr-2))->cmd ) );
	if ( cmd != CMD_ACK && cmd != CMD_SEND_TEXT_CODE )
	{
		msg_to_queue = g_new0( struct msg, 1 );
		if ( 0 == seq2 )
		{
			seq2 = rand() & 0x7fff;
		}
		temp = Chars_2_Word( &((BYTE *)ptr)[SEQ2_OFFSET] );
		temp += seq2;
		Word_2_Chars( &((BYTE *)ptr)[SEQ_OFFSET], temp );
		if ( CMD_KEEP_ALIVE == Chars_2_Word( &((BYTE *)ptr)[CMD_OFFSET] ) )
		{
			Word_2_Chars( &((BYTE *)ptr)[SEQ2_OFFSET], 0 );
			seq_num--;
		}

		msg_to_queue->seq = ( Chars_2_DW( &((BYTE *)ptr)[SEQ_OFFSET] ) & 0xffff );

		msg_to_queue->attempts = 1;
		msg_to_queue->exp_time = time(NULL) + 10;
		msg_to_queue->body = (BYTE *)g_malloc0( len );
		msg_to_queue->len = len;
		memcpy(msg_to_queue->body, ptr, msg_to_queue->len);
		msg_queue_push( msg_to_queue );

		if (msg_queue_peek() == msg_to_queue)
		{
			next_resend = msg_to_queue->exp_time;
		}
	}

   return SOCKWRITE_LOW( ptr, len, charid );
}

size_t SOCKREAD( void * ptr, size_t len )
{
   size_t sz;

#ifdef TRACE_FUNCTION
	g_print( "SOCKREAD\n" );
#endif

   sz = sockread( MainData->sok, ptr, len );
   return sz;
}

void Update_User_Info( void )
{
	net_icq_pak pak;
	int size ;

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_UPDATE_INFO );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
   
   size = 0;
   Word_2_Chars( pak.data + size, strlen( our_info->nick ) + 1 );
   size += 2;
   strcpy( pak.data + size , our_info->nick );
   size += strlen( our_info->nick ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->first ) + 1 );
   size += 2;
   strcpy( pak.data + size , our_info->first );
   size += strlen( our_info->first ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->last ) + 1);
   size += 2;
   strcpy( pak.data + size , our_info->last );
   size += strlen( our_info->last ) +1 ;
   Word_2_Chars( pak.data + size, strlen( our_info->email ) + 1  );
   size += 2;
   strcpy( pak.data + size , our_info->email );
   size += strlen( our_info->email ) + 1;
   pak.data[ size ] = our_info->auth;
   size++;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "CMD_UPDATE_INFO");

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_AUTH_UPDATE );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );

   DW_2_Chars( pak.data, ! our_info->auth );

	SOCKWRITE( &(pak.head.ver), 4 + sizeof( pak.head ) - 2, "CMD_AUTH_UPDATE");

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_META_USER );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
   
   Word_2_Chars( pak.data , META_INFO_SET );
   size = 2;
   Word_2_Chars( pak.data + size, strlen( our_info->nick ) + 1 );
   size += 2;
   strcpy( pak.data + size , our_info->nick );
   size += strlen( our_info->nick ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->first ) + 1 );
   size += 2;
   strcpy( pak.data + size , our_info->first );
   size += strlen( our_info->first ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->last ) + 1);
   size += 2;
   strcpy( pak.data + size , our_info->last );
   size += strlen( our_info->last ) +1 ;
   Word_2_Chars( pak.data + size, strlen( our_info->email ) + 1  );
   size += 2;
   strcpy( pak.data + size , our_info->email );
   size += strlen( our_info->email ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->email2 ) + 1  );
   size += 2;
   strcpy( pak.data + size , our_info->email2 );
   size += strlen( our_info->email2 ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->email3 ) + 1  );
   size += 2;
   strcpy( pak.data + size , our_info->email3 );
   size += strlen( our_info->email3 ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->city ) + 1  );
   size += 2;
   strcpy( pak.data + size , our_info->city );
   size += strlen( our_info->city ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->state ) + 1  );
   size += 2;
   strcpy( pak.data + size , our_info->state );
   size += strlen( our_info->state ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->phone ) + 1  );
   size += 2;
   strcpy( pak.data + size , our_info->phone );
   size += strlen( our_info->phone ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->fax ) + 1  );
   size += 2;
   strcpy( pak.data + size , our_info->fax );
   size += strlen( our_info->fax ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->street ) + 1  );
   size += 2;
   strcpy( pak.data + size , our_info->street );
   size += strlen( our_info->street ) + 1;
   Word_2_Chars( pak.data + size, strlen( our_info->cellular ) + 1  );
   size += 2;
   strcpy( pak.data + size , our_info->cellular );
   size += strlen( our_info->cellular ) + 1;
   DW_2_Chars( &pak.data[ size ] , our_info->zip );
   size += 4;
   Word_2_Chars( &pak.data[ size ] , our_info->country );
   size += 2;
   pak.data[ size ] = (BYTE)((our_info->c_status/100)*2 );
   pak.data[ size++ ] = our_info->hide_email;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "CMD_META_USER(META_INFO_SET)");

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_META_USER );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
   
   Word_2_Chars( pak.data , META_INFO_HOMEPAGE );
   size = 2;
	Word_2_Chars( pak.data + size, our_info->age );
	size += 2;
	pak.data[ size++ ] = (BYTE)our_info->sex;
	Word_2_Chars( pak.data + size, strlen( our_info->homepage ) + 1 );
	size += 2;
	strcpy( pak.data + size, our_info->homepage );
	size += strlen( our_info->homepage ) + 1;
	pak.data[ size ++ ] = our_info->birth_year;
	pak.data[ size ++ ] = our_info->birth_month;
	pak.data[ size ++ ] = our_info->birth_day;
/* Three spoken languages */
	pak.data[ size ++ ] = 0xff;
	pak.data[ size ++ ] = 0xff;
	pak.data[ size ++ ] = 0xff;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "CMD_META_USER(META_INFO_HOMEPAGE)");

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_META_USER );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
   
   Word_2_Chars( pak.data , META_INFO_ABOUT );
   size = 2;
	Word_2_Chars( pak.data + size, strlen( cr_convert( our_info->about ) ) + 1 );
	size += 2;
	strcpy( pak.data + size, cr_convert( our_info->about ) );
	size += strlen( cr_convert( our_info->about ) ) + 1;

	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "CMD_META_USER(META_INFO_ABOUT)");

	/* This should send webpresence and auth information */
	icq_sendwebpresence();
}

void info_req_99( UIN_T uin )
{
	GSList *contact;
	CONTACT_PTR our_contact;
	net_icq_pak pak;
	int size;

	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->uin == uin )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
	{
		our_contact = &New_Contact;
		our_contact->uin = uin;
	}
	else
		our_contact = (CONTACT_PTR)contact->data;

	our_contact->info_seq = seq_num;

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_META_USER );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	Word_2_Chars( pak.data, META_INFO_REQ );
	DW_2_Chars( pak.data + 2, uin );

	size = 6;
	SOCKWRITE( &(pak.head.ver), size + sizeof( pak.head ) - 2, "CMD_META_USER(META_INFO_REQ)" );
}

/*** Local functions ***/
gchar *cr_convert( const gchar *text )
{
	char *t;
	int cx, cy;
	
	cy = 0;
	for( cx = 0; cx < strlen( text ); cx ++ )
	{
		if( text[ cx ] == '\n' )
			cy ++;
	}
	
	t = g_malloc( strlen( text ) + cy + 1 );

	cy = 0;
	for( cx = 0; cx < strlen( text ); cx ++ )
	{
		if( text[ cx ] != '\n' )
			t[ cy ++ ] = text[ cx ];
		else
		{
			t[ cy ++ ] = '\r';
			t[ cy ++ ] = '\n';
		}
	}

	t[ cy ] = 0x00;
	
	return t;
}

void Wrinkle( void *buf, size_t len )
{
	DWORD checkcode;
	DWORD code1, code2, code3;
	DWORD pos;
	DWORD data;

	Gen_Checksum( buf, len );
	checkcode = Chars_2_DW( &((BYTE*)buf)[ 20 ] );
	code1 = len * 0x68656c6cL;
	code2 = code1 + checkcode;
	pos = 0x0A;

   for ( ; pos < ( len  ); pos+=4 )
   {
      code3 = code2 + table[ pos & 0xFF ];
      data = Chars_2_DW( &((BYTE*)buf)[ pos ] );
      data ^= code3;
      DW_2_Chars( &((BYTE*)buf)[ pos ], data );
   }
   checkcode = Scramble_cc( checkcode );
   DW_2_Chars( &((BYTE*)buf)[ 0x14 ], checkcode );
}

void Gen_Checksum( BYTE * buf, DWORD len )
{
   DWORD cc, cc2;
   DWORD r1,r2;
   
   cc = buf[8];
   cc <<= 8;
   cc += buf[4];
   cc <<= 8;
   cc += buf[2];
   cc <<= 8;
   cc += buf[6];

   r1 = rand() % ( len - 0x18 );
   r1 += 0x18;
   r2 = rand() & 0xff;
   
   cc2 = r1;
   cc2 <<= 8;
   cc2 += buf[ r1 ];
   cc2 <<= 8;
   cc2 += r2;   
   cc2 <<= 8;
   cc2 += table[ r2 ];
   cc2 ^= 0xff00ff;
/*   printf( "tbl[%02lX] = %02X\n%08lX\n\n", r2,table[ r2 ], cc ^ cc2 ); */
   
   DW_2_Chars( &buf[0x14], cc ^ cc2 );
}

DWORD Scramble_cc( DWORD cc )
{
    DWORD a[6];
    
    a[1] = cc & 0x0000001F;
    a[2] = cc & 0x03E003E0;
    a[3] = cc & 0xF8000400;
    a[4] = cc & 0x0000F800;
    a[5] = cc & 0x041F0000;
    
    a[1] <<= 0x0C;
    a[2] <<= 0x01;
    a[3] >>= 0x0A;
    a[4] <<= 0x10;
    a[5] >>= 0x0F;
    
    return a[1] + a[2] + a[3] + a[4] + a[5];
}

/***************************************************************
This handles actually sending a packet after it's been assembled.
When V5 is implemented this will wrinkle the packet and calculate
the checkcode.
****************************************************************/
static size_t SOCKWRITE_LOW( void * ptr, size_t len, gchar *charid )
{
	int retval;

#ifdef TRACE_FUNCTION
	g_print( "SOCKWRITE_LOW\n" );
#endif

/*	if( Connected )*/
	 	packet_print( ptr, len, PACKET_TYPE_UDP | PACKET_DIRECTION_SEND, charid );

   Wrinkle( ptr, len );

	if( Connected && MainData->sok > 0 )
	   retval = sockwrite( MainData->sok, ptr, len );
	else
		retval = FALSE;

	/* -1 means we have a problem, so figure we're not connected */
/*
	if( retval == -1 && Done_Login )
		icq_set_status_offline( NULL );
*/
	return retval; 
}
