#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include "common.h"

/*
 * return partition name - uses static storage unless buf is supplied
 */
static char *
partnamebf(char *dev, int pno, int lth, int bufsiz, char *bufp) {
	static char buffer[80];
	int w;

	if (!bufp) {
		bufp = buffer;
		bufsiz = sizeof(buffer);
	}

	w = strlen(dev);
	if (lth) {
		if (isdigit(dev[w-1]))
			sprintf(bufp, "%*sp%-2u", lth-3, dev, pno);
		else
			sprintf(bufp, "%*s%-2u", lth-2, dev, pno);
	} else {
		if (isdigit(dev[w-1]))
			sprintf(bufp, "%sp%-2u", dev, pno);
		else
			sprintf(bufp, "%s%-2u", dev, pno);
	}
	return bufp;
}

char *
partname(char *dev, int pno, int lth) {
	return partnamebf(dev, pno, lth, 0, NULL);
}
