%define name		icewm
%define version		1.0.6
%define release		5
%define group		X11/Window Managers

%define prefix		%{_usr}
%define exec_prefix	%{_usr}/X11R6
%define sysconfdir	%{_sysconfdir}
%define bindir		%{exec_prefix}/bin/
%define libdir		%{exec_prefix}/lib/X11/icewm/
%define locdir		%{prefix}/share/locale/
%define docdir		%{_defaultdocdir}

Name:		%{name}
Version:	%{version}
Release:	%{release}
Summary:	X11 Window Manager
Group:		%{group}
Copyright:	LGPL
URL:		http://www.icewm.org/
Packager:       Mathias Hasselmann <mathias.hasselmann@gmx.de>
Source:		http://download.sourceforge.net/icewm/%{name}-%{version}-%{release}.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-buildroot

%description
Window Manager for X Window System. Can emulate the look of Windows'95, OS/2
Warp 3,4, Motif or the Java Metal GUI. Tries to take the best features of the
above systems. Features multiple workspaces, opaque move/resize, task bar,
window list, mailbox status, digital clock. Fast and small.

%ifarch noarch # =============================================== noarch part ===

%package -n %{name}-common
Summary:	X11 Window Manager
Group:		%{group}
Requires:       %{name}-bin = %{version}-%{release}

%description -n %{name}-common
Window Manager for X Window System. Can emulate the look of Windows'95, OS/2
Warp 3,4, Motif or the Java Metal GUI. Tries to take the best features of the
above systems. Features multiple workspaces, opaque move/resize, task bar,
window list, mailbox status, digital clock. Fast and small.

This package provides the necessary data files. To make this package useful,
you have to install one of the binary packages: icewm-lite, icewm-default
or icewm-gnome.

%prep
%setup -D -T

%build
pushd default/%{name}-%{version} # --------------------- build documentation ---
  make docs icewm.lsm
popd

%install
pushd default/%{name}-%{version} # --- install documentation and common data ---
  make install \
    prefix=$RPM_BUILD_ROOT%{prefix} \
    exec_prefix=$RPM_BUILD_ROOT%{exec_prefix} \
    sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} \
    DOCDIR=$RPM_BUILD_ROOT%{docdir}
popd

%files -n %{name}-common
%defattr(-,root,root)
%doc README COPYING CHANGES TODO BUGS FAQ* doc/*.html doc/icewm.sgml
%doc default/%{name}-%{version}/icewm.lsm
%dir %{libdir}
%dir %{locdir}
%{libdir}/*
%{locdir}/*

%else # ======================================================== binary part ===

%package -n %{name}-default
Summary:	The default version of IceWM
Group:		%{group}
Requires:       %{name}-common = %{version}-%{release}, xpm
Provides:       %{name}-bin = %{version}-%{release}
Conflicts:      %{name}-gnome, %{name}-lite

%description -n %{name}-default
Window Manager for X Window System. Can emulate the look of Windows'95, OS/2
Warp 3,4, Motif or the Java Metal GUI. Tries to take the best features of the
above systems. Features multiple workspaces, opaque move/resize, task bar,
window list, mailbox status, digital clock. Fast and small.

This version is compiled with nothing but the default settings.

%package lite
Summary:	A lightweight version of IceWM
Group:		%{group}
Requires:       %{name}-common = %{version}-%{release}, xpm
Provides:       %{name}-bin = %{version}-%{release}
Conflicts:      %{name}-gnome, %{name}-default

%description lite
Window Manager for X Window System. Can emulate the look of Windows'95, OS/2
Warp 3,4, Motif or the Java Metal GUI. Tries to take the best features of the
above systems. Features multiple workspaces, opaque move/resize, task bar,
window list, mailbox status, digital clock. Fast and small.

This is the lite version with minimal features.


%package gnome
Summary:	The GNOME version of IceWM
Group:		%{group}
Requires:       %{name}-common = %{version}-%{release}, imlib, gnome-libs
Provides:       %{name}-bin = %{version}-%{release}
Conflicts:      %{name}-lite, %{name}-default

%description	gnome
Window Manager for X Window System. Can emulate the look of Windows'95, OS/2
Warp 3,4, Motif or the Java Metal GUI. Tries to take the best features of the
above systems. Features multiple workspaces, opaque move/resize, task bar,
window list, mailbox status, digital clock. Fast and small.

This is the GNOME version with all the necessary features build in.

%prep
%setup -q

for i in default lite gnome; do
  mkdir -p ${i} && pushd ${i} && bzip2 -dc %{SOURCE0} | tar xf - && popd
done

%build
pushd default/%{name}-%{version} # --------------- build the default version ---
  CXXFLAGS="$RPM_OPT_FLAGS" ./configure \
    --prefix=%{prefix} --exec-prefix=%{exec_prefix} --with-docdir=%{docdir} \
    --disable-debug --enable-i18n --enable-nls --disable-guievents \
    --without-gnome-menus --with-xpm
  make
popd

pushd lite/%{name}-%{version} # --------------------- build the lite version ---
  CXXFLAGS="$RPM_OPT_FLAGS" ./configure \
    --prefix=%{prefix} --exec-prefix=%{exec_prefix} --with-docdir=%{docdir} \
    --disable-debug --disable-i18n --disable-nls --disable-guievents \
    --enable-lite --without-gnome-menus --with-xpm
  make
popd

pushd gnome/%{name}-%{version} # ------------------- build the GNOME version ---
  CXXFLAGS="$RPM_OPT_FLAGS" ./configure \
    --prefix=%{prefix} --exec-prefix=%{exec_prefix} --with-docdir=%{docdir} \
    --disable-debug --enable-i18n --enable-nls --enable-guievents \
    --with-gnome-menus --with-imlib
  make
popd

# ------------------------------------------------- build the noarch package ---
rpm -bb --target=noarch-%{_vendor}-%{_os} icewm.spec

%install
# Remove the installed binaries from the install path.
# We still have them in a safe location
rm -f $RPM_BUILD_ROOT%{bindir}icewm{,bg,hint}

# Install the binaries as $BINARY_NAME-$SUBPACKAGE_NAME
for i in default lite gnome; do
  for b in icewm{,bg,hint}; do
    cp ${i}/%{name}-%{version}/src/${b} $RPM_BUILD_ROOT%{bindir}${b}-${i}
  done
done

# Strip the binaries before we install them
# strip $RPM_BUILD_ROOT%{bindir}/icewm{,bg,hint}-{lite,default,gnome} || :

%post -n %{name}-default
# Create a symlink from %{bindir}icewm-default to %{bindir}icewm
# so that we have a icewm "binary" in the standard location
for i in icewm{,bg,hint}; do ln -sf %{bindir}${i}-default %{bindir}${i}; done
%postun -n %{name}-default
  # Remove the symlinks we created
  [ "$1" = 0 ] && { for i in icewm{,bg,hint}; do rm -f %{bindir}${i}; done; }

%post lite
# Create a symlink from %{bindir}icewm-lite to %{bindir}icewm
# so that we have a icewm "binary" in the standard location
for i in icewm{,bg,hint}; do ln -sf %{bindir}${i}-lite %{bindir}${i}; done
%postun lite
# Remove the symlinks we created
[ "$1" = 0 ] && { for i in icewm{,bg,hint}; do rm -f %{bindir}${i}; done; }

%post gnome
# Create a symlink from %{bindir}icewm-gnome to %{bindir}icewm
# so that we have a icewm "binary" in the standard location
for i in icewm{,bg,hint}; do ln -sf %{bindir}${i}-gnome %{bindir}${i}; done
%postun gnome
# Remove the symlinks we created
[ "$1" = 0 ] && { for i in icewm{,bg,hint}; do rm -f %{bindir}${i}; done; }

%files -n %{name}-default
%defattr(-,root,root)
%{bindir}icewm-default
%{bindir}icewmhint-default
%{bindir}icewmbg-default

%files lite
%defattr(-,root,root)
%{bindir}icewm-lite
%{bindir}icewmhint-lite
%{bindir}icewmbg-lite

%files gnome
%defattr(-,root,root)
%{bindir}icewm-gnome
%{bindir}icewmhint-gnome
%{bindir}icewmbg-gnome

%clean
test -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != "/" && rm -rf $RPM_BUILD_ROOT

%endif

%changelog
* Fri Feb 16 2001 Pavel Roskin <proski@gnu.org> 1.0.7-2
- fixed the bash2 problem

* Fri Jan 12 2001 Mathias Hasselmann <mathias.hasselmann@gmx.de> 1.0.6-3

- renamed again: icewm-common-VERSION-RELEASE.noarch.rpm and
  icewm-{default,lite,gnome}-VERSION-RELEASE.ARCH.rpm
- noarch.rpm is built recursively by the src.rpm
- support for docdir (Mandrake)

* Mon Jan  8 2001 Mathias Hasselmann <mathias.hasselmann@gmx.de> 1.0.6-2

- translated messages weren't packaged
- new macros: bindir, libdir, localedir

* Mon Jan  8 2001 Mathias Hasselmann <mathias.hasselmann@gmx.de> 1.0.6-1

- "Backported" to RPM3 (%make variable)
- icewm.lsm was not packaged
- changed icewm-{lite,default,gnome} to icewm-{lite,default,gnome} to
  avoid confusion
- extended default description

* Thu Jan  4 2001 Alexander Skwar <ASkwar@DigitalProjects.com> 1.0.5-1

- Completely rewrote spec file to do away with needing
  three different src.rpm's
