/*
 *  linux/include/linux/ext2_fs.h
 *
 * Copyright (C) 1992, 1993, 1994, 1995
 * Remy Card (card@masi.ibp.fr)
 * Laboratoire MASI - Institut Blaise Pascal
 * Universite Pierre et Marie Curie (Paris VI)
 *
 *  from
 *
 *  linux/include/linux/minix_fs.h
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

/*
 * EXT2_*_*() convienience macros added by Andrew Clausen <clausen@gnu.org>
 * Copyright (C) 2000 Free Software Foundation, Inc.
 */

#ifndef _EXT2_FS_H
#define _EXT2_FS_H

static const char _ext2_fs_h[] = "$Id: ext2_fs.h,v 1.3 1999/12/31 09:36:41 buytenh Exp $";

#include <parted/endian.h>

/*
 * The second extended filesystem constants/structures
 */

#define EXT2_SUPER_MAGIC_CONST	0xEF53
#define EXT2_MIN_BLOCK_SIZE	1024
#define EXT2_NDIR_BLOCKS	12
#define EXT2_IND_BLOCK		EXT2_NDIR_BLOCKS
#define EXT2_DIND_BLOCK		(EXT2_IND_BLOCK + 1)
#define EXT2_TIND_BLOCK		(EXT2_DIND_BLOCK + 1)
#define EXT2_N_BLOCKS		(EXT2_TIND_BLOCK + 1)
#define EXT2_VALID_FS		0x0001
#define EXT2_ERROR_FS		0x0002
#define EXT2_RESERVED_INODE_COUNT	11

#define EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER 0x0001
#define EXT2_FEATURE_INCOMPAT_FILETYPE 0x0002

/*
 * Special inodes numbers
 */
#define	EXT2_BAD_INO		 1	/* Bad blocks inode */
#define EXT2_ROOT_INO		 2	/* Root inode */
#define EXT2_ACL_IDX_INO	 3	/* ACL inode */
#define EXT2_ACL_DATA_INO	 4	/* ACL inode */
#define EXT2_BOOT_LOADER_INO	 5	/* Boot loader inode */
#define EXT2_UNDEL_DIR_INO	 6	/* Undelete directory inode */

/*
 * Ext2 directory file types.  Only the low 3 bits are used.  The
 * other bits are reserved for now.
 */
#define EXT2_FT_UNKNOWN		0
#define EXT2_FT_REG_FILE	1
#define EXT2_FT_DIR		2
#define EXT2_FT_CHRDEV		3
#define EXT2_FT_BLKDEV 		4
#define EXT2_FT_FIFO		5
#define EXT2_FT_SOCK		6
#define EXT2_FT_SYMLINK		7

/*
 * Behaviour when detecting errors
 */
#define EXT2_ERRORS_CONTINUE		1	/* Continue execution */
#define EXT2_ERRORS_RO			2	/* Remount fs read-only */
#define EXT2_ERRORS_PANIC		3	/* Panic */
#define EXT2_ERRORS_DEFAULT		EXT2_ERRORS_CONTINUE

struct ext2_dir_entry_2
{
	__u32	inode;
	__u16	rec_len;
	__u8	name_len;
	__u8	file_type;
	char	name[255];
};

struct ext2_group_desc
{
	__u32	bg_block_bitmap;
	__u32	bg_inode_bitmap;
	__u32	bg_inode_table;
	__u16	bg_free_blocks_count;
	__u16	bg_free_inodes_count;
	__u16	bg_used_dirs_count;
	__u16	bg_pad;
	__u32	bg_reserved[3];
};

struct ext2_inode
{
	__u16	i_mode;		/* File mode */
	__u16	i_uid;		/* Owner Uid */
	__u32	i_size;		/* Size in bytes */
	__u32	i_atime;	/* Access time */
	__u32	i_ctime;	/* Creation time */
	__u32	i_mtime;	/* Modification time */
	__u32	i_dtime;	/* Deletion Time */
	__u16	i_gid;		/* Group Id */
	__u16	i_links_count;	/* Links count */
	__u32	i_blocks;	/* Blocks count */
	__u32	i_flags;	/* File flags */
	union {
		struct {
			__u32	l_i_reserved1;
		} linux1;
		struct {
			__u32	h_i_translator;
		} hurd1;
		struct {
			__u32	m_i_reserved1;
		} masix1;
	} osd1;			/* OS dependent 1 */
	__u32	i_block[EXT2_N_BLOCKS];/* Pointers to blocks */
	__u32	i_generation;	/* File version (for NFS) */
	__u32	i_file_acl;	/* File ACL */
	__u32	i_dir_acl;	/* Directory ACL */
	__u32	i_faddr;	/* Fragment address */
	union {
		struct {
			__u8	l_i_frag;	/* Fragment number */
			__u8	l_i_fsize;	/* Fragment size */
			__u16	i_pad1;
			__u32	l_i_reserved2[2];
		} linux2;
		struct {
			__u8	h_i_frag;	/* Fragment number */
			__u8	h_i_fsize;	/* Fragment size */
			__u16	h_i_mode_high;
			__u16	h_i_uid_high;
			__u16	h_i_gid_high;
			__u32	h_i_author;
		} hurd2;
		struct {
			__u8	m_i_frag;	/* Fragment number */
			__u8	m_i_fsize;	/* Fragment size */
			__u16	m_pad1;
			__u32	m_i_reserved2[2];
		} masix2;
	} osd2;					/* OS dependent 2 */
};

struct ext2_super_block
{
	__u32	s_inodes_count;		/* Inodes count */
	__u32	s_blocks_count;		/* Blocks count */
	__u32	s_r_blocks_count;	/* Reserved blocks count */
	__u32	s_free_blocks_count;	/* Free blocks count */
	__u32	s_free_inodes_count;	/* Free inodes count */
	__u32	s_first_data_block;	/* First Data Block */
	__u32	s_log_block_size;	/* Block size */
	__s32	s_log_frag_size;	/* Fragment size */
	__u32	s_blocks_per_group;	/* # Blocks per group */
	__u32	s_frags_per_group;	/* # Fragments per group */
	__u32	s_inodes_per_group;	/* # Inodes per group */
	__u32	s_mtime;		/* Mount time */
	__u32	s_wtime;		/* Write time */
	__u16	s_mnt_count;		/* Mount count */
	__s16	s_max_mnt_count;	/* Maximal mount count */
	__u16	s_magic;		/* Magic signature */
	__u16	s_state;		/* File system state */
	__u16	s_errors;		/* Behaviour when detecting errors */
	__u16	s_minor_rev_level;	/* minor revision level */
	__u32	s_lastcheck;		/* time of last check */
	__u32	s_checkinterval;	/* max. time between checks */
	__u32	s_creator_os;		/* OS */
	__u32	s_rev_level;		/* Revision level */
	__u16	s_def_resuid;		/* Default uid for reserved blocks */
	__u16	s_def_resgid;		/* Default gid for reserved blocks */
	/*
	 * These fields are for EXT2_DYNAMIC_REV superblocks only.
	 *
	 * Note: the difference between the compatible feature set and
	 * the incompatible feature set is that if there is a bit set
	 * in the incompatible feature set that the kernel doesn't
	 * know about, it should refuse to mount the filesystem.
	 * 
	 * e2fsck's requirements are more strict; if it doesn't know
	 * about a feature in either the compatible or incompatible
	 * feature set, it must abort and not try to meddle with
	 * things it doesn't understand...
	 */
	__u32	s_first_ino;		/* First non-reserved inode */
	__u16	s_inode_size;		/* size of inode structure */
	__u16	s_block_group_nr;	/* block group # of this superblock */
	__u32	s_feature_compat;	/* compatible feature set */
	__u32	s_feature_incompat;	/* incompatible feature set */
	__u32	s_feature_ro_compat;	/* readonly-compatible feature set */
	__u8	s_uuid[16];		/* 128-bit uuid for volume */
	char	s_volume_name[16];	/* volume name */
	char	s_last_mounted[64];	/* directory where last mounted */
	__u32	s_algorithm_usage_bitmap;  /* For compression */
	/*
	 * Performance hints.  Directory preallocation should only
	 * happen if the EXT2_COMPAT_PREALLOC flag is on.
	 */
	__u8	s_prealloc_blocks;	/* Nr of blocks to try to preallocate*/
	__u8	s_prealloc_dir_blocks;	/* Nr to preallocate for dirs */
	__u16	s_padding1;
	__u32	s_reserved[204];	/* Padding to the end of the block */
};

#define EXT2_DIRENT_INODE(dir_ent)	(PED_LE32_TO_CPU((dir_ent).inode))
#define EXT2_DIRENT_REC_LEN(dir_ent)	(PED_LE16_TO_CPU((dir_ent).rec_len))
#define EXT2_DIRENT_NAME_LEN(dir_ent)	((dir_ent).name_len)
#define EXT2_DIRENT_FILE_TYPE(dir_ent)	((dir_ent).file_type)

#define EXT2_GROUP_BLOCK_BITMAP(gd)	(PED_LE32_TO_CPU((gd).bg_block_bitmap))
#define EXT2_GROUP_INODE_BITMAP(gd)	(PED_LE32_TO_CPU((gd).bg_inode_bitmap))
#define EXT2_GROUP_INODE_TABLE(gd)	(PED_LE32_TO_CPU((gd).bg_inode_table))
#define EXT2_GROUP_FREE_BLOCKS_COUNT(gd) \
		(PED_LE16_TO_CPU((gd).bg_free_blocks_count))
#define EXT2_GROUP_FREE_INODES_COUNT(gd) \
		(PED_LE16_TO_CPU((gd).bg_free_inodes_count))
#define EXT2_GROUP_USED_DIRS_COUNT(gd) \
		(PED_LE16_TO_CPU((gd).bg_used_dirs_count))

#define EXT2_INODE_MODE(inode)		(PED_LE16_TO_CPU((inode).i_mode))
#define EXT2_INODE_UID(inode)		(PED_LE16_TO_CPU((inode).i_uid))
#define EXT2_INODE_SIZE(inode)		(PED_LE32_TO_CPU((inode).i_size))
#define EXT2_INODE_ATIME(inode)		(PED_LE32_TO_CPU((inode).i_atime))
#define EXT2_INODE_CTIME(inode)		(PED_LE32_TO_CPU((inode).i_ctime))
#define EXT2_INODE_MTIME(inode)		(PED_LE32_TO_CPU((inode).i_mtime))
#define EXT2_INODE_DTIME(inode)		(PED_LE32_TO_CPU((inode).i_dtime))
#define EXT2_INODE_GID(inode)		(PED_LE16_TO_CPU((inode).i_gid))
#define EXT2_INODE_LINKS_COUNT(inode)	(PED_LE16_TO_CPU((inode).i_links_count))
#define EXT2_INODE_BLOCKS(inode)	(PED_LE32_TO_CPU((inode).i_blocks))
#define EXT2_INODE_FLAGS(inode)		(PED_LE32_TO_CPU((inode).i_flags))
#define EXT2_INODE_BLOCK(inode, blk)	(PED_LE32_TO_CPU((inode).i_block[blk]))

#define EXT2_SUPER_INODES_COUNT(sb)	(PED_LE32_TO_CPU((sb).s_inodes_count))
#define EXT2_SUPER_BLOCKS_COUNT(sb)	(PED_LE32_TO_CPU((sb).s_blocks_count))
#define EXT2_SUPER_R_BLOCKS_COUNT(sb)	(PED_LE32_TO_CPU((sb).s_r_blocks_count))
#define EXT2_SUPER_FREE_BLOCKS_COUNT(sb) \
		(PED_LE32_TO_CPU((sb).s_free_blocks_count))
#define EXT2_SUPER_FREE_INODES_COUNT(sb) \
		(PED_LE32_TO_CPU((sb).s_free_inodes_count))
#define EXT2_SUPER_FIRST_DATA_BLOCK(sb) \
		(PED_LE32_TO_CPU((sb).s_first_data_block))
#define EXT2_SUPER_LOG_BLOCK_SIZE(sb)	(PED_LE32_TO_CPU((sb).s_log_block_size))
#define EXT2_SUPER_LOG_FRAG_SIZE(sb) \
		((__s32) PED_LE32_TO_CPU((sb).s_log_frag_size))
#define EXT2_SUPER_BLOCKS_PER_GROUP(sb)	\
		(PED_LE32_TO_CPU((sb).s_blocks_per_group))
#define EXT2_SUPER_FRAGS_PER_GROUP(sb) \
	(PED_LE32_TO_CPU((sb).s_frags_per_group))
#define EXT2_SUPER_INODES_PER_GROUP(sb)	\
	(PED_LE32_TO_CPU((sb).s_inodes_per_group))
#define EXT2_SUPER_MTIME(sb)		(PED_LE32_TO_CPU((sb).s_mtime))
#define EXT2_SUPER_WTIME(sb)		(PED_LE32_TO_CPU((sb).s_wtime))
#define EXT2_SUPER_MNT_COUNT(sb)	(PED_LE16_TO_CPU((sb).s_mnt_count))
#define EXT2_SUPER_MAX_MNT_COUNT(sb) \
		((__s16) PED_LE16_TO_CPU((sb).s_max_mnt_count))
#define EXT2_SUPER_MAGIC(sb)		(PED_LE16_TO_CPU((sb).s_magic))
#define EXT2_SUPER_STATE(sb)		(PED_LE16_TO_CPU((sb).s_state))
#define EXT2_SUPER_ERRORS(sb)		(PED_LE16_TO_CPU((sb).s_errors))
#define EXT2_SUPER_MINOR_REV_LEVEL(sb) \
		(PED_LE16_TO_CPU((sb).s_minor_rev_level))
#define EXT2_SUPER_LASTCHECK(sb)	(PED_LE32_TO_CPU((sb).s_lastcheck))
#define EXT2_SUPER_CHECKINTERVAL(sb)	(PED_LE32_TO_CPU((sb).s_checkinterval))
#define EXT2_SUPER_CREATOR_OS(sb)	(PED_LE32_TO_CPU((sb).s_creator_os))
#define EXT2_SUPER_REV_LEVEL(sb)	(PED_LE32_TO_CPU((sb).s_rev_level))
#define EXT2_SUPER_DEF_RESUID(sb)	(PED_LE16_TO_CPU((sb).s_def_resuid))
#define EXT2_SUPER_DEF_RESGID(sb)	(PED_LE16_TO_CPU((sb).s_def_resgid))

#define EXT2_SUPER_FIRST_INO(sb)	(PED_LE32_TO_CPU((sb).s_first_ino))
#define EXT2_SUPER_INODE_SIZE(sb)	(PED_LE16_TO_CPU((sb).s_inode_size))
#define EXT2_SUPER_BLOCK_GROUP_NR(sb)	(PED_LE16_TO_CPU((sb).s_block_group_nr))
#define EXT2_SUPER_FEATURE_COMPAT(sb)	(PED_LE32_TO_CPU((sb).s_feature_compat))
#define EXT2_SUPER_FEATURE_INCOMPAT(sb) \
		(PED_LE32_TO_CPU((sb).s_feature_incompat))
#define EXT2_SUPER_FEATURE_RO_COMPAT(sb) \
		(PED_LE32_TO_CPU((sb).s_feature_ro_compat))
#define EXT2_SUPER_UUID(sb)		((sb).s_uuid)
#define EXT2_VOLUME_NAME(sb)		((sb).s_volume_name)
#define EXT2_LAST_MOUNTED(sb)		((sb).s_last_mounted)
#define EXT2_SUPER_ALGORITHM_USAGE_BITMAP(sb) \
		(PED_LE32_TO_CPU((sb).s_algorithm_usage_bitmap))

#endif
