/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class TextureChooser
extends JPanel {
    public static Object texture = TextureChooser.getGeomTexture();
    public int num;

    public TextureChooser(int n) {
        this.num = n;
        this.setLayout(new GridLayout(0, 2, 5, 5));
        this.setBorder(new TitledBorder(new EtchedBorder(), "Texture Chooser"));
        this.add(new Surface(TextureChooser.getGeomTexture(), this, 0));
        this.add(new Surface(this.getImageTexture(), this, 1));
        this.add(new Surface(this.getTextTexture(), this, 2));
        this.add(new Surface(this.getGradientPaint(), this, 3));
    }

    public static TexturePaint getGeomTexture() {
        BufferedImage bufferedImage = new BufferedImage(5, 5, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, 5, 5);
        graphics2D.setColor(new Color(211, 211, 211, 200));
        graphics2D.fill(new Ellipse2D.Float(0.0f, 0.0f, 5.0f, 5.0f));
        Rectangle rectangle = new Rectangle(0, 0, 5, 5);
        return new TexturePaint(bufferedImage, rectangle);
    }

    public TexturePaint getImageTexture() {
        Image image = DemoImages.getImage("HotJava-16.gif", this);
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, this);
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        return new TexturePaint(bufferedImage, rectangle);
    }

    public TexturePaint getTextTexture() {
        Font font = new Font("Times New Roman", 1, 10);
        TextLayout textLayout = new TextLayout("Java2D", font, new FontRenderContext(null, false, false));
        int n = (int)textLayout.getBounds().getWidth();
        int n2 = (int)(textLayout.getAscent() + textLayout.getDescent());
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, n, n2);
        graphics2D.setColor(Color.lightGray);
        textLayout.draw(graphics2D, 0.0f, textLayout.getAscent());
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        return new TexturePaint(bufferedImage, rectangle);
    }

    public GradientPaint getGradientPaint() {
        return new GradientPaint(0.0f, 0.0f, Color.white, 80.0f, 0.0f, Color.green);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Java2D Demo - TextureChooser");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.add("Center", new TextureChooser(0));
        frame.pack();
        ((Component)frame).setSize(new Dimension(400, 400));
        ((Component)frame).setVisible(true);
    }

    public class Surface
    extends JPanel
    implements MouseListener {
        public boolean clickedFrame;
        private int num;
        private TextureChooser tc;
        private boolean enterExitFrame = false;
        private Object t;

        public Surface(Object object, TextureChooser textureChooser2, int n) {
            this.setBackground(Color.white);
            this.t = object;
            this.tc = textureChooser2;
            this.clickedFrame = n == textureChooser2.num;
            this.num = n;
            if (n == textureChooser2.num) {
                texture = object;
            }
            this.addMouseListener(this);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            if (this.t instanceof TexturePaint) {
                graphics2D.setPaint((TexturePaint)this.t);
            } else {
                graphics2D.setPaint((GradientPaint)this.t);
            }
            graphics2D.fill(new Rectangle(0, 0, n, n2));
            if (this.clickedFrame || this.enterExitFrame) {
                graphics2D.setColor(Color.gray);
                BasicStroke basicStroke = new BasicStroke(3.0f, 0, 0);
                graphics2D.setStroke(basicStroke);
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                this.tc.num = this.num;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            texture = this.t;
            this.clickedFrame = true;
            Component[] componentArray = this.tc.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Surface surface;
                if (componentArray[n] instanceof Surface && !(surface = (Surface)componentArray[n]).equals(this) && surface.clickedFrame) {
                    surface.clickedFrame = false;
                    surface.repaint();
                }
                ++n;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.enterExitFrame = true;
            this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.enterExitFrame = false;
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(30, 30);
        }
    }
}

