/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.oneone;

import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.oneone.Configuration11;
import com.sun.tools.doclets.oneone.Html11Writer;
import com.sun.tools.doclets.oneone.OneOne;
import java.io.IOException;
import java.util.Arrays;

public class PackageIndex11Writer
extends Html11Writer {
    protected PackageDoc[] packages;

    public PackageIndex11Writer(String string, RootDoc rootDoc) throws IOException {
        super(string);
        this.packages = rootDoc.specifiedPackages();
        Arrays.sort(this.packages);
    }

    public static void generate(RootDoc rootDoc) throws DocletAbortException {
        String string = "packages.html";
        try {
            PackageIndex11Writer packageIndex11Writer = new PackageIndex11Writer(string, rootDoc);
            packageIndex11Writer.generatePackageIndexFile();
            packageIndex11Writer.close();
        }
        catch (IOException iOException) {
            OneOne.configuration();
            Configuration11.oneonemessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageIndexFile() throws IOException {
        this.printHeader(this.getText("doclet.Package_Summary"));
        this.printNavigationBarHeader();
        this.printIndexContents("doclet.Package_Summary");
        this.printNavigationBarFooter();
        this.printFooter();
    }

    protected void printIndexContents(String string) {
        if (this.packages.length > 0) {
            this.printIndexHeader(string);
            int n = 0;
            while (n < this.packages.length) {
                PackageDoc packageDoc = this.packages[n];
                this.printIndexRow(packageDoc);
                ++n;
            }
            this.printIndexFooter();
        }
    }

    protected void printConfigurationTitle() {
        if (OneOne.configuration().title.length() > 0) {
            this.center();
            this.h2();
            this.print(OneOne.configuration().title);
            this.h2End();
            this.centerEnd();
        }
    }

    protected void printIndexRow(PackageDoc packageDoc) {
        this.li();
        this.print(' ');
        this.printText("doclet.package");
        this.print(' ');
        this.bold();
        this.printPackageLink(packageDoc);
        this.boldEnd();
    }

    protected void printIndexHeader(String string) {
        this.h1();
        this.printImage("package-index", this.getText(string), 238, 37);
        this.h1End();
        this.menu();
    }

    protected void printIndexFooter() {
        this.menuEnd();
        this.p();
    }

    protected void printNavigationBarHeader() {
        this.nav11Links();
        this.hr();
        this.printConfigurationTitle();
    }

    protected void printNavigationBarFooter() {
        this.hr();
        this.nav11Links();
        this.printBottom();
    }

    protected void nav11LinkTree() {
        this.printHyperLink("tree.html", this.getText("doclet.Class_Hierarchy"));
        this.doubleSpace();
    }

    protected void nav11LinkIndex() {
        this.printHyperLink("index-1.html", this.getText("doclet.Index"));
        this.doubleSpace();
    }

    protected void nav11LinkHelp() {
        this.printHyperLink("help.html", this.getText("doclet.Help"));
    }

    protected void nav11LinkContents() {
    }

    protected void nav11LinkPackage() {
    }

    protected void nav11LinkPrevious() {
    }

    protected void nav11LinkNext() {
    }
}

