/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.util.Hashtable;
import sun.rmi.rmic.iiop.BatchEnvironment;

class NameContext {
    private Hashtable table;
    private boolean allowCollisions;

    public static synchronized NameContext forName(String string, boolean bl, BatchEnvironment batchEnvironment) {
        NameContext nameContext = null;
        if (string == null) {
            string = "null";
        }
        if (batchEnvironment.nameContexts == null) {
            batchEnvironment.nameContexts = new Hashtable();
        } else {
            nameContext = (NameContext)batchEnvironment.nameContexts.get(string);
        }
        if (nameContext == null) {
            nameContext = new NameContext(bl);
            batchEnvironment.nameContexts.put(string, nameContext);
        }
        return nameContext;
    }

    public NameContext(boolean bl) {
        this.allowCollisions = bl;
        this.table = new Hashtable();
    }

    public void assertPut(String string) throws Exception {
        String string2 = this.add(string);
        if (string2 != null) {
            throw new Exception(string2);
        }
    }

    public void put(String string) {
        if (!this.allowCollisions) {
            throw new Error("Must use assertPut(name)");
        }
        this.add(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String add(String string) {
        String string2 = string.toLowerCase();
        Name name = (Name)this.table.get(string2);
        if (name != null) {
            if (string.equals(name.name)) return null;
            if (!this.allowCollisions) return new String("\"" + string + "\" and \"" + name.name + "\"");
            name.collisions = true;
            return null;
        } else {
            this.table.put(string2, new Name(string, false));
        }
        return null;
    }

    public String get(String string) {
        Name name = (Name)this.table.get(string.toLowerCase());
        String string2 = string;
        if (name.collisions) {
            int n = string.length();
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                if (Character.isUpperCase(string.charAt(n2))) {
                    string2 = string2 + "_";
                    string2 = string2 + n2;
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                string2 = string2 + "_";
            }
        }
        return string2;
    }

    public void clear() {
        this.table.clear();
    }

    public class Name {
        public String name;
        public boolean collisions;

        public Name(String string, boolean bl) {
            this.name = string;
            this.collisions = bl;
        }
    }
}

