/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.FocusManager;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.CompositeView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class JEditorPane
extends JTextComponent {
    private EditorKit kit;
    private Hashtable pageProperties;
    private Hashtable typeHandlers;
    private boolean managingFocus = true;
    private static final Object kitRegistryKey = new StringBuffer("JEditorPane.kitRegistry");
    private static final Object kitTypeRegistryKey = new StringBuffer("JEditorPane.kitTypeRegistry");
    private static final Object kitLoaderRegistryKey = new StringBuffer("JEditorPane.kitLoaderRegistry");
    private static final String uiClassID = "EditorPaneUI";
    static /* synthetic */ Class class$javax$swing$event$HyperlinkListener;

    public JEditorPane() {
    }

    public JEditorPane(URL uRL) throws IOException {
        this();
        this.setPage(uRL);
    }

    public JEditorPane(String string) throws IOException {
        this();
        this.setPage(string);
    }

    public JEditorPane(String string, String string2) {
        this();
        this.setContentType(string);
        this.setText(string2);
    }

    public synchronized void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(class$javax$swing$event$HyperlinkListener == null ? (class$javax$swing$event$HyperlinkListener = JEditorPane.class$("javax.swing.event.HyperlinkListener")) : class$javax$swing$event$HyperlinkListener, hyperlinkListener);
    }

    public synchronized void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(class$javax$swing$event$HyperlinkListener == null ? (class$javax$swing$event$HyperlinkListener = JEditorPane.class$("javax.swing.event.HyperlinkListener")) : class$javax$swing$event$HyperlinkListener, hyperlinkListener);
    }

    public void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$HyperlinkListener == null ? JEditorPane.class$("javax.swing.event.HyperlinkListener") : class$javax$swing$event$HyperlinkListener)) {
                ((HyperlinkListener)objectArray[n + 1]).hyperlinkUpdate(hyperlinkEvent);
            }
            n -= 2;
        }
    }

    public void setPage(URL uRL) throws IOException {
        Object object;
        if (uRL == null) {
            throw new IOException("invalid url");
        }
        URL uRL2 = this.getPage();
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        boolean bl = false;
        if (uRL2 == null || !uRL2.sameFile(uRL)) {
            object = this.getStream(uRL);
            if (this.kit != null) {
                int n;
                Object object2;
                Document document = this.kit.createDefaultDocument();
                if (this.pageProperties != null) {
                    object2 = this.pageProperties.keys();
                    while (object2.hasMoreElements()) {
                        Object object3 = object2.nextElement();
                        document.putProperty(object3, this.pageProperties.get(object3));
                    }
                    this.pageProperties.clear();
                }
                if (document.getProperty("stream") == null) {
                    document.putProperty("stream", uRL);
                }
                if (document instanceof AbstractDocument && (n = ((AbstractDocument)(object2 = (AbstractDocument)document)).getAsynchronousLoadPriority()) >= 0) {
                    this.setDocument(document);
                    PageLoader pageLoader = new PageLoader(document, (InputStream)object, n, uRL2, uRL);
                    pageLoader.start();
                    return;
                }
                this.read((InputStream)object, document);
                this.setDocument(document);
                bl = true;
            }
        }
        if ((object = uRL.getRef()) != null) {
            if (!bl) {
                this.scrollToReference((String)object);
            } else {
                SwingUtilities.invokeLater(new Runnable((String)object){
                    private final /* synthetic */ String val$reference;
                    {
                        this.val$reference = string;
                    }

                    public void run() {
                        JEditorPane.this.scrollToReference(this.val$reference);
                    }
                });
            }
        }
        this.firePropertyChange("page", uRL2, uRL);
    }

    public void read(InputStream inputStream, Object object) throws IOException {
        if (object instanceof HTMLDocument && this.kit instanceof HTMLEditorKit) {
            HTMLDocument hTMLDocument = (HTMLDocument)object;
            this.setDocument(hTMLDocument);
            this.read(inputStream, hTMLDocument);
        } else {
            String string = (String)this.getClientProperty("charset");
            InputStreamReader inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
            super.read(inputStreamReader, object);
        }
    }

    void read(InputStream inputStream, Document document) throws IOException {
        try {
            String string = (String)this.getClientProperty("charset");
            InputStreamReader inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
            this.kit.read(inputStreamReader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
        catch (ChangedCharSetException changedCharSetException) {
            String string = changedCharSetException.getCharSetSpec();
            if (changedCharSetException.keyEqualsCharSet()) {
                this.putClientProperty("charset", string);
            } else {
                this.setCharsetFromContentTypeParameters(string);
            }
            inputStream.close();
            URL uRL = (URL)document.getProperty("stream");
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            try {
                document.remove(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            document.putProperty("IgnoreCharsetDirective", new Boolean(true));
            this.read(inputStream, document);
        }
    }

    protected InputStream getStream(URL uRL) throws IOException {
        Object object;
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            boolean bl;
            object = (HttpURLConnection)uRLConnection;
            ((HttpURLConnection)object).setInstanceFollowRedirects(false);
            int n = ((HttpURLConnection)object).getResponseCode();
            boolean bl2 = bl = n >= 300 && n <= 399;
            if (bl) {
                String string = uRLConnection.getHeaderField("Location");
                uRL = string.startsWith("http", 0) ? new URL(string) : new URL(uRL, string);
                return this.getStream(uRL);
            }
        }
        if (this.pageProperties == null) {
            this.pageProperties = new Hashtable();
        }
        if ((object = uRLConnection.getContentType()) != null) {
            this.setContentType((String)object);
            this.pageProperties.put("content-type", object);
        }
        this.pageProperties.put("stream", uRL);
        String string = uRLConnection.getContentEncoding();
        if (string != null) {
            this.pageProperties.put("content-encoding", string);
        }
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    protected void scrollToReference(String string) {
        Document document = this.getDocument();
        if (document instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            while (iterator.isValid()) {
                AttributeSet attributeSet = iterator.getAttributes();
                String string2 = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
                if (string2 != null && string2.equals(string)) {
                    try {
                        Rectangle rectangle = this.modelToView(iterator.getStartOffset());
                        if (rectangle != null) {
                            Rectangle rectangle2 = this.getVisibleRect();
                            rectangle.height = rectangle2.height;
                            this.scrollRectToVisible(rectangle);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        this.getToolkit().beep();
                    }
                }
                iterator.next();
            }
        }
    }

    public URL getPage() {
        return (URL)this.getDocument().getProperty("stream");
    }

    public void setPage(String string) throws IOException {
        if (string == null) {
            throw new IOException("invalid url");
        }
        URL uRL = new URL(string);
        this.setPage(uRL);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected EditorKit createDefaultEditorKit() {
        return new PlainEditorKit();
    }

    public EditorKit getEditorKit() {
        if (this.kit == null) {
            this.kit = this.createDefaultEditorKit();
        }
        return this.kit;
    }

    public final String getContentType() {
        return this.kit != null ? this.kit.getContentType() : null;
    }

    public final void setContentType(String string) {
        Object object;
        int n = string.indexOf(";");
        if (n > -1) {
            object = string.substring(n);
            if ((string = string.substring(0, n).trim()).toLowerCase().startsWith("text/")) {
                this.setCharsetFromContentTypeParameters((String)object);
            }
        }
        if (!(this.kit != null && string.equals(this.kit.getContentType()) || (object = this.getEditorKitForContentType(string)) == null)) {
            this.setEditorKit((EditorKit)object);
        }
    }

    private void setCharsetFromContentTypeParameters(String string) {
        String string2 = null;
        try {
            HeaderParser headerParser;
            int n = string.indexOf(59);
            if (n > -1 && n < string.length() - 1) {
                string = string.substring(n + 1);
            }
            if (string.length() > 0 && (string2 = (headerParser = new HeaderParser(string)).findValue("charset")) != null) {
                this.putClientProperty("charset", string2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            System.err.println("JEditorPane.getCharsetFromContentTypeParameters failed on: " + string);
            exception.printStackTrace();
        }
    }

    public void setEditorKit(EditorKit editorKit) {
        EditorKit editorKit2 = this.kit;
        if (editorKit2 != null) {
            editorKit2.deinstall(this);
        }
        this.kit = editorKit;
        if (this.kit != null) {
            this.kit.install(this);
            this.setDocument(this.kit.createDefaultDocument());
        }
        this.firePropertyChange("editorKit", editorKit2, editorKit);
    }

    public EditorKit getEditorKitForContentType(String string) {
        EditorKit editorKit;
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        if ((editorKit = (EditorKit)this.typeHandlers.get(string)) == null && (editorKit = JEditorPane.createEditorKitForContentType(string)) != null) {
            this.setEditorKitForContentType(string, editorKit);
        }
        if (editorKit == null) {
            editorKit = this.createDefaultEditorKit();
        }
        return editorKit;
    }

    public void setEditorKitForContentType(String string, EditorKit editorKit) {
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        this.typeHandlers.put(string, editorKit);
    }

    public void replaceSelection(String string) {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        EditorKit editorKit = this.getEditorKit();
        if (editorKit instanceof StyledEditorKit) {
            try {
                Document document = this.getDocument();
                Caret caret = this.getCaret();
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                if (n != n2) {
                    document.remove(n, n2 - n);
                }
                if (string != null && string.length() > 0) {
                    document.insertString(n, string, ((StyledEditorKit)editorKit).getInputAttributes());
                }
            }
            catch (BadLocationException badLocationException) {
                this.getToolkit().beep();
            }
        } else {
            super.replaceSelection(string);
        }
    }

    public static EditorKit createEditorKitForContentType(String string) {
        EditorKit editorKit = null;
        Hashtable hashtable = JEditorPane.getKitRegisty();
        editorKit = (EditorKit)hashtable.get(string);
        if (editorKit == null) {
            String string2 = (String)JEditorPane.getKitTypeRegistry().get(string);
            ClassLoader classLoader = (ClassLoader)JEditorPane.getKitLoaderRegistry().get(string);
            try {
                Class clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                editorKit = (EditorKit)clazz.newInstance();
                hashtable.put(string, editorKit);
            }
            catch (Throwable throwable) {
                editorKit = null;
            }
        }
        if (editorKit != null) {
            return (EditorKit)editorKit.clone();
        }
        return null;
    }

    public static void registerEditorKitForContentType(String string, String string2) {
        JEditorPane.getKitLoaderRegistry().remove(string);
        JEditorPane.getKitTypeRegistry().put(string, string2);
        JEditorPane.getKitRegisty().remove(string);
    }

    public static void registerEditorKitForContentType(String string, String string2, ClassLoader classLoader) {
        JEditorPane.getKitTypeRegistry().put(string, string2);
        JEditorPane.getKitLoaderRegistry().put(string, classLoader);
        JEditorPane.getKitRegisty().remove(string);
    }

    public static String getEditorKitClassNameForContentType(String string) {
        return (String)JEditorPane.getKitTypeRegistry().get(string);
    }

    private static Hashtable getKitTypeRegistry() {
        JEditorPane.loadDefaultKitsIfNecessary();
        return (Hashtable)SwingUtilities.appContextGet(kitTypeRegistryKey);
    }

    private static Hashtable getKitLoaderRegistry() {
        JEditorPane.loadDefaultKitsIfNecessary();
        return (Hashtable)SwingUtilities.appContextGet(kitLoaderRegistryKey);
    }

    private static Hashtable getKitRegisty() {
        Hashtable hashtable = (Hashtable)SwingUtilities.appContextGet(kitRegistryKey);
        if (hashtable == null) {
            hashtable = new Hashtable(3);
            SwingUtilities.appContextPut(kitRegistryKey, hashtable);
        }
        return hashtable;
    }

    private static void loadDefaultKitsIfNecessary() {
        if (SwingUtilities.appContextGet(kitTypeRegistryKey) == null) {
            Hashtable hashtable = new Hashtable();
            SwingUtilities.appContextPut(kitTypeRegistryKey, hashtable);
            hashtable = new Hashtable();
            SwingUtilities.appContextPut(kitLoaderRegistryKey, hashtable);
            JEditorPane.registerEditorKitForContentType("text/plain", "javax.swing.JEditorPane$PlainEditorKit");
            JEditorPane.registerEditorKitForContentType("text/html", "javax.swing.text.html.HTMLEditorKit");
            JEditorPane.registerEditorKitForContentType("text/rtf", "javax.swing.text.rtf.RTFEditorKit");
            JEditorPane.registerEditorKitForContentType("application/rtf", "javax.swing.text.rtf.RTFEditorKit");
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getParent() instanceof JViewport) {
            Dimension dimension2;
            int n;
            JViewport jViewport = (JViewport)this.getParent();
            TextUI textUI = this.getUI();
            if (!this.getScrollableTracksViewportWidth()) {
                n = jViewport.getWidth();
                dimension2 = textUI.getMinimumSize(this);
                if (n < dimension2.width) {
                    dimension.width = dimension2.width;
                }
            }
            if (!this.getScrollableTracksViewportHeight()) {
                n = jViewport.getHeight();
                dimension2 = textUI.getMinimumSize(this);
                if (n < dimension2.height) {
                    dimension.height = dimension2.height;
                }
            }
        }
        return dimension;
    }

    public boolean isManagingFocus() {
        return this.managingFocus;
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        super.processComponentKeyEvent(keyEvent);
        if (this.isManagingFocus() && (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t') && keyEvent.getID() == 401 && !this.isEditable() && this.getComponentCount() > 0) {
            this.managingFocus = false;
            try {
                if ((keyEvent.getModifiers() & 1) == 1) {
                    FocusManager.getCurrentManager().focusPreviousComponent(this);
                } else {
                    FocusManager.getCurrentManager().focusNextComponent(this);
                }
                keyEvent.consume();
                Object var3_2 = null;
                this.managingFocus = true;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.managingFocus = true;
                throw throwable;
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (this.isManagingFocus() && (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t')) {
            keyEvent.consume();
        }
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            StringReader stringReader = new StringReader(string);
            EditorKit editorKit = this.getEditorKit();
            editorKit.read(stringReader, document, 0);
        }
        catch (IOException iOException) {
            this.getToolkit().beep();
        }
        catch (BadLocationException badLocationException) {
            this.getToolkit().beep();
        }
    }

    public String getText() {
        String string;
        try {
            StringWriter stringWriter = new StringWriter();
            this.write(stringWriter);
            string = stringWriter.toString();
        }
        catch (IOException iOException) {
            string = null;
        }
        return string;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            TextUI textUI = this.getUI();
            int n = jViewport.getWidth();
            Dimension dimension = textUI.getMinimumSize(this);
            Dimension dimension2 = textUI.getMaximumSize(this);
            if (n >= dimension.width && n <= dimension2.width) {
                return true;
            }
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            TextUI textUI = this.getUI();
            int n = jViewport.getHeight();
            Dimension dimension = textUI.getMinimumSize(this);
            if (n >= dimension.height) {
                Dimension dimension2 = textUI.getMaximumSize(this);
                if (n <= dimension2.height) {
                    return true;
                }
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected String paramString() {
        String string = this.kit != null ? this.kit.toString() : "";
        String string2 = this.typeHandlers != null ? this.typeHandlers.toString() : "";
        return super.paramString() + ",kit=" + string + ",typeHandlers=" + string2;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.getEditorKit() instanceof HTMLEditorKit ? new AccessibleJEditorPaneHTML() : new AccessibleJEditorPane();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class HeaderParser {
        String raw;
        String[][] tab;

        public HeaderParser(String string) {
            this.raw = string;
            this.tab = new String[10][2];
            this.parse();
        }

        private void parse() {
            if (this.raw != null) {
                this.raw = this.raw.trim();
                char[] cArray = this.raw.toCharArray();
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                boolean bl = true;
                boolean bl2 = false;
                int n4 = cArray.length;
                while (n2 < n4) {
                    char c = cArray[n2];
                    if (c == '=') {
                        this.tab[n3][0] = new String(cArray, n, n2 - n).toLowerCase();
                        bl = false;
                        n = ++n2;
                        continue;
                    }
                    if (c == '\"') {
                        if (bl2) {
                            this.tab[n3++][1] = new String(cArray, n, n2 - n);
                            bl2 = false;
                            while (++n2 < n4 && (cArray[n2] == ' ' || cArray[n2] == ',')) {
                            }
                            bl = true;
                            n = n2;
                            continue;
                        }
                        bl2 = true;
                        n = ++n2;
                        continue;
                    }
                    if (c == ' ' || c == ',') {
                        if (bl2) {
                            ++n2;
                            continue;
                        }
                        if (bl) {
                            this.tab[n3++][0] = new String(cArray, n, n2 - n).toLowerCase();
                        } else {
                            this.tab[n3++][1] = new String(cArray, n, n2 - n);
                        }
                        while (n2 < n4 && (cArray[n2] == ' ' || cArray[n2] == ',')) {
                            ++n2;
                        }
                        bl = true;
                        n = n2;
                        continue;
                    }
                    ++n2;
                }
                if (--n2 > n) {
                    if (!bl) {
                        this.tab[n3++][1] = cArray[n2] == '\"' ? new String(cArray, n, n2 - n) : new String(cArray, n, n2 - n + 1);
                    } else {
                        this.tab[n3][0] = new String(cArray, n, n2 - n + 1).toLowerCase();
                    }
                } else if (n2 == n) {
                    if (!bl) {
                        this.tab[n3++][1] = cArray[n2] == '\"' ? String.valueOf(cArray[n2 - 1]) : String.valueOf(cArray[n2]);
                    } else {
                        this.tab[n3][0] = String.valueOf(cArray[n2]).toLowerCase();
                    }
                }
            }
        }

        public String findKey(int n) {
            if (n < 0 || n > 10) {
                return null;
            }
            return this.tab[n][0];
        }

        public String findValue(int n) {
            if (n < 0 || n > 10) {
                return null;
            }
            return this.tab[n][1];
        }

        public String findValue(String string) {
            return this.findValue(string, null);
        }

        public String findValue(String string, String string2) {
            if (string == null) {
                return string2;
            }
            string.toLowerCase();
            int n = 0;
            while (n < 10) {
                if (this.tab[n][0] == null) {
                    return string2;
                }
                if (string.equals(this.tab[n][0])) {
                    return this.tab[n][1];
                }
                ++n;
            }
            return string2;
        }

        public int findInt(String string, int n) {
            try {
                return Integer.parseInt(this.findValue(string, String.valueOf(n)));
            }
            catch (Throwable throwable) {
                return n;
            }
        }
    }

    static class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        PlainEditorKit() {
        }

        public Object clone() {
            return new PlainEditorKit();
        }

        public ViewFactory getViewFactory() {
            return this;
        }

        public View create(Element element) {
            Document document = element.getDocument();
            Object object = document.getProperty("i18n");
            if (object != null && object.equals(Boolean.TRUE)) {
                return this.createI18N(element);
            }
            return new WrappedPlainView(element);
        }

        View createI18N(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new PlainParagraph(element);
                }
                if (string.equals("paragraph")) {
                    return new BoxView(element, 1);
                }
            }
            return null;
        }

        static class PlainParagraph
        extends ParagraphView {
            PlainParagraph(Element element) {
                super(element);
                this.layoutPool = new LogicalView(element);
                this.layoutPool.setParent(this);
            }

            protected void setPropertiesFromAttributes() {
                Container container = this.getContainer();
                if (container != null && !container.getComponentOrientation().isLeftToRight()) {
                    this.setJustification(2);
                } else {
                    this.setJustification(0);
                }
            }

            public int getFlowSpan(int n) {
                JTextArea jTextArea;
                Container container = this.getContainer();
                if (container instanceof JTextArea && !(jTextArea = (JTextArea)container).getLineWrap()) {
                    return Integer.MAX_VALUE;
                }
                return super.getFlowSpan(n);
            }

            protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
                JTextArea jTextArea;
                SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
                Container container = this.getContainer();
                if (container instanceof JTextArea && !(jTextArea = (JTextArea)container).getLineWrap()) {
                    sizeRequirements2.minimum = sizeRequirements2.preferred;
                }
                return sizeRequirements2;
            }

            static class LogicalView
            extends CompositeView {
                LogicalView(Element element) {
                    super(element);
                }

                protected int getViewIndexAtPosition(int n) {
                    Element element = this.getElement();
                    if (element.getElementCount() > 0) {
                        return element.getElementIndex(n);
                    }
                    return 0;
                }

                protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
                    return false;
                }

                protected void loadChildren(ViewFactory viewFactory) {
                    Element element = this.getElement();
                    if (element.getElementCount() > 0) {
                        super.loadChildren(viewFactory);
                    } else {
                        GlyphView glyphView = new GlyphView(element);
                        this.append(glyphView);
                    }
                }

                public float getPreferredSpan(int n) {
                    if (this.getViewCount() != 1) {
                        throw new Error("One child view is assumed.");
                    }
                    View view = this.getView(0);
                    return view.getPreferredSpan(n);
                }

                protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
                    view.setParent(this);
                    super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
                }

                public void paint(Graphics graphics, Shape shape) {
                }

                protected boolean isBefore(int n, int n2, Rectangle rectangle) {
                    return false;
                }

                protected boolean isAfter(int n, int n2, Rectangle rectangle) {
                    return false;
                }

                protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
                    return null;
                }

                protected void childAllocation(int n, Rectangle rectangle) {
                }
            }
        }
    }

    protected class JEditorPaneAccessibleHypertextSupport
    extends AccessibleJEditorPane
    implements AccessibleHypertext {
        LinkVector hyperlinks = new LinkVector();
        boolean linksValid = false;

        private void buildLinkTable() {
            this.hyperlinks.removeAllElements();
            Document document = JEditorPane.this.getDocument();
            if (document != null) {
                Element element;
                ElementIterator elementIterator = new ElementIterator(document);
                while ((element = elementIterator.next()) != null) {
                    String string;
                    if (!element.isLeaf()) continue;
                    AttributeSet attributeSet = element.getAttributes();
                    AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                    String string2 = string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                    if (string == null) continue;
                    this.hyperlinks.addElement(new HTMLLink(element));
                }
            }
            this.linksValid = true;
        }

        public JEditorPaneAccessibleHypertextSupport() {
            Document document = JEditorPane.this.getDocument();
            if (document != null) {
                document.addDocumentListener(new DocumentListener(this){
                    private final /* synthetic */ JEditorPaneAccessibleHypertextSupport this$1;
                    {
                        this.this$1 = jEditorPaneAccessibleHypertextSupport;
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.this$1.linksValid = false;
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.this$1.linksValid = false;
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.this$1.linksValid = false;
                    }
                });
            }
        }

        public int getLinkCount() {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            return this.hyperlinks.size();
        }

        public int getLinkIndex(int n) {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            Element element = null;
            Document document = JEditorPane.this.getDocument();
            if (document != null) {
                element = document.getDefaultRootElement();
                while (!element.isLeaf()) {
                    int n2 = element.getElementIndex(n);
                    element = element.getElement(n2);
                }
            }
            return this.hyperlinks.baseElementIndex(element);
        }

        public AccessibleHyperlink getLink(int n) {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            if (n >= 0 && n < this.hyperlinks.size()) {
                return (AccessibleHyperlink)this.hyperlinks.elementAt(n);
            }
            return null;
        }

        public String getLinkText(int n) {
            Document document;
            Element element;
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            if ((element = (Element)this.hyperlinks.elementAt(n)) != null && (document = JEditorPane.this.getDocument()) != null) {
                try {
                    return document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            return null;
        }

        private class LinkVector
        extends Vector {
            private LinkVector() {
            }

            public int baseElementIndex(Element element) {
                int n = 0;
                while (n < this.elementCount) {
                    HTMLLink hTMLLink = (HTMLLink)this.elementAt(n);
                    if (hTMLLink.element == element) {
                        return n;
                    }
                    ++n;
                }
                return -1;
            }
        }

        public class HTMLLink
        extends AccessibleHyperlink {
            Element element;

            public HTMLLink(Element element) {
                this.element = element;
            }

            public boolean isValid() {
                return JEditorPaneAccessibleHypertextSupport.this.linksValid;
            }

            public int getAccessibleActionCount() {
                return 1;
            }

            public boolean doAccessibleAction(int n) {
                URL uRL;
                if (n == 0 && this.isValid() && (uRL = (URL)this.getAccessibleActionObject(n)) != null) {
                    HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(JEditorPane.this, HyperlinkEvent.EventType.ACTIVATED, uRL);
                    JEditorPane.this.fireHyperlinkUpdate(hyperlinkEvent);
                    return true;
                }
                return false;
            }

            public String getAccessibleActionDescription(int n) {
                Document document;
                if (n == 0 && this.isValid() && (document = JEditorPane.this.getDocument()) != null) {
                    try {
                        return document.getText(this.getStartIndex(), this.getEndIndex() - this.getStartIndex());
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                return null;
            }

            public Object getAccessibleActionObject(int n) {
                if (n == 0 && this.isValid()) {
                    String string;
                    AttributeSet attributeSet = this.element.getAttributes();
                    AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                    String string2 = string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                    if (string != null) {
                        URL uRL;
                        try {
                            uRL = new URL(JEditorPane.this.getPage(), string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            uRL = null;
                        }
                        return uRL;
                    }
                }
                return null;
            }

            public Object getAccessibleActionAnchor(int n) {
                return this.getAccessibleActionDescription(n);
            }

            public int getStartIndex() {
                return this.element.getStartOffset();
            }

            public int getEndIndex() {
                return this.element.getEndOffset();
            }
        }
    }

    protected class AccessibleJEditorPaneHTML
    extends AccessibleJEditorPane {
        protected AccessibleJEditorPaneHTML() {
        }

        public AccessibleText getAccessibleText() {
            return new JEditorPaneAccessibleHypertextSupport();
        }
    }

    protected class AccessibleJEditorPane
    extends JTextComponent.AccessibleJTextComponent {
        protected AccessibleJEditorPane() {
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            return JEditorPane.this.getContentType();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.MULTI_LINE);
            return accessibleStateSet;
        }
    }

    class PageLoader
    extends Thread {
        InputStream in;
        URL old;
        URL page;
        Document doc;

        PageLoader(Document document, InputStream inputStream, int n, URL uRL, URL uRL2) {
            this.setPriority(n);
            this.in = inputStream;
            this.old = uRL;
            this.page = uRL2;
            this.doc = document;
        }

        public void run() {
            try {
                block4: {
                    try {
                        JEditorPane.this.read(this.in, this.doc);
                        URL uRL = (URL)this.doc.getProperty("stream");
                        String string = uRL.getRef();
                        if (string == null) break block4;
                        Runnable runnable = new Runnable(this){
                            private final /* synthetic */ PageLoader this$1;
                            {
                                this.this$1 = pageLoader;
                            }

                            public void run() {
                                URL uRL = (URL)PageLoader.access$000(this.this$1).getDocument().getProperty("stream");
                                String string = uRL.getRef();
                                PageLoader.access$000(this.this$1).scrollToReference(string);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                    catch (IOException iOException) {
                        JEditorPane.this.getToolkit().beep();
                        Object var5_6 = null;
                        JEditorPane.this.firePropertyChange("page", this.old, this.page);
                    }
                }
                Object var5_5 = null;
                JEditorPane.this.firePropertyChange("page", this.old, this.page);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                JEditorPane.this.firePropertyChange("page", this.old, this.page);
                throw throwable;
            }
        }

        static /* synthetic */ JEditorPane access$000(PageLoader pageLoader) {
            return pageLoader.JEditorPane.this;
        }
    }
}

