/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.awt.motif.PSPaper;

class UPageDialog
extends Dialog
implements ActionListener,
ItemListener {
    public static final int ORIENT_N = 3;
    public static final int WAITING = 0;
    public static final int OK = 1;
    public static final int CANCELLED = 2;
    private int setupStatus = 0;
    private static ResourceBundle messageRB;
    private int orientation;
    private int oldOrientation;
    private PSPaper[] allPapers;
    private int paperSelection;
    private int oldPaperSelection;
    private Choice paperChoices;
    private CheckboxGroup orientCBG;
    private Checkbox[] orientCB = new Checkbox[3];
    private Button okButton;
    private Button cancelButton;

    public UPageDialog(Frame frame, PageFormat pageFormat) {
        super(frame, UPageDialog.getMsg("dialog.title", "Page Setup"), true);
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(10, 0, 0, 0);
        Insets insets3 = new Insets(0, 40, 0, 0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        Font font = this.getFont();
        int n = font == null ? 12 : font.getSize();
        Font font2 = new Font("Dialog", 1, n);
        this.setFont(font2);
        this.allPapers = PSPaper.getAllPapers();
        this.paperChoices = new Choice();
        int n2 = 0;
        while (n2 < this.allPapers.length) {
            this.paperChoices.addItem(this.allPapers[n2].getName());
            ++n2;
        }
        Label label = new Label(UPageDialog.getMsg("label.papersize", "Paper Size:"), 2);
        this.addComponent(label, this, gridBagLayout, gridBagConstraints, 0, 0, 1, 0, 1, 13, 0, insets2);
        this.addComponent(this.paperChoices, this, gridBagLayout, gridBagConstraints, 0, 2, 4, 1, 0, 10, 0, insets);
        this.paperChoices.addItemListener(this);
        this.findPaper(pageFormat);
        this.oldPaperSelection = this.paperSelection;
        this.paperChoices.select(this.paperSelection);
        label = new Label(UPageDialog.getMsg("label.orientation", "Orientation:"), 2);
        this.addComponent(label, this, gridBagLayout, gridBagConstraints, 0, 4, 1, 0, 1, 13, 0, insets2);
        this.orientCBG = new CheckboxGroup();
        this.orientCB[1] = new Checkbox(UPageDialog.getMsg("checkbox.portrait", "Portrait"), this.orientCBG, true);
        this.addComponent(this.orientCB[1], this, gridBagLayout, gridBagConstraints, 0, 5, 2, 0, 1, 17, 0, insets3);
        this.orientCB[1].addItemListener(this);
        this.orientCB[0] = new Checkbox(UPageDialog.getMsg("checkbox.landscape", "Landscape"), this.orientCBG, false);
        this.addComponent(this.orientCB[0], this, gridBagLayout, gridBagConstraints, 0, 6, 2, 0, 1, 17, 0, insets3);
        this.orientCB[0].addItemListener(this);
        this.orientCB[2] = new Checkbox(UPageDialog.getMsg("checkbox.reverselandscape", "Reverse Landscape"), this.orientCBG, false);
        this.addComponent(this.orientCB[2], this, gridBagLayout, gridBagConstraints, 0, 7, 2, 0, 1, 17, 0, insets3);
        this.orientCB[2].addItemListener(this);
        this.orientation = pageFormat != null ? pageFormat.getOrientation() : 1;
        this.oldOrientation = this.orientation;
        this.orientCBG.setCurrent(this.orientCB[this.orientation]);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 28, 10));
        this.addComponent(panel, this, gridBagLayout, gridBagConstraints, 0, 12, 4, 1, 0, 10, 0, insets);
        this.okButton = new Button(UPageDialog.getMsg("button.ok", "OK"));
        panel.add(this.okButton);
        this.cancelButton = new Button(UPageDialog.getMsg("button.cancel", "Cancel"));
        panel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UPageDialog.this.setupStatus = 2;
                UPageDialog.this.orientation = UPageDialog.this.oldOrientation;
                UPageDialog.this.paperSelection = UPageDialog.this.oldPaperSelection;
                UPageDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setModal(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof Checkbox) {
            int n = 0;
            while (n < 3) {
                if (itemEvent.getSource() == this.orientCB[n]) {
                    this.orientation = n;
                    return;
                }
                ++n;
            }
        } else if (itemEvent.getSource() instanceof Choice) {
            this.paperSelection = this.paperChoices.getSelectedIndex();
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.setupStatus = 1;
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.setupStatus = 2;
            this.orientation = this.oldOrientation;
            this.paperSelection = this.oldPaperSelection;
            this.setVisible(false);
        }
    }

    public int getSetupStatus() {
        return this.setupStatus;
    }

    public PSPaper getPaper() {
        return this.allPapers[this.paperSelection];
    }

    public int getOrientation() {
        return this.orientation;
    }

    private void findPaper(PageFormat pageFormat) {
        int n;
        int n2;
        this.paperSelection = 0;
        if (pageFormat == null) {
            return;
        }
        int n3 = 2;
        int n4 = 5;
        int n5 = 0;
        while (n5 < this.allPapers.length) {
            int n6;
            int n7;
            int n8;
            int n9;
            PSPaper pSPaper = this.allPapers[n5];
            if (pageFormat.getOrientation() == 1) {
                n2 = (int)Math.abs(pageFormat.getWidth() - pSPaper.getWidth());
                n = (int)Math.abs(pageFormat.getHeight() - pSPaper.getHeight());
                n9 = (int)Math.abs(pageFormat.getImageableX() - pSPaper.getImageableX());
                n8 = (int)Math.abs(pageFormat.getImageableY() - pSPaper.getImageableY());
                n7 = (int)Math.abs(pageFormat.getImageableWidth() - pSPaper.getImageableWidth());
                n6 = (int)Math.abs(pageFormat.getImageableHeight() - pSPaper.getImageableHeight());
            } else {
                n2 = (int)Math.abs(pageFormat.getHeight() - pSPaper.getWidth());
                n = (int)Math.abs(pageFormat.getWidth() - pSPaper.getHeight());
                n9 = (int)Math.abs(pageFormat.getImageableY() - pSPaper.getImageableX());
                n8 = (int)Math.abs(pageFormat.getImageableX() - pSPaper.getImageableY());
                n7 = (int)Math.abs(pageFormat.getImageableHeight() - pSPaper.getImageableWidth());
                n6 = (int)Math.abs(pageFormat.getImageableWidth() - pSPaper.getImageableHeight());
            }
            if (n2 <= n3 && n <= n3 && n9 <= n4 && n8 <= n4 && n7 <= n4 && n6 <= n4) {
                this.paperSelection = n5;
                return;
            }
            ++n5;
        }
        int n10 = 0;
        while (n10 < this.allPapers.length) {
            if (pageFormat.getOrientation() == 1) {
                n2 = (int)Math.abs(pageFormat.getWidth() - this.allPapers[n10].getWidth());
                n = (int)Math.abs(pageFormat.getHeight() - this.allPapers[n10].getHeight());
            } else {
                n2 = (int)Math.abs(pageFormat.getHeight() - this.allPapers[n10].getWidth());
                n = (int)Math.abs(pageFormat.getWidth() - this.allPapers[n10].getHeight());
            }
            if (n2 <= n3 && n <= n3) {
                this.paperSelection = n10;
                return;
            }
            ++n10;
        }
    }

    static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle("sun.awt.motif.resources.pagedialog");
        }
        catch (MissingResourceException missingResourceException) {
            messageRB = null;
        }
    }

    static String getMsg(String string, String string2) {
        if (messageRB == null) {
            UPageDialog.initResource();
        }
        if (messageRB == null) {
            return string2;
        }
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    private void addComponent(Component component, Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6, int n7, Insets insets) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.anchor = n6;
        gridBagConstraints.fill = n7;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = n4;
        gridBagConstraints.weighty = n5;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }
}

