/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.util.Vector;
import sun.awt.im.InputMethodManager;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MWindowAttributes;
import sun.awt.motif.X11InputMethod;
import sun.security.action.GetIntegerAction;

class MWindowPeer
extends MPanelPeer
implements WindowPeer {
    Insets insets = new Insets(0, 0, 0, 0);
    MWindowAttributes winAttr;
    static Vector allWindows = new Vector();
    int iconWidth = -1;
    int iconHeight = -1;
    private Vector imList = new Vector();
    private Vector tcList = new Vector();

    native void create(MComponentPeer var1);

    native void pShow();

    native void pShowModal(boolean var1);

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    native void pSetTitle(String var1);

    public native void setState(int var1);

    public native int getState();

    public native void setResizable(boolean var1);

    native void addTextComponentNative();

    native void removeTextComponentNative();

    public native boolean hasTextComponents();

    native void pSetIMMOption(String var1);

    native void pSetMenuBar(MMenuBarPeer var1);

    native void setSaveUnder(boolean var1);

    private static native void initIDs();

    private static int getInset(String string, int n) {
        Integer n2 = (Integer)AccessController.doPrivileged(new GetIntegerAction(string, n));
        return n2;
    }

    MWindowPeer() {
        this.insets = new Insets(0, 0, 0, 0);
        this.winAttr = new MWindowAttributes();
    }

    MWindowPeer(Window window) {
        this();
        this.init(window);
        allWindows.addElement(this);
    }

    void init(Window window) {
        Color color;
        if (this.winAttr.nativeDecor) {
            this.insets.top = MWindowPeer.getInset("awt.frame.topInset", -1);
            this.insets.left = MWindowPeer.getInset("awt.frame.leftInset", -1);
            this.insets.bottom = MWindowPeer.getInset("awt.frame.bottomInset", -1);
            this.insets.right = MWindowPeer.getInset("awt.frame.rightInset", -1);
        }
        super.init(window);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
        this.pSetTitle(this.winAttr.title);
        if (this.winAttr.decorations == MWindowAttributes.AWT_DECOR_ALL) {
            this.setResizable(this.winAttr.isResizable);
        }
        this.setSaveUnder(true);
        Font font = window.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
            window.setFont(font);
            this.setFont(font);
        }
        if ((color = window.getBackground()) == null) {
            window.setBackground(SystemColor.window);
            this.setBackground(SystemColor.window);
        }
        if ((color = window.getForeground()) == null) {
            window.setForeground(SystemColor.windowText);
            this.setForeground(SystemColor.windowText);
        }
    }

    protected void disposeImpl() {
        allWindows.removeElement(this);
        super.disposeImpl();
    }

    public native void toBack();

    public void toFront() {
        this.pShow();
    }

    public int handleFocusTraversalEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 9 || keyEvent.getSource() instanceof TextArea) {
            return 0;
        }
        if ((keyEvent.getModifiers() & 0xFFFFFFFE) > 0) {
            return 0;
        }
        int n = keyEvent.getID();
        if (n == 402 || n == 400) {
            return 1;
        }
        if (keyEvent.isShiftDown()) {
            return 3;
        }
        return 2;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void handleResize(int n, int n2) {
        if (!this.tcList.isEmpty() && !this.imList.isEmpty()) {
            int n3 = 0;
            while (n3 < this.imList.size()) {
                ((X11InputMethod)this.imList.elementAt(n3)).configureStatus();
                ++n3;
            }
        }
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    public Insets insets() {
        return this.getInsets();
    }

    public void handleMoved(int n, int n2) {
    }

    public void handleActivate() {
    }

    public void handleDeactivate() {
    }

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest(this.target);
    }

    public void addInputMethod(X11InputMethod x11InputMethod) {
        if (!this.imList.contains(x11InputMethod)) {
            this.imList.addElement(x11InputMethod);
        }
    }

    public void removeInputMethod(X11InputMethod x11InputMethod) {
        if (this.imList.contains(x11InputMethod)) {
            this.imList.removeElement(x11InputMethod);
        }
    }

    public void addTextComponent(MComponentPeer mComponentPeer) {
        if (this.tcList.contains(mComponentPeer)) {
            return;
        }
        if (this.tcList.isEmpty()) {
            this.addTextComponentNative();
            if (!this.imList.isEmpty()) {
                int n = 0;
                while (n < this.imList.size()) {
                    ((X11InputMethod)this.imList.elementAt(n)).reconfigureXIC((MInputMethodControl)((Object)this));
                    ++n;
                }
            }
        }
        this.tcList.addElement(mComponentPeer);
    }

    public void removeTextComponent(MComponentPeer mComponentPeer) {
        if (!this.tcList.contains(mComponentPeer)) {
            return;
        }
        this.tcList.removeElement(mComponentPeer);
        if (this.tcList.isEmpty()) {
            this.removeTextComponentNative();
            if (!this.imList.isEmpty()) {
                int n = 0;
                while (n < this.imList.size()) {
                    ((X11InputMethod)this.imList.elementAt(n)).reconfigureXIC((MInputMethodControl)((Object)this));
                    ++n;
                }
            }
        }
    }

    static {
        MWindowPeer.initIDs();
    }
}

