/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import sun.awt.SunClipboard;
import sun.awt.motif.CompositeTransferable;
import sun.awt.motif.FullyRenderedTransferable;
import sun.awt.motif.X11Selection;
import sun.awt.motif.X11SelectionHolder;

public class X11Clipboard
extends SunClipboard
implements X11SelectionHolder {
    private X11Selection clipboardSelection = new X11Selection("CLIPBOARD");
    private X11Selection primarySelection = new X11Selection("PRIMARY");

    public X11Clipboard(String string) {
        super(string);
        this.contents = null;
    }

    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        if (this.owner != null && this.owner != clipboardOwner) {
            this.owner.lostOwnership(this, this.contents);
            this.clipboardSelection.clearContentsData();
            this.primarySelection.clearContentsData();
        }
        this.owner = clipboardOwner;
        this.contents = transferable;
        this.initContext(transferable);
        if (this.clipboardSelection.getSelectionOwnership(transferable, this)) {
            this.primarySelection.getSelectionOwnership(transferable, null);
        } else {
            this.owner = null;
            this.contents = null;
        }
    }

    public synchronized Transferable getContents(Object object) {
        if (this.contents != null) {
            return this.contents;
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new FullyRenderedTransferable(this.clipboardSelection));
        arrayList.add(new FullyRenderedTransferable(this.primarySelection));
        CompositeTransferable compositeTransferable = new CompositeTransferable(Collections.unmodifiableList(arrayList));
        return compositeTransferable;
    }

    public void lostSelectionOwnership() {
        this.primarySelection.clearContentsData();
        this.lostOwnershipImpl();
    }

    protected synchronized void lostOwnership() {
        if (this.owner != null) {
            this.owner.lostOwnership(this, this.contents);
            this.owner = null;
        }
        this.contents = null;
    }
}

