/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.motif.AWTLockAccess;
import sun.awt.motif.MDataTransferer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.SelectionThread;
import sun.awt.motif.X11SelectionHolder;

public class X11Selection {
    static FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
    static Vector selections;
    int atom;
    X11SelectionHolder holder;
    Transferable contents;
    int[] targetArray;
    Object nativeData;
    int format;
    private boolean disposed = false;
    private byte[] data = null;
    private boolean dataAvailable = false;
    private int currentFormat;
    private static Object dummyObj;
    private static Object lock;

    private static native void initIDs();

    static native void init();

    public X11Selection(String string) {
        this.atom = MDataTransferer.getAtomForTarget(string);
        selections.addElement(this);
    }

    protected void finalize() throws Throwable {
        this.clearContentsData();
        this.dispose();
        super.finalize();
    }

    private static Object[] getSelectionsArray() {
        return selections.toArray();
    }

    private int[] getFormatsForFlavors() {
        final Stack stack = new Stack();
        Runnable runnable = new Runnable(){

            public void run() {
                int[] nArray = null;
                try {
                    nArray = MDataTransferer.getInstance().getFormatsForFlavorsAsArray(X11Selection.this.contents.getTransferDataFlavors(), flavorMap);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    AWTLockAccess.awtLock();
                    stack.push(nArray);
                    AWTLockAccess.awtNotifyAll();
                    AWTLockAccess.awtUnlock();
                    throw throwable;
                }
                AWTLockAccess.awtLock();
                stack.push(nArray);
                AWTLockAccess.awtNotifyAll();
                AWTLockAccess.awtUnlock();
            }
        };
        SunToolkit.executeOnEventHandlerThread(dummyObj, runnable);
        while (stack.empty()) {
            AWTLockAccess.awtWait();
        }
        return (int[])stack.pop();
    }

    private byte[] convertData(int n) {
        Object object = lock;
        synchronized (object) {
            this.dataAvailable = false;
            this.data = null;
            this.currentFormat = n;
            Runnable runnable = new Runnable(){

                public void run() {
                    Object object = lock;
                    synchronized (object) {
                        try {
                            Map map = MDataTransferer.getInstance().getFormatsForFlavors(X11Selection.this.contents.getTransferDataFlavors(), flavorMap);
                            DataFlavor dataFlavor = (DataFlavor)map.get(new Integer(X11Selection.this.currentFormat));
                            if (dataFlavor != null) {
                                X11Selection.access$202(X11Selection.this, MDataTransferer.getInstance().translateTransferable(X11Selection.this.contents, dataFlavor, X11Selection.this.currentFormat));
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            X11Selection.access$202(X11Selection.this, null);
                        }
                        X11Selection.this.dataAvailable = true;
                        lock.notify();
                    }
                }
            };
            SunToolkit.executeOnEventHandlerThread(dummyObj, runnable);
            while (!this.dataAvailable) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.data;
    }

    native boolean pGetSelectionOwnership();

    boolean getSelectionOwnership(Transferable transferable, X11SelectionHolder x11SelectionHolder) {
        this.holder = x11SelectionHolder;
        this.contents = transferable;
        if (this.pGetSelectionOwnership()) {
            SunToolkit.insertTargetMapping(dummyObj, AppContext.getAppContext());
            return true;
        }
        this.clearContentsData();
        return false;
    }

    void lostSelectionOwnership() {
        if (this.holder != null) {
            this.holder.lostSelectionOwnership();
        }
        this.clearContentsData();
    }

    void clearContentsData() {
        this.holder = null;
        this.contents = null;
    }

    native void pGetTransferTargets();

    native void pGetTransferData(int[] var1);

    int[] getSelectionTargets() {
        SelectionThread selectionThread;
        this.targetArray = null;
        SelectionThread selectionThread2 = selectionThread = (SelectionThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new SelectionThread(X11Selection.this, null);
            }
        });
        synchronized (selectionThread2) {
            try {
                selectionThread.start();
                selectionThread.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.targetArray;
    }

    public byte[] getSelectionData(int n) throws IOException {
        SelectionThread selectionThread;
        this.nativeData = null;
        final int[] nArray = new int[]{n};
        SelectionThread selectionThread2 = selectionThread = (SelectionThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new SelectionThread(X11Selection.this, nArray);
            }
        });
        synchronized (selectionThread2) {
            try {
                selectionThread.start();
                selectionThread.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!(this.nativeData instanceof byte[])) {
            throw new IOException("could not get transfer data");
        }
        return (byte[])this.nativeData;
    }

    protected void disposeImpl() {
        selections.removeElement(this);
    }

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            X11Selection x11Selection = this;
            synchronized (x11Selection) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    static /* synthetic */ byte[] access$202(X11Selection x11Selection, byte[] byArray) {
        x11Selection.data = byArray;
        return byArray;
    }

    static {
        dummyObj = new Object();
        lock = new Object();
        MToolkit mToolkit = (MToolkit)Toolkit.getDefaultToolkit();
        selections = new Vector();
        X11Selection.initIDs();
        X11Selection.init();
    }
}

