// -*- c++ -*-
//  Generated by gtkmmproc from ./../mdi.gen_h -- DO NOT MODIFY!
#ifndef _GNOMEMM_MDI_H
#define _GNOMEMM_MDI_H

/* $Id: mdi.gen_h,v 1.13 2000/09/05 00:26:09 kenelson Exp $ */


/* mdi.gen_h
 *
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/object.h>
#include <gnome--/app.h>
#include <gnome--/mdi-child.h>
#include <libgnomeui/gnome-mdi.h>

namespace Gnome {
class MDI;
class MDI_Class;
}
namespace Gtk { Gnome::MDI *wrap (GnomeMDI *o); }
extern "C" void gnomemm_app_created(GnomeMDI*,GnomeApp* p1);
namespace Gnome
{

using SigC::Connection;

namespace MDI_Helpers
{

  class MDIList
    {
      public:
        typedef MDIChild*                       value_type;
        typedef value_type &                       reference;
        typedef const value_type &                 const_reference;

        typedef G_List_Cpp_Iterator<GnomeMDIChild,MDIChild>        iterator;
        typedef G_List_ConstIterator<iterator>     const_iterator;
        typedef G_List_ReverseIterator<iterator>   reverse_iterator;
        typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

        typedef size_t                             difference_type;
        typedef size_t                             size_type;

      private:
        friend class Gnome::MDI;
        Gnome::MDI *parent_;
        explicit MDIList(MDI* parent): parent_(parent) {}

        GList*& glist() const;      // front of list

        iterator begin_() const;
        iterator end_() const;

      public:
        ~MDIList() {}

        inline iterator begin()
          {return begin_();}
        inline iterator end()
          {return end_();}

        inline const_iterator begin() const
          { return const_iterator(begin_()); }
        inline const_iterator end() const
          { return const_iterator(end_()); }

        inline reverse_iterator rbegin()
          { return reverse_iterator(end_()); }
        inline reverse_iterator rend()
          { return reverse_iterator(begin_()); }

        inline const_reverse_iterator rbegin() const
          { return const_reverse_iterator(reverse_iterator(end_())); }
        inline const_reverse_iterator rend() const
          { return const_reverse_iterator(reverse_iterator(begin_())); }

        size_type size(void) const;
        inline size_type max_size(void) { return size_type(-1); }
        inline bool empty(void) { return glist() == 0; }


        void clear();

        iterator erase(iterator);
        void erase(iterator start, iterator stop);
        void remove(const_reference);

  void remove(MDIChild &w);
     };
};


// In Gnome MDI holds both views and children, in gnome-- we
// will make a distinction.  MDI holds children, children hold views,
// and there is one active view in a MDI at any one time.
//
// Design notes: (not really documentation)
// MDI contains an APP and Children, Children have views.
// Views are widget (not toplevel)
// mdi->children is a list of MDIChild
// You create a MDI, then ask for a toplevel, add children.
class MDI : public Gtk::Object
{

public:
  typedef MDI          CppObjectType;
  typedef MDI_Class    CppClassType;
  typedef GnomeMDI           BaseObjectType;
  typedef GnomeMDIClass      BaseClassType;

private:
  friend class MDI_Class;
  static CppClassType mdi_class;

  MDI(const MDI&);
  MDI& operator=(const MDI&); // not implemented

protected:
  void   initialize_class();
  explicit MDI(GnomeMDI *castitem);

public:
  static GtkType get_type();
  GnomeMDI* gtkobj()             { return (GnomeMDI*)(gtkobject); }
  const GnomeMDI* gtkobj() const { return (GnomeMDI*)(gtkobject); }
  static bool isA(Gtk::Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~MDI();

private:

public:



  enum Mode {
    DEFAULT  = GNOME_MDI_DEFAULT_MODE,
    TOPLEVEL = GNOME_MDI_TOPLEVEL,
    NOTEBOOK = GNOME_MDI_NOTEBOOK,
    MODAL    = GNOME_MDI_MODAL
  };

  MDI(const Gtk::string &appname, const Gtk::string &title);


  void set_mode(Mode mode=DEFAULT);

  void set_menubar_template(const UI::Array &menu_tmpl);
  void set_toolbar_template(const UI::Array &tbar_tmpl);

  // Sets the desired position of child-specific menus (which are added to and
  // removed from the main menus as views of different children are activated).

  void set_child_menu_path(const Gtk::string& path);

  // Sets the position for insertion of menu items used to activate the MDI
  // children that were added to the MDI. Note that if
  // you want all menu items to be inserted in their own submenu, you have to
  // create that submenu (and leave it empty, of course).

  void set_child_list_path(const Gtk::string& path);

  // Disable inserting menu items for MDI children.
  void clear_child_list_path();

// Lifespan


  void register_object(const Gtk::Object& object);


  void unregister_object(const Gtk::Object& object);


// Views
  // add_view moved to MDIChild::create_view
  // add_toplevel_view moved to MDIChild::create_toplevel_view
  // update_child moved to MDIChild::update
  // set_active_view moved to MDIChild::set_active
  // remove_view moved to MDIChild

// Children



  gint add(Gnome::MDIChild& child);

  // force is depecated


  gint remove(Gnome::MDIChild& child,gint force=false);

  // removes all children and views.
  // force is depecated


  gint clear(gint force=false);

  void open_toplevel ();



  static Gnome::MDIChild* find_child(Gtk::Widget& name);


  Gnome::MDIChild* find_child(const Gtk::string& name);



  Gtk::Widget* get_active_view();


  Gnome::MDIChild* get_active_child();


  Gnome::App* get_active_window();



// This *really* doesn't look good
//  WRAP_METHOD(
//    GnomeApp* gnome_mdi_get_app_from_view(GtkWidget*),
//    static Gnome::App* get_app_from_view(const Gtk::Widget &view));

//  WRAP_METHOD(
//    GtkWidget* gnome_mdi_get_view_from_window (GnomeMDI*, GnomeApp*),
//    Gtk::Widget* get_view_from_window(const Gnome::App &app));

//  WRAP_METHOD(GnomeUIInfo* gnome_mdi_get_menubar_info(GnomeApp*),
//    static GnomeUIInfo* get_menubar_info(const App &app));

//  WRAP_METHOD(GnomeUIInfo* gnome_mdi_get_toolbar_info(GnomeApp*),
//    static GnomeUIInfo* get_toolbar_info(const App &app));

//  WRAP_METHOD(GnomeUIInfo* gnome_mdi_get_child_menu_info(GnomeApp *),
//    static GnomeUIInfo* get_child_menu_info(const App &app));



  typedef MDI_Helpers::MDIList MDIList;
  MDIList& children()
    {return reinterpret_cast<MDIList&>(object_self);}
  const MDIList& children() const
    {return reinterpret_cast<const MDIList&>(object_self);}

private:
  UI::Array menu_;
  UI::Array toolbar_;

public:

    class Proxy_app_created
      : public Gtk::EmitProxySignal1<void,GnomeApp*,CppObjectType,BaseObjectType,0,&gnomemm_app_created>
      {
          typedef Gtk::EmitProxySignal1<void,GnomeApp*,CppObjectType,BaseObjectType,0,&gnomemm_app_created> BaseType;
        public:
          void operator ()(Gnome::App&);
          void emit(Gnome::App&);
          Connection connect(const SigC::Slot1<void,Gnome::App&> &s);
      };
  union
    {
      CppObjectType * mdi_self;
      Proxy_app_created app_created;
    };

protected:
  // impl functions
    virtual void app_created_impl(Gnome::App& p0);

};



}


#endif
