// -*- c++ -*-
//  Generated by gtkmmproc from ./../alignment.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_ALIGNMENT_H
#define _GTKMM_ALIGNMENT_H

/* $Id: alignment.gen_h,v 1.33 2000/02/13 02:22:09 kenelson Exp $ */

/* alignment.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/bin.h>
#include <gtk/gtkalignment.h>

namespace Gtk {
class Alignment;
class Alignment_Class;
}
namespace Gtk { Gtk::Alignment *wrap (GtkAlignment *o); }
namespace Gtk
{
/* gtkalignment.h */
//:  Alignment Container
//- Normally, a widget is allocated at least as much size as it requests.
//- When a widget is allocated more size than it requests
//- there is a question of how the widget should expand. By convention,
//- most GTK widgets expand to fill their allocated space. Sometimes
//- this behavior is not desired. The alignment widget allows the
//- programmer to specify how a widget should expand and position itself
//- to fill the area it is allocated.

class Alignment : public Bin {

public:
  typedef Alignment          CppObjectType;
  typedef Alignment_Class    CppClassType;
  typedef GtkAlignment           BaseObjectType;
  typedef GtkAlignmentClass      BaseClassType;

private:
  friend class Alignment_Class;
  static CppClassType alignment_class;

  Alignment(const Alignment&);
  Alignment& operator=(const Alignment&); // not implemented

protected:
  void   initialize_class();
  explicit Alignment(GtkAlignment *castitem);

public:
  static GtkType get_type();
  GtkAlignment* gtkobj()             { return (GtkAlignment*)(gtkobject); }
  const GtkAlignment* gtkobj() const { return (GtkAlignment*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Alignment();

private:

public:

  explicit Alignment(gfloat xalign=0.5,
		gfloat yalign=0.5,
		gfloat xscale=1.0,
		gfloat yscale=1.0);




  //: Sets the properties for this widget.
  //- Sets both the alignment and scale of the window.
  //-
  //- See properties {xalign} and {xscale} for more detail.




  void set(gfloat xalign=0.5,gfloat yalign=0.5,gfloat xscale=1.0,gfloat yscale=1.0);


  gfloat get_xalign() const;

  gfloat get_yalign() const;

  gfloat get_xscale() const;

  gfloat get_yscale() const;

public:

protected:
  // impl functions

};

}

//+ PROPERTIES(Gtk_Alignment)

//. name: xalign
//. type: gfloat
//. set: {set()}
//. desc:    Specify how to position the child
//.     widget when it is not allocated all the space available to it.
//.     A value of 0.0 positions the widget to the left or
//.     top of its allocated space. A value of 1.0 positions
//.     the widget to the right or bottom of its allocated space. Specifying
//.     0.5 will center the widget in its allocated space.
//.
//.     Range: 0.0 to 1.0

//. name: yalign
//. type: gfloat
//. set: {set()}
//. desc: see {xalign}

//. name: xscale
//. type: gfloat
//. set: {set()}
//. desc: Specify how to scale the child
//.     widget. If the scale value is 0.0, the child widget is allocated
//.     exactly the size it requested in that dimension. If the scale value
//.     is 1.0, the child widget is allocated all of the space in a
//.     dimension. A scale value of 1.0 for both x and y is equivalent to
//.     not using an alignment widget.
//.
//. Range: 0.0 to 1.0

//. name: yscale
//. type: gfloat
//. set:  {set()}
//. desc: see {xscale}

#endif
