/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.kde.kjas.server.Main;

public class KJASAppletClassLoader
extends SecureClassLoader {
    private static Hashtable loaders = new Hashtable();
    private URL docBaseURL;
    private URL codeBaseURL;
    private Vector archives;
    private Hashtable rawdata;
    private Hashtable certificates;
    private boolean archives_loaded;
    private int archive_count;
    private String dbgID;
    private boolean active;

    public static KJASAppletClassLoader getLoader(String string, String string2) {
        KJASAppletClassLoader kJASAppletClassLoader = null;
        try {
            URL uRL = new URL(string);
            URL uRL2 = KJASAppletClassLoader.getCodeBaseURL(uRL, string2);
            Main.debug("CL: getLoader: key = " + uRL2);
            kJASAppletClassLoader = (KJASAppletClassLoader)loaders.get(uRL2.toString());
            if (kJASAppletClassLoader == null) {
                kJASAppletClassLoader = new KJASAppletClassLoader(uRL, uRL2);
                loaders.put(uRL2.toString(), kJASAppletClassLoader);
            } else {
                Main.debug("CL: reusing classloader");
                kJASAppletClassLoader.setActive();
            }
        }
        catch (MalformedURLException malformedURLException) {
            Main.kjas_err("bad DocBase URL", malformedURLException);
        }
        return kJASAppletClassLoader;
    }

    public static URL getCodeBaseURL(URL uRL, String string) {
        URL uRL2 = null;
        try {
            if (string != null) {
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                try {
                    uRL2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        uRL2 = new URL(uRL, string);
                    }
                    catch (MalformedURLException malformedURLException2) {
                        // empty catch block
                    }
                }
            }
            if (uRL2 == null) {
                String string2 = uRL.getFile();
                if (string2 == null || string2.length() == 0) {
                    uRL2 = uRL;
                } else if (string2.endsWith("/")) {
                    uRL2 = uRL;
                } else {
                    String string3 = uRL.toString();
                    int n = string3.lastIndexOf(47);
                    String string4 = string3.substring(0, n + 1);
                    uRL2 = new URL(string4);
                }
            }
        }
        catch (Exception exception) {
            Main.kjas_err("CL: exception ", exception);
        }
        return uRL2;
    }

    public static KJASAppletClassLoader getLoader(String string) {
        if (loaders.containsKey(string)) {
            return (KJASAppletClassLoader)loaders.get(string);
        }
        return null;
    }

    public KJASAppletClassLoader(URL uRL, URL uRL2) {
        this.docBaseURL = uRL;
        this.codeBaseURL = uRL2;
        this.archives = new Vector();
        this.rawdata = new Hashtable();
        this.certificates = new Hashtable();
        this.archives_loaded = false;
        this.archive_count = 0;
        this.active = true;
        this.dbgID = "CL(" + this.codeBaseURL.toString() + "): ";
    }

    public void setActive() {
        this.active = true;
    }

    public void setInactive() {
        this.active = false;
    }

    public void paramsDone() {
        if (this.archives.size() > 0) {
            if (!this.archives_loaded) {
                int n = 0;
                while (n < this.archives.size()) {
                    String string = (String)this.archives.elementAt(n);
                    Main.protocol.sendGetURLDataCmd(this.codeBaseURL.toString(), string);
                    ++n;
                }
            }
        } else {
            this.archives_loaded = true;
        }
    }

    public void addArchiveName(String string) {
        if (!this.archives.contains(string)) {
            this.archives.add(string);
            this.archives_loaded = false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addResource(String string, byte[] byArray) {
        Main.debug(this.dbgID + "addResource for url: " + string + ", size of data = " + byArray.length);
        String string2 = string.substring(this.codeBaseURL.toString().length()).replace('/', '.');
        if (this.archives.size() > 0 && !string2.endsWith(".class")) {
            try {
                try {
                    JarEntry jarEntry;
                    JarInputStream jarInputStream = new JarInputStream(new ByteArrayInputStream(byArray));
                    while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                        void var12_14;
                        byte[] byArray2;
                        if (jarEntry.isDirectory()) continue;
                        String string3 = jarEntry.getName().replace('/', '.');
                        int n = (int)jarEntry.getSize();
                        Main.debug(this.dbgID + "reading ZipEntry, name = " + string3 + ", size = " + n);
                        int n2 = 0;
                        int n3 = 0;
                        byte[] byArray3 = new byte[]{};
                        while (n2 > -1 && (n2 = jarInputStream.read(byArray2 = new byte[1024], 0, 1024)) != -1) {
                            byte[] byArray4 = byArray3;
                            byArray3 = new byte[byArray4.length + n2];
                            if (byArray4.length > 0) {
                                System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
                            }
                            System.arraycopy(byArray2, 0, byArray3, byArray4.length, n2);
                            n3 += n2;
                        }
                        byArray2 = byArray3;
                        byArray3 = new byte[n3];
                        System.arraycopy(byArray2, 0, byArray3, 0, n3);
                        this.rawdata.put(string3, byArray3);
                        Certificate[] certificateArray = jarEntry.getCertificates();
                        if (certificateArray == null) {
                            Certificate[] certificateArray2 = new Certificate[]{};
                            Main.debug("making a dummy certificate array");
                        } else {
                            Main.debug("got some real certificates with archive");
                        }
                        this.certificates.put(string3, var12_14);
                    }
                }
                catch (IOException iOException) {
                    Main.kjas_err("Problem reading resource", iOException);
                    Object var14_20 = null;
                    if (++this.archive_count != this.archives.size()) return;
                    Main.debug(this.dbgID + "all archives loaded");
                    this.archives_loaded = true;
                    return;
                }
                Object var14_19 = null;
                if (++this.archive_count != this.archives.size()) return;
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                if (++this.archive_count != this.archives.size()) throw throwable;
                Main.debug(this.dbgID + "all archives loaded");
                this.archives_loaded = true;
                throw throwable;
            }
            Main.debug(this.dbgID + "all archives loaded");
            this.archives_loaded = true;
            return;
        }
        String string4 = string.substring(this.codeBaseURL.toString().length()).replace('/', '.');
        Main.debug(this.dbgID + "resource isn't a jar, putting it straight in with name = " + string4);
        this.rawdata.put(string4, byArray);
    }

    public URL getDocBase() {
        return this.docBaseURL;
    }

    public URL getCodeBase() {
        return this.codeBaseURL;
    }

    /*
     * Unable to fully structure code
     */
    public Class findClass(String var1_1) {
        block14: {
            try {
                var2_2 = this.findSystemClass(var1_1);
                if (var2_2 != null) {
                    return var2_2;
                }
                break block14;
            }
            catch (ClassNotFoundException var3_4) {
                var2_3 = this.findLoadedClass(var1_1);
                if (var2_3 != null) {
                    return var2_3;
                }
                var4_5 = var1_1 + ".class";
                ** while (!this.archives_loaded && this.active)
            }
lbl-1000:
            // 1 sources

            {
                Main.debug(this.dbgID + "archives not loaded yet, sleeping");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException var5_6) {
                    // empty catch block
                }
                continue;
            }
lbl19:
            // 1 sources

            if (this.rawdata.containsKey(var4_5)) {
                Main.debug(this.dbgID + "class is in our rawdata table");
                var5_7 = (byte[])this.rawdata.get(var4_5);
                if (var5_7.length > 0) {
                    var6_9 = (Certificate[])this.certificates.get(var4_5);
                    var7_12 = new CodeSource(this.codeBaseURL, var6_9);
                    var2_3 = this.defineClass(var1_1, var5_7, 0, var5_7.length, var7_12);
                    return var2_3;
                }
                return null;
            }
            Main.debug(this.dbgID + "now checking the webserver");
            var5_8 = var1_1.replace('.', '/');
            var5_8 = var5_8 + ".class";
            Main.protocol.sendGetURLDataCmd(this.codeBaseURL.toString(), var5_8);
            while (!this.rawdata.containsKey(var4_5) && this.active) {
                Main.debug(this.dbgID + "waiting for the webserver to answer for class: " + var5_8);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException var6_10) {
                    // empty catch block
                }
            }
            if (this.rawdata.containsKey(var4_5)) {
                var6_11 = (byte[])this.rawdata.get(var4_5);
                if (var6_11.length > 0) {
                    Main.debug("we got the data");
                    var7_13 = new CodeSource(this.codeBaseURL, new Certificate[0]);
                    var2_3 = this.defineClass(var1_1, var6_11, 0, var6_11.length, var7_13);
                    return var2_3;
                }
                return null;
            }
        }
        Main.debug("CL: findClass returning null");
        return null;
    }

    public Class loadClass(String string) {
        Main.debug(this.dbgID + "loadClass, class name = " + string);
        String string2 = string;
        Class clazz = null;
        if (string.endsWith(".class")) {
            string2 = string.substring(0, string.lastIndexOf(".class"));
        }
        clazz = this.findClass(string2);
        return clazz;
    }

    public InputStream getResourceAsStream(String string) {
        Main.debug(this.dbgID + "getResourceAsStream, name = " + string);
        String string2 = string.replace('/', '.');
        if (this.rawdata.containsKey(string2)) {
            byte[] byArray = (byte[])this.rawdata.get(string2);
            if (byArray.length > 0) {
                return new ByteArrayInputStream(byArray);
            }
            return null;
        }
        return super.getResourceAsStream(string);
    }

    public URL getResource(String string) {
        Main.debug(this.dbgID + "getResource, name = " + string);
        return super.getResource(string);
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        final PermissionCollection permissionCollection = super.getPermissions(codeSource);
        final URL uRL = codeSource.getLocation();
        permissionCollection.add(new SocketPermission(uRL.getHost(), "connect,accept"));
        if (uRL.getProtocol().equals("file")) {
            int n;
            String string = uRL.getFile().replace('/', File.separatorChar);
            if (!string.endsWith(File.separator) && (n = string.lastIndexOf(File.separatorChar)) != -1) {
                string = string.substring(0, n + 1) + "-";
                permissionCollection.add(new FilePermission(string, "read"));
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        if (InetAddress.getLocalHost().equals(InetAddress.getByName(uRL.getHost()))) {
                            permissionCollection.add(new SocketPermission("localhost", "connect,accept"));
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        return permissionCollection;
    }

    private void dump2File(String string, byte[] byArray) {
        Main.debug("dump2File: " + string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

