/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import java.security.MessageDigest;

public class SHA
extends MessageDigest
implements Cloneable {
    private final int[] W;
    private long bytecount;
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;

    private /* synthetic */ void finit$() {
        this.W = new int[80];
    }

    public SHA() {
        super("SHA");
        this.finit$();
        this.engineReset();
    }

    public int engineGetDigestLength() {
        return 16;
    }

    public void engineUpdate(byte b) {
        int i = (int)this.bytecount % 64;
        int shift = (3 - i % 4) * 8;
        int idx = i / 4;
        this.W[idx] = this.W[idx] & ~(255 << (shift & 0x1F)) | (b & 0xFF) << (shift & 0x1F);
        if (++this.bytecount % (long)64 == 0L) {
            this.munch();
        }
    }

    public void engineUpdate(byte[] bytes, int off, int len) {
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int end = off + len;
        while (off < end) {
            this.engineUpdate(bytes[off++]);
        }
    }

    public void engineReset() {
        this.bytecount = 0L;
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = -1009589776;
    }

    public byte[] engineDigest() {
        long bitcount = this.bytecount * (long)8;
        this.engineUpdate((byte)-128);
        while ((int)this.bytecount % 64 != 56) {
            this.engineUpdate((byte)0);
        }
        this.W[14] = (int)(bitcount >>> 32);
        this.W[15] = (int)bitcount;
        this.bytecount += (long)8;
        this.munch();
        byte[] result = new byte[]{(byte)(this.H0 >>> 24), (byte)(this.H0 >>> 16), (byte)(this.H0 >>> 8), (byte)this.H0, (byte)(this.H1 >>> 24), (byte)(this.H1 >>> 16), (byte)(this.H1 >>> 8), (byte)this.H1, (byte)(this.H2 >>> 24), (byte)(this.H2 >>> 16), (byte)(this.H2 >>> 8), (byte)this.H2, (byte)(this.H3 >>> 24), (byte)(this.H3 >>> 16), (byte)(this.H3 >>> 8), (byte)this.H3, (byte)(this.H4 >>> 24), (byte)(this.H4 >>> 16), (byte)(this.H4 >>> 8), (byte)this.H4};
        this.engineReset();
        return result;
    }

    private void munch() {
        int TEMP;
        int t;
        for (int t2 = 16; t2 < 80; ++t2) {
            int Wt = this.W[t2 - 3] ^ this.W[t2 - 8] ^ this.W[t2 - 14] ^ this.W[t2 - 16];
            this.W[t2] = Wt << 1 | Wt >>> 31;
        }
        int A = this.H0;
        int B = this.H1;
        int C = this.H2;
        int D = this.H3;
        int E = this.H4;
        for (t = 0; t < 20; ++t) {
            TEMP = (A << 5 | A >>> 27) + (B & C | ~B & D) + E + this.W[t] + 1518500249;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = TEMP;
        }
        for (t = 20; t < 40; ++t) {
            TEMP = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + this.W[t] + 1859775393;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = TEMP;
        }
        for (t = 40; t < 60; ++t) {
            TEMP = (A << 5 | A >>> 27) + (B & C | B & D | C & D) + E + this.W[t] + -1894007588;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = TEMP;
        }
        for (t = 60; t < 80; ++t) {
            TEMP = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + this.W[t] + -899497514;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = TEMP;
        }
        this.H0 += A;
        this.H1 += B;
        this.H2 += C;
        this.H3 += D;
        this.H4 += E;
        for (t = 0; t < 80; ++t) {
            this.W[t] = 0;
        }
    }

    public Object clone() {
        return new SHA(this);
    }

    private SHA(SHA copy) {
        this();
        this.bytecount = copy.bytecount;
        this.H0 = copy.H0;
        this.H1 = copy.H1;
        this.H2 = copy.H2;
        this.H3 = copy.H3;
        this.H4 = copy.H4;
        System.arraycopy(copy.W, 0, this.W, 0, 80);
    }
}

