/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.security.AccessController;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import sun.security.action.LoadLibraryAction;

public class JPEGImageWriterSpi
extends ImageWriterSpi {
    private static String[] readerSpiNames = new String[]{"com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi"};
    private boolean registered = false;

    public JPEGImageWriterSpi() {
        super("Sun Microsystems, Inc.", "0.5", JPEG.names, JPEG.suffixes, JPEG.MIMETypes, "com.sun.imageio.plugins.jpeg.JPEGImageWriter", ImageWriterSpi.STANDARD_OUTPUT_TYPE, readerSpiNames, true, "javax_imageio_jpeg_stream_1.0", "com.sun.imageio.plugins.jpeg.JPEGStreamMetadataFormat", null, null, true, "javax_imageio_jpeg_image_1.0", "com.sun.imageio.plugins.jpeg.JPEGImageMetadataFormat", null, null);
    }

    public String getDescription(Locale locale) {
        return "Standard JPEG Image Writer";
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        try {
            AccessController.doPrivileged(new LoadLibraryAction("jpeg"));
        }
        catch (Throwable throwable) {
            serviceRegistry.deregisterServiceProvider(this);
            return;
        }
        this.registered = true;
    }

    public boolean isFormatLossless() {
        return false;
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        return !(colorModel instanceof IndexColorModel);
    }

    public ImageWriter createWriterInstance(Object object) throws IIOException {
        return new JPEGImageWriter(this);
    }
}

