/***************************************************************************
                            KXMLGUIFactory.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLGUIFACTORY_H
#define KXMLGUIFACTORY_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 KXMLGUIFactory, together with @ref KXMLGUIClient objects, can be used to create
 a GUI of container widgets (like menus, toolbars, etc.) and container items
 (menu items, toolbar buttons, etc.) from an XML document and action objects.

 Each @ref KXMLGUIClient represents a part of the GUI, composed from containers and
 actions. KXMLGUIFactory takes care of building (with the help of a @ref KXMLGUIBuilder)
 and merging the GUI from an unlimited number of clients.

 Each client provides XML through a @ref QDomDocument and actions through a
 @ref KActionCollection . The XML document contains the rules for how to merge the
 GUI.

 KXMLGUIFactory processes the DOM tree provided by a client and plugs in the client's actions,
 according to the XML and the merging rules of previously inserted clients. Container widgets
 are built via a @ref KXMLGUIBuilder , which has to be provided with the KXMLGUIFactory constructor.
 
 @short 
 KXMLGUIFactory, together with @ref KXMLGUIClient objects, can be used to create
 a GUI of container widgets (like menus, toolbars, etc.
*/
@class KInstance; 
@class KXMLGUIBuilder; 
@class KXMLGUIClient; 
@class QDomDocument; 
@class QDomElement; 
@class QDomNode; 
@class parse; 

@interface KXMLGUIFactory : QObject 

/** 
 Constructs a KXMLGUIFactory. The provided @p builder @ref KXMLGUIBuilder will be called
 for creating and removing container widgets, when clients are added/removed from the GUI.

 Note that the ownership of the given KXMLGUIBuilder object won't be transferred to this
 KXMLGUIFactory, so you have to take care of deleting it properly.
   
*/
- initWithXMLGUIBuilder: (KXMLGUIBuilder*)builder parent: (QObject *)parent name: (NSString *)name;
- initWithXMLGUIBuilder: (KXMLGUIBuilder*)builder ;

/** 
 Destructor
   
*/
- (void) dealloc;

/** 
 Creates the GUI described by the QDomDocument of the client,
 using the client's actions, and merges it with the previously
 created GUI.
 This also means that the order in which clients are added to the factory
 is relevant; assuming that your application supports plugins, you should
 first add your application to the factory and then the plugin, so that the
 plugin's UI is merged into the UI of your application, and not the other
 way round.
   
*/
- addClient: (KXMLGUIClient*)client;

/** 
 Removes the GUI described by the client, by unplugging all
 provided actions and removing all owned containers (and storing
 container state information in the given client)
   
*/
- removeClient: (KXMLGUIClient*)client;
- unplugActionList: (KXMLGUIClient*)client name: (NSString *)name;

/** 
 Use this method to get access to a container widget with the name specified with @p containerName
 and which is owned by the @p client. The container name is specified with a "name" attribute in the
 XML document.

 This function is particularly useful for getting hold of a popupmenu defined in an XMLUI file.
 For instance:
 QPopupMenu *popup = static_cast<QPopupMenu*>(-factory->container("my_popup",this))
 where "my_popup" is the name of the menu in the XMLUI file, and
 "this" is XMLGUIClient which owns the popupmenu (e.g. the mainwindow, or the part, or the plugin...)

 This method may return 0L if no container with the given name exists or is not owned by the client.
   
*/
- (QWidget*) container: (NSString *)containerName client: (KXMLGUIClient*)client useTagName: (BOOL)useTagName;
- (QWidget*) container: (NSString *)containerName client: (KXMLGUIClient*)client ;

/** 
 Use this method to free all memory allocated by the KXMLGUIFactory. This deletes the internal node
 tree and therefore resets the internal state of the class. Please note that the actual GUI is
 NOT touched at all, meaning no containers are deleted nor any actions unplugged. That is
 something you have to do on your own. So use this method only if you know what you are doing :-)

 (also note that this will call @ref -[KXMLGUIClient setFactory]( 0L ) for all inserted clients)
   
*/
- reset;

/** 
 Use this method to free all memory allocated by the KXMLGUIFactory for a specific container,
 including all child containers and actions. This deletes the internal node subtree for the
 specified container. The actual GUI is not touched, no containers are deleted or any actions
 unplugged. Use this method only if you know what you are doing :-)

 (also note that this will call @ref -[KXMLGUIClient setFactory]( 0L ) for all clients of the
 container)
   
*/
- resetContainer: (NSString *)containerName useTagName: (BOOL)useTagName;
- resetContainer: (NSString *)containerName ;
+ (NSString *) readConfigFile: (NSString *)filename never_null: (BOOL)never_null instance: (KInstance*)instance;
+ (NSString *) readConfigFile: (NSString *)filename instance: (KInstance*)instance;
+ (BOOL) saveConfigFile: (QDomDocument*)doc filename: (NSString *)filename instance: (KInstance*)instance;
+ (BOOL) saveConfigFile: (QDomDocument*)doc filename: (NSString *)filename ;
+ (NSString *) documentToXML: (QDomDocument*)doc;
+ (NSString *) elementToXML: (QDomElement*)elem;

/** 
 Removes all QDomComment objects from the specified node and all its children.
   
*/
+ removeDOMComments: (QDomNode*)node;
@end

/** Override these methods in subclasses of KXMLGUIFactory to customise event handling behaviour */
@protocol KXMLGUIFactoryEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
