/***************************************************************************
                            QScrollView.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QSCROLLVIEW_H
#define QSCROLLVIEW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QFrame.h>
#include <qtobjc/QScrollBar.h>

@class QContextMenuEvent; 
@class QIMEvent; 
@class QStyle; 
@class QTabletEvent; 

@interface QScrollView : QFrame 
- initWithWidget: (QWidget *)parent name: (NSString *)name f: (int)f;
- init;
- (void) dealloc;
- setResizePolicy: (int)arg1;
- (int) resizePolicy;
- styleChange: (QStyle*)arg1;
- removeChildWidget: (QWidget *)child;
- addChild: (QWidget *)child x: (int)x y: (int)y;
- addChild: (QWidget *)child ;
- moveChild: (QWidget *)child x: (int)x y: (int)y;
- (int) childX: (QWidget *)child;
- (int) childY: (QWidget *)child;
- (BOOL) childIsVisible: (QWidget *)child;
- showChild: (QWidget *)child yes: (BOOL)yes;
- showChild: (QWidget *)child ;
- (int) vScrollBarMode;
- setVScrollBarMode: (int)arg1;
- (int) hScrollBarMode;
- setHScrollBarMode: (int)arg1;
- (QWidget*) cornerWidget;
- setCornerWidget: (QWidget *)arg1;
- (QScrollBar*) horizontalScrollBar;
- (QScrollBar*) verticalScrollBar;
- (QWidget*) viewport;
- (QWidget*) clipper;
- (int) visibleWidth;
- (int) visibleHeight;
- (int) contentsWidth;
- (int) contentsHeight;
- (int) contentsX;
- (int) contentsY;
- resize: (int)w h: (int)h;
- resize: (QSize *)arg1;
- show;
- updateContents: (int)x y: (int)y w: (int)w h: (int)h;
- updateContentsInRect: (QRect*)r;
- updateContents;
- repaintContents: (int)x y: (int)y w: (int)w h: (int)h erase: (BOOL)erase;
- repaintContents: (int)x y: (int)y w: (int)w h: (int)h ;
- repaintContentsInRect: (QRect*)r erase: (BOOL)erase;
- repaintContentsInRect: (QRect*)r ;
- repaintContents: (BOOL)erase;
- repaintContents;
- contentsToViewport: (int)x y: (int)y vx: (int)vx vy: (int)vy;
- viewportToContents: (int)vx vy: (int)vy x: (int)x y: (int)y;
- (QPoint*) contentsToViewport: (QPoint*)arg1;
- (QPoint*) viewportToContents: (QPoint*)arg1;
- enableClipper: (BOOL)y;
- setStaticBackground: (BOOL)y;
- (BOOL) hasStaticBackground;
- (QSize*) viewportSize: (int)arg1 int: (int)arg2;
- (QSize*) sizeHint;
- (QSize*) minimumSizeHint;
- removeChild: (QObject *)child;
- setDragAutoScroll: (BOOL)b;
- (BOOL) dragAutoScroll;
- resizeContents: (int)w h: (int)h;
- scrollBy: (int)dx dy: (int)dy;
- setContentsPos: (int)x y: (int)y;
- ensureVisible: (int)x y: (int)y;
- ensureVisible: (int)x y: (int)y xmargin: (int)xmargin ymargin: (int)ymargin;
- center: (int)x y: (int)y;
- center: (int)x y: (int)y xmargin: (float)xmargin ymargin: (float)ymargin;
- updateScrollBars;
- setEnabled: (BOOL)enable;
- drawContents: (QPainter *)arg1 cx: (int)cx cy: (int)cy cw: (int)cw ch: (int)ch;
- drawContentsOffset: (QPainter *)arg1 ox: (int)ox oy: (int)oy cx: (int)cx cy: (int)cy cw: (int)cw ch: (int)ch;
- frameChanged;
- setMargins: (int)left top: (int)top right: (int)right bottom: (int)bottom;
- (int) leftMargin;
- (int) topMargin;
- (int) rightMargin;
- (int) bottomMargin;
- (BOOL) focusNextPrevChild: (BOOL)next;
- setHBarGeometry: (QScrollBar*)hbar x: (int)x y: (int)y w: (int)w h: (int)h;
- setVBarGeometry: (QScrollBar*)vbar x: (int)x y: (int)y w: (int)w h: (int)h;
- (BOOL) eventFilter: (QObject *)arg1 e: (QEvent *)e;
+ (int) Default;
+ (int) Manual;
+ (int) AutoOne;
+ (int) AutoOneFit;
+ (int) Auto;
+ (int) AlwaysOff;
+ (int) AlwaysOn;
@end

/** Override these methods in subclasses of QScrollView to customise event handling behaviour */
@protocol QScrollViewEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) arg1;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) arg1;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) arg1;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) arg1;
- contentsMouseMoveEvent:(QMouseEvent*) arg1;
- contentsMousePressEvent:(QMouseEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
