/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmscene.h"
#include <klocale.h>
#include <qdom.h>
#include "pmxmlhelper.h"
#include "pmdocumentformat.h"

const int c_defaultVisibilityLevel = 10;

PMScene::PMScene( )
      : Base( )
{
   m_visibilityLevel = c_defaultVisibilityLevel;
}

PMScene::~PMScene( )
{
   m_renderModes.setAutoDelete( true );
   m_renderModes.clear( );
}

QString PMScene::description( ) const
{
   return i18n( "scene" );
}

bool PMScene::isA( PMObjectType t ) const
{
   if( t == PMTScene )
      return true;
   return Base::isA( t );
}

bool PMScene::canInsert( PMObjectType t, const PMObject*,
                         const PMObjectList* ) const
{
   PMObject* o;
   switch( t )
   {
      case PMTBox:
      case PMTSphere:
      case PMTCylinder:
      case PMTCone:
      case PMTTorus:
      case PMTLathe:
      case PMTPrism:
      case PMTBlob:
      case PMTSurfaceOfRevolution:
      case PMTSuperquadricEllipsoid:
      case PMTJuliaFractal:
      case PMTHeightField:
      case PMTText:
      case PMTPlane:
      case PMTPolynom:
      case PMTComment:
      case PMTRaw:
      case PMTCSG:
      case PMTLight:
      case PMTDisc:
      case PMTBicubicPatch:
      case PMTTriangle:
      case PMTCamera:
      case PMTDeclare:
      case PMTObjectLink:
      case PMTSkySphere:
      case PMTRainbow:
      case PMTFog:
      case PMTMedia:
         return true;
         break;
      case PMTGlobalSettings:
         // Just one PMGlobalSettings is allowed
         for( o = firstChild( ); o; o = o->nextSibling( ) )
            if( o->type( ) == PMTGlobalSettings )
               return false;
         return true;
         break;
      default:
         break;
   }
   return false;
}

void PMScene::serialize( PMOutputDevice& dev ) const
{
   Base::serialize( dev );
}

void PMScene::serialize( QDomElement& e, QDomDocument& doc ) const
{
   e.setAttribute( "majorFormat", c_majorDocumentFormat );
   e.setAttribute( "minorFormat", c_minorDocumentFormat );
   e.setAttribute( "visibility_level", m_visibilityLevel );
   QDomElement data = doc.createElement( "extra_data" );
   QDomElement rm;
   
   PMRenderModeListIterator it( m_renderModes );
   for( ; it.current( ); ++it )
   {
      rm = doc.createElement( "rendermode" );
      it.current( )->serialize( rm );
      data.appendChild( rm );
   }

   e.appendChild( data );
   Base::serialize( e, doc );
}

void PMScene::readAttributes( const PMXMLHelper& h )
{
   m_visibilityLevel = h.intAttribute( "visibility_level", c_defaultVisibilityLevel );
   QDomElement e = h.extraData( );
   if( !e.isNull( ) )
   {
      QDomNode c = e.firstChild( );
      while( !c.isNull( ) )
      {
         if( c.isElement( ) )
         {
            QDomElement ce = c.toElement( );
            if( ce.tagName( ) == "rendermode" )
               m_renderModes.append( new PMRenderMode( ce ) );
         }
         c = c.nextSibling( );
      }
   }

   if( m_renderModes.count( ) > 0 )
      m_renderModes.at( 0 );
   
   Base::readAttributes( h );
}

