iconName = 'idea'
labelText = 'KTipDialog'

import os

from qt import QFrame, QHBoxLayout, QVBoxLayout, SIGNAL
from kdecore import i18n
from kdeui import KPushButton, KTipDatabase, KTipDialog, KTextEdit


helpText = ("The KDE standard Tip-of-the-Day dialog.")


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Tip-of-the-Day Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showTipDialog)

    def showTipDialog(self):
        filename = os.path.abspath(os.path.join(os.path.dirname(__file__), 'tips'))
        tips = KTipDatabase(filename)
        dlg = KTipDialog(tips, self)
        dlg.exec_loop()
