


from qt import QFrame, QHBoxLayout, QVBoxLayout, SIGNAL
from kdeui import KWindowInfo, KPushButton, KTextEdit
from kdecore import i18n, KApplication

iconName = 'misc'
labelText = 'KWindowInfo'
helpText = ''


class MainFrame(QFrame):
    def __init__(self, parent):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Message'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showWindowInfo)


    def showWindowInfo(self):
        main = KApplication.kApplication()
        print main
        print main.mainWidget()
        
        info = KWindowInfo(main)
        info.message('Updated Window Info', 3)
        
        
