#!/usr/bin/env python
#/****************************************************************************
#** $Id: buttongroups.py 322023 2004-06-19 20:33:37Z sedwards $
#**
#** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
#**
#** This file is part of an example program for Qt.  This example
#** program may be used, distributed and modified without limitation.
#**
#*****************************************************************************/

import sys
from qt import *

TRUE  = 1
FALSE = 0

##
# Creates all child widgets of the ButtonGroups window
##

class ButtonsGroups( QWidget ):
  def __init__( self, *args ):
    apply( QWidget.__init__, (self,) + args )

    # Create Widgets which allow easy layouting
    self.vbox = QVBoxLayout( self, 11, 6 )
    self.box1 = QHBoxLayout( self.vbox )
    self.box2 = QHBoxLayout( self.vbox )

    # ------- first group

    # Create an exclusive button group
    self.grp1 = QButtonGroup( 1, QGroupBox.Horizontal, "Button Group 1 (exclusive)", self )
    self.box1.addWidget( self.grp1 )
    self.grp1.setExclusive( TRUE )

    # insert 3 radiobuttons
    self.rb11 = QRadioButton( "&Radiobutton 1", self.grp1 )
    self.rb11.setChecked( TRUE )
    QRadioButton( "R&adiobutton 2", self.grp1 )
    QRadioButton( "Ra&diobutton 3", self.grp1 )

    # ------- second group

    # Create a non-exclusive buttongroup
    self.grp2 = QButtonGroup( 1, QGroupBox.Horizontal, "Button Group 2 (non-exclusive)", self )
    self.box1.addWidget( self.grp2 )
    self.grp2.setExclusive( FALSE )

    # insert 3 checkboxes
    QCheckBox( "&Checkbox 1", self.grp2 )
    self.cb12 = QCheckBox( "C&heckbox 2", self.grp2 )
    self.cb12.setChecked( TRUE )
    self.cb13 = QCheckBox( "Triple &State Button", self.grp2 )
    self.cb13.setTristate( TRUE )
    self.cb13.setChecked( TRUE )

    # ------------ third group

    # create a buttongroup which is exclusive for radiobuttons and non-exclusive for all other buttons
    self.grp3 = QButtonGroup( 1, QGroupBox.Horizontal, "Button Group 3 (Radiobutton-exclusive)", self )
    self.box2.addWidget( self.grp3 )
    self.grp3.setRadioButtonExclusive( TRUE )

    # insert three radiobuttons
    self.rb21 = QRadioButton( "Rad&iobutton 1", self.grp3 )
    self.rb22 = QRadioButton( "Radi&obutton 2", self.grp3 )
    self.rb23 = QRadioButton( "Radio&button 3", self.grp3 )
    self.rb23.setChecked( TRUE )

    # insert a checkbox...
    self.state = QCheckBox( "E&nable Radiobuttons", self.grp3 )
    self.state.setChecked( TRUE )
    # ...and connect its SIGNAL clicked() with the SLOT slotChangeGrp3State()
    self.connect( self.state, SIGNAL( "clicked()" ), self.slotChangeGrp3State )

    # ------------ fourth group

    # create a groupbox which layouts its childs in a columns
    self.grp4 = QButtonGroup( 1, QGroupBox.Horizontal, "Groupbox with normal buttons", self )
    self.box2.addWidget( self.grp4 )

    # insert two pushbuttons...
    QPushButton( "&Push Button", self.grp4 )
    self.tb2 = QPushButton( "&Toggle Button", self.grp4 )

    # ... and make the second one a toggle button
    self.tb2.setToggleButton( TRUE )
    self.tb2.setOn( TRUE )

    # ... and make the third one a flat button
    self.tb3 = QPushButton( "&Flat Button", self.grp4 )
    self.tb3.setFlat( TRUE )

    # .. and the fourth a button with a menu
    self.tb4 = QPushButton( "Popup Button", self.grp4 )
    menu = QPopupMenu(self.tb4)
    menu.insertItem("Item1", 0)
    menu.insertItem("Item2", 0)
    menu.insertItem("Item3", 0)
    menu.insertItem("Item4", 0)
    self.tb4.setPopup(menu)

    #
    # SLOT slotChangeGrp3State()
    # enables/disables the radiobuttons of the third buttongroup
    #

  def slotChangeGrp3State( self ):
    self.rb21.setEnabled( self.state.isChecked() )
    self.rb22.setEnabled( self.state.isChecked() )
    self.rb23.setEnabled( self.state.isChecked() )


## main program
a = QApplication( sys.argv )

buttonsgroups = ButtonsGroups()
buttonsgroups.resize( 500, 250 )
buttonsgroups.setCaption( "PyQT Example - Buttons and Groups" )
a.setMainWidget( buttonsgroups )
buttonsgroups.show()

a.exec_loop()
