/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import gnu.java.lang.CPStringBuilder;
import gnu.java.lang.reflect.TypeImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

final class ParameterizedTypeImpl
extends TypeImpl
implements ParameterizedType {
    private String rawTypeName;
    private ClassLoader loader;
    private Class rawType;
    private Type owner;
    private Type[] typeArgs;

    ParameterizedTypeImpl(String rawTypeName, ClassLoader loader, Type owner, Type[] typeArgs) {
        this.rawTypeName = rawTypeName;
        this.loader = loader;
        this.owner = owner;
        this.typeArgs = typeArgs;
    }

    Type resolve() {
        if (this.rawType == null) {
            try {
                this.rawType = Class.forName(this.rawTypeName, false, this.loader);
            }
            catch (ClassNotFoundException x) {
                throw new TypeNotPresentException(this.rawTypeName, x);
            }
        }
        if (this.typeArgs == null) {
            if (this.owner == null) {
                return this.rawType;
            }
            this.typeArgs = new Type[0];
        }
        ParameterizedTypeImpl.resolve(this.typeArgs);
        this.owner = ParameterizedTypeImpl.resolve(this.owner);
        return this;
    }

    public Type[] getActualTypeArguments() {
        return (Type[])this.typeArgs.clone();
    }

    public Type getRawType() {
        return this.rawType;
    }

    public Type getOwnerType() {
        return this.owner;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ParameterizedTypeImpl) {
            ParameterizedTypeImpl other = (ParameterizedTypeImpl)obj;
            return this.rawType.equals(other.rawType) && (this.owner == null && other.owner == null || this.owner.equals(other.owner)) && Arrays.deepEquals(this.typeArgs, other.typeArgs);
        }
        return false;
    }

    public int hashCode() {
        int h = 0x58158970 ^ this.rawType.hashCode();
        if (this.owner != null) {
            h ^= Integer.reverse(this.owner.hashCode());
        }
        int i = 0;
        while (i < this.typeArgs.length) {
            h ^= Integer.rotateLeft(this.typeArgs[i].hashCode(), i);
            ++i;
        }
        return h;
    }

    public String toString() {
        CPStringBuilder sb = new CPStringBuilder();
        if (this.owner != null) {
            sb.append(this.owner);
            sb.append('.');
            sb.append(this.rawType.getSimpleName());
        } else {
            sb.append(this.rawTypeName);
        }
        if (this.typeArgs.length > 0) {
            sb.append('<');
            int i = 0;
            while (i < this.typeArgs.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                if (this.typeArgs[i] instanceof Class) {
                    sb.append(((Class)this.typeArgs[i]).getName());
                } else {
                    sb.append(this.typeArgs[i]);
                }
                ++i;
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

