#!/bin/sh

config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/kde/kdm/backgroundrc.new
config etc/kde/kdm/kdmrc.new

if [ -x usr/bin/update-desktop-database ]; then
  usr/bin/update-desktop-database usr/share/applications >/dev/null 2>&1
fi

if [ -x usr/bin/update-mime-database ]; then
  usr/bin/update-mime-database usr/share/mime >/dev/null 2>&1
fi

( cd usr/lib ; rm -rf libsolidcontrol.so.4 )
( cd usr/lib ; ln -sf libsolidcontrol.so.4.4.0 libsolidcontrol.so.4 )
( cd usr/lib ; rm -rf libsystemsettingsview.so )
( cd usr/lib ; ln -sf libsystemsettingsview.so.1 libsystemsettingsview.so )
( cd usr/lib ; rm -rf liblsofui.so )
( cd usr/lib ; ln -sf liblsofui.so.4 liblsofui.so )
( cd usr/lib ; rm -rf libkdecorations.so )
( cd usr/lib ; ln -sf libkdecorations.so.4 libkdecorations.so )
( cd usr/lib ; rm -rf libplasmagenericshell.so )
( cd usr/lib ; ln -sf libplasmagenericshell.so.4 libplasmagenericshell.so )
( cd usr/lib ; rm -rf libkworkspace.so )
( cd usr/lib ; ln -sf libkworkspace.so.4 libkworkspace.so )
( cd usr/lib ; rm -rf libprocessui.so )
( cd usr/lib ; ln -sf libprocessui.so.4 libprocessui.so )
( cd usr/lib ; rm -rf libksgrd.so.4 )
( cd usr/lib ; ln -sf libksgrd.so.4.4.0 libksgrd.so.4 )
( cd usr/lib ; rm -rf libplasma_applet-system-monitor.so.4 )
( cd usr/lib ; ln -sf libplasma_applet-system-monitor.so.4.4.0 libplasma_applet-system-monitor.so.4 )
( cd usr/lib ; rm -rf libsolidcontrol.so )
( cd usr/lib ; ln -sf libsolidcontrol.so.4 libsolidcontrol.so )
( cd usr/lib ; rm -rf libweather_ion.so )
( cd usr/lib ; ln -sf libweather_ion.so.4 libweather_ion.so )
( cd usr/lib ; rm -rf libplasmaclock.so.4 )
( cd usr/lib ; ln -sf libplasmaclock.so.4.4.0 libplasmaclock.so.4 )
( cd usr/lib ; rm -rf libplasmagenericshell.so.4 )
( cd usr/lib ; ln -sf libplasmagenericshell.so.4.4.0 libplasmagenericshell.so.4 )
( cd usr/lib ; rm -rf libksignalplotter.so.4 )
( cd usr/lib ; ln -sf libksignalplotter.so.4.4.0 libksignalplotter.so.4 )
( cd usr/lib ; rm -rf libkscreensaver.so )
( cd usr/lib ; ln -sf libkscreensaver.so.5 libkscreensaver.so )
( cd usr/lib ; rm -rf libkephal.so )
( cd usr/lib ; ln -sf libkephal.so.4 libkephal.so )
( cd usr/lib ; rm -rf libkwineffects.so )
( cd usr/lib ; ln -sf libkwineffects.so.1 libkwineffects.so )
( cd usr/lib ; rm -rf libplasmaclock.so )
( cd usr/lib ; ln -sf libplasmaclock.so.4 libplasmaclock.so )
( cd usr/lib ; rm -rf libtaskmanager.so.4 )
( cd usr/lib ; ln -sf libtaskmanager.so.4.4.0 libtaskmanager.so.4 )
( cd usr/lib ; rm -rf libkdecorations.so.4 )
( cd usr/lib ; ln -sf libkdecorations.so.4.4.0 libkdecorations.so.4 )
( cd usr/lib ; rm -rf libkworkspace.so.4 )
( cd usr/lib ; ln -sf libkworkspace.so.4.4.0 libkworkspace.so.4 )
( cd usr/lib ; rm -rf libkscreensaver.so.5 )
( cd usr/lib ; ln -sf libkscreensaver.so.5.0.0 libkscreensaver.so.5 )
( cd usr/lib ; rm -rf libkephal.so.4 )
( cd usr/lib ; ln -sf libkephal.so.4.4.0 libkephal.so.4 )
( cd usr/lib ; rm -rf libsolidcontrolifaces.so )
( cd usr/lib ; ln -sf libsolidcontrolifaces.so.4 libsolidcontrolifaces.so )
( cd usr/lib ; rm -rf libksgrd.so )
( cd usr/lib ; ln -sf libksgrd.so.4 libksgrd.so )
( cd usr/lib ; rm -rf libsolidcontrolifaces.so.4 )
( cd usr/lib ; ln -sf libsolidcontrolifaces.so.4.4.0 libsolidcontrolifaces.so.4 )
( cd usr/lib ; rm -rf liblsofui.so.4 )
( cd usr/lib ; ln -sf liblsofui.so.4.4.0 liblsofui.so.4 )
( cd usr/lib ; rm -rf libkhotkeysprivate.so.4 )
( cd usr/lib ; ln -sf libkhotkeysprivate.so.4.4.0 libkhotkeysprivate.so.4 )
( cd usr/lib ; rm -rf libprocesscore.so )
( cd usr/lib ; ln -sf libprocesscore.so.4 libprocesscore.so )
( cd usr/lib ; rm -rf libksignalplotter.so )
( cd usr/lib ; ln -sf libksignalplotter.so.4 libksignalplotter.so )
( cd usr/lib ; rm -rf libkfontinstui.so.4 )
( cd usr/lib ; ln -sf libkfontinstui.so.4.4.0 libkfontinstui.so.4 )
( cd usr/lib ; rm -rf libweather_ion.so.4 )
( cd usr/lib ; ln -sf libweather_ion.so.4.4.0 libweather_ion.so.4 )
( cd usr/lib ; rm -rf libkfontinst.so )
( cd usr/lib ; ln -sf libkfontinst.so.4 libkfontinst.so )
( cd usr/lib ; rm -rf libkwinnvidiahack.so )
( cd usr/lib ; ln -sf libkwinnvidiahack.so.4 libkwinnvidiahack.so )
( cd usr/lib ; rm -rf libplasma-geolocation-interface.so )
( cd usr/lib ; ln -sf libplasma-geolocation-interface.so.4 libplasma-geolocation-interface.so )
( cd usr/lib ; rm -rf libkfontinstui.so )
( cd usr/lib ; ln -sf libkfontinstui.so.4 libkfontinstui.so )
( cd usr/lib ; rm -rf libkwineffects.so.1 )
( cd usr/lib ; ln -sf libkwineffects.so.1.0.0 libkwineffects.so.1 )
( cd usr/lib ; rm -rf libkfontinst.so.4 )
( cd usr/lib ; ln -sf libkfontinst.so.4.4.0 libkfontinst.so.4 )
( cd usr/lib ; rm -rf libplasma-geolocation-interface.so.4 )
( cd usr/lib ; ln -sf libplasma-geolocation-interface.so.4.4.0 libplasma-geolocation-interface.so.4 )
( cd usr/lib ; rm -rf libplasma_applet-system-monitor.so )
( cd usr/lib ; ln -sf libplasma_applet-system-monitor.so.4 libplasma_applet-system-monitor.so )
( cd usr/lib ; rm -rf libtaskmanager.so )
( cd usr/lib ; ln -sf libtaskmanager.so.4 libtaskmanager.so )
( cd usr/lib ; rm -rf libkwinnvidiahack.so.4 )
( cd usr/lib ; ln -sf libkwinnvidiahack.so.4.4.0 libkwinnvidiahack.so.4 )
( cd usr/lib ; rm -rf libprocessui.so.4 )
( cd usr/lib ; ln -sf libprocessui.so.4.4.0 libprocessui.so.4 )
( cd usr/lib ; rm -rf libprocesscore.so.4 )
( cd usr/lib ; ln -sf libprocesscore.so.4.4.0 libprocesscore.so.4 )
( cd usr/share/doc/HTML/en/kdm ; rm -rf common )
( cd usr/share/doc/HTML/en/kdm ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kxkb ; rm -rf common )
( cd usr/share/doc/HTML/en/kxkb ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/klipper ; rm -rf common )
( cd usr/share/doc/HTML/en/klipper ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/bell ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/bell ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/screensaver ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/screensaver ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/kcmsmserver ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/kcmsmserver ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/keyboard ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/keyboard ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/joystick ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/joystick ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/kwincompositing ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/kwincompositing ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/desktopthemedetails ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/desktopthemedetails ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/windowspecific ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/windowspecific ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/mouse ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/mouse ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/kcmstyle ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/kcmstyle ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/colors ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/colors ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/solid-actions ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/solid-actions ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/kcmdisplay ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/kcmdisplay ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/clock ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/clock ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/windowbehaviour ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/windowbehaviour ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/splashscreen ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/splashscreen ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/fontinst ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/fontinst ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/fonts ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/fonts ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/kwindecoration ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/kwindecoration ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/kcmaccess ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/kcmaccess ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/kwinscreenedges ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/kwinscreenedges ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/workspaceoptions ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/workspaceoptions ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/autostart ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/autostart ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/desktop ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/desktop ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/solid-hardware ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/solid-hardware ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/powerdevil ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/powerdevil ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/kwintabbox ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/kwintabbox ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kcontrol/keys ; rm -rf common )
( cd usr/share/doc/HTML/en/kcontrol/keys ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/plasma-desktop ; rm -rf common )
( cd usr/share/doc/HTML/en/plasma-desktop ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/systemsettings ; rm -rf common )
( cd usr/share/doc/HTML/en/systemsettings ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/ksysguard ; rm -rf common )
( cd usr/share/doc/HTML/en/ksysguard ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/doc/HTML/en/kmenuedit ; rm -rf common )
( cd usr/share/doc/HTML/en/kmenuedit ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/share/config ; rm -rf kdm )
( cd usr/share/config ; ln -sf ../../../etc/kde/kdm kdm )
