config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/rc.d/rc.modules-2.6.38.4.new

# If rc.modules is a real file, back it up:
if [ -r etc/rc.d/rc.modules -a ! -L etc/rc.d/rc.modules ]; then
   cp -favv etc/rc.d/rc.modules etc/rc.d/rc.modules.bak
fi

# A good idea whenever kernel modules are added or changed:
if [ -x sbin/depmod ]; then
  chroot . /sbin/depmod -a 2.6.38.4 1> /dev/null 2> /dev/null
fi

( cd lib/modules/2.6.38.4-versatile ; rm -rf source )
( cd lib/modules/2.6.38.4-versatile ; ln -sf ../../../usr/src/linux-2.6.38.4 source )
( cd lib/modules/2.6.38.4-versatile ; rm -rf build )
( cd lib/modules/2.6.38.4-versatile ; ln -sf ../../../usr/src/linux-2.6.38.4 build )
( cd etc/rc.d ; rm -rf rc.modules-2.6.38.4-versatile )
( cd etc/rc.d ; ln -sf rc.modules-2.6.38.4 rc.modules-2.6.38.4-versatile )
