/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;
import virtuoso.javax.OPLMessage_x;

public class OPLRowSetMetaData
implements RowSetMetaData,
Serializable {
    private static final long serialVersionUID = 4491018005954285242L;
    private Coldesc[] desc;

    public OPLRowSetMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        this.setColumnCount(n);
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            this.desc[i].columnLabel = resultSetMetaData.getColumnLabel(n2);
            this.desc[i].columnName = resultSetMetaData.getColumnName(n2);
            String string = resultSetMetaData.getSchemaName(n2);
            this.desc[i].schemaName = string != null ? string : "";
            string = resultSetMetaData.getTableName(n2);
            this.desc[i].tableName = string != null ? string : "";
            string = resultSetMetaData.getCatalogName(n2);
            this.desc[i].catalogName = string != null ? string : "";
            this.desc[i].typeName = resultSetMetaData.getColumnTypeName(n2);
            this.desc[i].type = resultSetMetaData.getColumnType(n2);
            this.desc[i].precision = resultSetMetaData.getPrecision(n2);
            this.desc[i].scale = resultSetMetaData.getScale(n2);
            this.desc[i].displaySize = resultSetMetaData.getColumnDisplaySize(n2);
            this.desc[i].isAutoIncrement = resultSetMetaData.isAutoIncrement(n2);
            this.desc[i].isCaseSensitive = resultSetMetaData.isCaseSensitive(n2);
            this.desc[i].isCurrency = resultSetMetaData.isCurrency(n2);
            this.desc[i].nullable = resultSetMetaData.isNullable(n2);
            this.desc[i].isSigned = resultSetMetaData.isSigned(n2);
            this.desc[i].isSearchable = resultSetMetaData.isSearchable(n2);
            this.desc[i].isDefinitelyWritable = resultSetMetaData.isDefinitelyWritable(n2);
            this.desc[i].isReadOnly = resultSetMetaData.isReadOnly(n2);
            this.desc[i].isWritable = resultSetMetaData.isWritable(n2);
        }
    }

    @Override
    public void setAutoIncrement(int n, boolean bl) throws SQLException {
        this.check_index(n).isAutoIncrement = bl;
    }

    @Override
    public void setCaseSensitive(int n, boolean bl) throws SQLException {
        this.check_index(n).isCaseSensitive = bl;
    }

    @Override
    public void setCatalogName(int n, String string) throws SQLException {
        if (string != null) {
            this.check_index(n).catalogName = string;
        } else {
            this.check_index(n).catalogName = "";
        }
    }

    @Override
    public void setColumnCount(int n) throws SQLException {
        if (n <= 0) {
            throw OPLMessage_x.makeException(8);
        }
        this.desc = new Coldesc[n];
        for (int i = 0; i < n; ++i) {
            this.desc[i] = new Coldesc();
        }
    }

    @Override
    public void setColumnDisplaySize(int n, int n2) throws SQLException {
        this.check_index(n).displaySize = n2;
    }

    @Override
    public void setColumnLabel(int n, String string) throws SQLException {
        this.check_index(n).columnLabel = string;
    }

    @Override
    public void setColumnName(int n, String string) throws SQLException {
        this.check_index(n).columnName = string;
    }

    @Override
    public void setColumnType(int n, int n2) throws SQLException {
        this.check_index(n).type = n2;
    }

    @Override
    public void setColumnTypeName(int n, String string) throws SQLException {
        this.check_index(n).typeName = string;
    }

    @Override
    public void setCurrency(int n, boolean bl) throws SQLException {
        this.check_index(n).isCurrency = bl;
    }

    @Override
    public void setNullable(int n, int n2) throws SQLException {
        this.check_index(n).nullable = n2;
    }

    @Override
    public void setPrecision(int n, int n2) throws SQLException {
        this.check_index(n).precision = n2;
    }

    @Override
    public void setScale(int n, int n2) throws SQLException {
        this.check_index(n).scale = n2;
    }

    @Override
    public void setSchemaName(int n, String string) throws SQLException {
        if (string != null) {
            this.check_index(n).schemaName = string;
        } else {
            this.check_index(n).schemaName = "";
        }
    }

    @Override
    public void setSearchable(int n, boolean bl) throws SQLException {
        this.check_index(n).isSearchable = bl;
    }

    @Override
    public void setSigned(int n, boolean bl) throws SQLException {
        this.check_index(n).isSigned = bl;
    }

    @Override
    public void setTableName(int n, String string) throws SQLException {
        if (string != null) {
            this.check_index(n).tableName = string;
        } else {
            this.check_index(n).tableName = "";
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.desc != null ? this.desc.length : 0;
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return this.check_index(n).isAutoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        return this.check_index(n).isCaseSensitive;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        return this.check_index(n).isSearchable;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return this.check_index(n).isCurrency;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return this.check_index(n).nullable;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return this.check_index(n).isSigned;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        return this.check_index(n).displaySize;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.check_index(n).columnLabel;
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this.check_index(n).columnName;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return this.check_index(n).schemaName;
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return this.check_index(n).precision;
    }

    @Override
    public int getScale(int n) throws SQLException {
        return this.check_index(n).scale;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return this.check_index(n).tableName;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return this.check_index(n).catalogName;
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        return this.check_index(n).type;
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        return this.check_index(n).typeName;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return this.check_index(n).isReadOnly;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return this.check_index(n).isWritable;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return this.check_index(n).isDefinitelyWritable;
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw OPLMessage_x.makeExceptionV(36, clazz.toString());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    private Coldesc check_index(int n) throws SQLException {
        if (this.desc == null || n < 1 || n > this.desc.length) {
            throw OPLMessage_x.makeException(9);
        }
        return this.desc[n - 1];
    }

    private class Coldesc
    implements Serializable {
        private String columnLabel;
        private String columnName;
        private String schemaName;
        private String tableName;
        private String catalogName;
        private String typeName;
        private int type;
        private int precision;
        private int scale;
        private int displaySize;
        private int nullable;
        private boolean isAutoIncrement;
        private boolean isCaseSensitive;
        private boolean isCurrency;
        private boolean isSigned;
        private boolean isSearchable;
        private boolean isDefinitelyWritable;
        private boolean isReadOnly;
        private boolean isWritable;

        private Coldesc() {
        }
    }
}

