/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA;

import gnu.CORBA.CDR.AbstractCdrInput;
import gnu.CORBA.CDR.AbstractCdrOutput;
import gnu.CORBA.CDR.BufferedCdrOutput;
import gnu.CORBA.CDR.BufferredCdrInput;
import gnu.CORBA.GIOP.CharSets_OSF;
import gnu.CORBA.GIOP.CodeSetServiceContext;
import gnu.CORBA.Unexpected;
import gnu.CORBA.Version;
import gnu.java.lang.CPStringBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.Adler32;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ULongSeqHelper;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHelper;

public class IOR {
    public static final int FAILED = 10;
    public Internet_profile Internet = new Internet_profile();
    public String Id;
    public byte[] key;
    ArrayList profiles = new ArrayList();
    public boolean Big_Endian = true;

    public static IOR parse(String stringified_reference) throws BAD_PARAM {
        try {
            if (!stringified_reference.startsWith("IOR:")) {
                throw new BAD_PARAM("The string refernce must start with IOR:", 10, CompletionStatus.COMPLETED_NO);
            }
            IOR r = new IOR();
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            String x = stringified_reference;
            x = x.substring(x.indexOf(":") + 1);
            int i = 0;
            while (i < x.length()) {
                char cx = (char)Integer.parseInt(x.substring(i, i + 2), 16);
                buf.write(cx);
                i += 2;
            }
            BufferredCdrInput cdr = new BufferredCdrInput(buf.toByteArray());
            r._read(cdr);
            return r;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BAD_PARAM(ex + " while parsing " + stringified_reference, 10, CompletionStatus.COMPLETED_NO);
        }
    }

    public void _read(AbstractCdrInput c) throws IOException, BAD_PARAM {
        int endian = c.read_long();
        if (endian != 0) {
            this.Big_Endian = false;
            c.setBigEndian(false);
        }
        this._read_no_endian(c);
    }

    public void _read_no_endian(AbstractCdrInput c) throws IOException, BAD_PARAM {
        this.Id = c.read_string();
        int n_profiles = c.read_long();
        if (n_profiles == 0) {
            this.Id = null;
            this.Internet = null;
            return;
        }
        int i = 0;
        while (i < n_profiles) {
            int tag = c.read_long();
            BufferredCdrInput profile = c.read_encapsulation();
            if (tag == 0) {
                this.Internet = new Internet_profile();
                this.Internet.version = Version.read_version(profile);
                this.Internet.host = profile.read_string();
                this.Internet.port = profile.gnu_read_ushort();
                this.key = profile.read_sequence();
                int n_components = 0;
                try {
                    if (this.Internet.version.since_inclusive(1, 1)) {
                        n_components = profile.read_long();
                    }
                    int t = 0;
                    while (t < n_components) {
                        int ctag = profile.read_long();
                        if (ctag == 1) {
                            this.Internet.CodeSets.read(profile);
                        } else {
                            TaggedComponent pc = new TaggedComponent();
                            pc.tag = ctag;
                            pc.component_data = profile.read_sequence();
                            this.Internet.components.add(pc);
                        }
                        ++t;
                    }
                }
                catch (Unexpected ex) {
                    ex.printStackTrace();
                }
            } else {
                TaggedProfile p = new TaggedProfile();
                p.tag = tag;
                p.profile_data = profile.buffer.getBuffer();
                this.profiles.add(p);
            }
            ++i;
        }
    }

    public void _write(AbstractCdrOutput out) {
        out.write(0);
        this._write_no_endian(out);
    }

    public static void write_null(AbstractCdrOutput out) {
        out.write_string("");
        out.write_long(0);
    }

    public void _write_no_endian(AbstractCdrOutput out) {
        out.write_string(this.Id);
        out.write_long(1 + this.profiles.size());
        out.write_long(0);
        this.Internet.write(out);
        int i = 0;
        while (i < this.profiles.size()) {
            TaggedProfile tp = (TaggedProfile)this.profiles.get(i);
            TaggedProfileHelper.write(out, tp);
            ++i;
        }
    }

    public String toString() {
        CPStringBuilder b = new CPStringBuilder();
        b.append(this.Id);
        b.append(" at ");
        b.append(this.Internet);
        if (!this.Big_Endian) {
            b.append(" (Little endian) ");
        }
        b.append(" Key ");
        int i = 0;
        while (i < this.key.length) {
            b.append(Integer.toHexString(this.key[i] & 0xFF));
            ++i;
        }
        b.append(" ");
        b.append(this.Internet.CodeSets);
        return b.toString();
    }

    public String toStringFormatted() {
        CPStringBuilder b = new CPStringBuilder();
        b.append("\nObject Id:\n  ");
        b.append(this.Id);
        b.append("\nObject is accessible at:\n  ");
        b.append(this.Internet);
        if (this.Big_Endian) {
            b.append("\n  Big endian encoding");
        } else {
            b.append("\n  Little endian encoding.");
        }
        b.append("\nObject Key\n  ");
        int i = 0;
        while (i < this.key.length) {
            b.append(Integer.toHexString(this.key[i] & 0xFF));
            ++i;
        }
        b.append("\nSupported code sets:");
        b.append("\n Wide:");
        b.append(this.Internet.CodeSets.wide.toStringFormatted());
        b.append(" Narrow:");
        b.append(this.Internet.CodeSets.wide.toStringFormatted());
        return b.toString();
    }

    public String toStringifiedReference() {
        BufferedCdrOutput out = new BufferedCdrOutput();
        this._write(out);
        CPStringBuilder b = new CPStringBuilder("IOR:");
        byte[] binary = out.buffer.toByteArray();
        int i = 0;
        while (i < binary.length) {
            String s = Integer.toHexString(binary[i] & 0xFF);
            if (s.length() == 1) {
                b.append('0');
            }
            b.append(s);
            ++i;
        }
        return b.toString();
    }

    public void add_ior_component(TaggedComponent tagged_component) {
        this.Internet.components.add(tagged_component);
        int i = 0;
        while (i < this.profiles.size()) {
            TaggedProfile profile = (TaggedProfile)this.profiles.get(i);
            IOR.addComponentTo(profile, tagged_component);
            ++i;
        }
    }

    public void add_ior_component_to_profile(TaggedComponent tagged_component, int profile_id) {
        if (profile_id == 0) {
            this.Internet.components.add(tagged_component);
        } else {
            int i = 0;
            while (i < this.profiles.size()) {
                TaggedProfile profile = (TaggedProfile)this.profiles.get(i);
                if (profile.tag == profile_id) {
                    IOR.addComponentTo(profile, tagged_component);
                }
                ++i;
            }
        }
    }

    private static void addComponentTo(TaggedProfile profile, TaggedComponent component) {
        BufferedCdrOutput out;
        if (profile.tag == 1) {
            int i;
            TaggedComponent[] present;
            if (profile.profile_data.length > 0) {
                BufferredCdrInput in = new BufferredCdrInput(profile.profile_data);
                present = new TaggedComponent[in.read_long()];
                i = 0;
                while (i < present.length) {
                    present[i] = TaggedComponentHelper.read(in);
                    ++i;
                }
            } else {
                present = new TaggedComponent[]{};
            }
            out = new BufferedCdrOutput(profile.profile_data.length + component.component_data.length + 8);
            out.write_long(present.length + 1);
            i = 0;
            while (i < present.length) {
                TaggedComponentHelper.write(out, present[i]);
                ++i;
            }
            TaggedComponentHelper.write(out, component);
            try {
                out.close();
            }
            catch (IOException e) {
                throw new Unexpected(e);
            }
        } else {
            throw new BAD_PARAM("Unsupported profile type " + profile.tag);
        }
        profile.profile_data = out.buffer.toByteArray();
    }

    public boolean equals(Object x) {
        if (x instanceof IOR) {
            boolean keys;
            boolean hosts = true;
            IOR other = (IOR)x;
            if (this.Internet == null || other.Internet == null) {
                return this.Internet == other.Internet;
            }
            if (this.key != null && other.key != null) {
                keys = Arrays.equals(this.key, other.key);
            } else {
                boolean bl = keys = this.key == other.key;
            }
            if (this.Internet != null && this.Internet.host != null && other.Internet != null && other.Internet.host != null) {
                hosts = other.Internet.host.equals(this.Internet.host);
            }
            return keys & hosts && this.Internet.port == other.Internet.port;
        }
        return false;
    }

    public int hashCode() {
        Adler32 adler = new Adler32();
        if (this.key != null) {
            adler.update(this.key);
        }
        if (this.Internet != null) {
            if (this.Internet.host != null) {
                adler.update(this.Internet.host.getBytes());
            }
            adler.update(this.Internet.port);
        }
        return (int)adler.getValue();
    }

    public static class CodeSets_profile {
        public static final int TAG_CODE_SETS = 1;
        public CodeSet_component narrow = new CodeSet_component();
        public CodeSet_component wide = new CodeSet_component();
        public CodeSetServiceContext negotiated;

        public CodeSets_profile() {
            int[] supported = CharSets_OSF.getSupportedCharSets();
            this.narrow.native_set = 65537;
            this.narrow.conversion = supported;
            this.wide.native_set = 65801;
            this.wide.conversion = supported;
        }

        public void read(AbstractCdrInput profile) {
            BufferredCdrInput encapsulation = profile.read_encapsulation();
            this.narrow.read(encapsulation);
            this.wide.read(encapsulation);
        }

        public String toString() {
            return "Narrow char: " + this.narrow + ", Wide char: " + this.wide;
        }

        public void write(AbstractCdrOutput profile) {
            AbstractCdrOutput encapsulation = profile.createEncapsulation();
            this.narrow.write(encapsulation);
            this.wide.write(encapsulation);
            try {
                encapsulation.close();
            }
            catch (IOException iOException) {
                throw new InternalError();
            }
        }

        public static class CodeSet_component {
            public int[] conversion;
            public int native_set;

            public void read(InputStream in) {
                this.native_set = in.read_ulong();
                this.conversion = ULongSeqHelper.read(in);
            }

            public String toString() {
                CPStringBuilder b = new CPStringBuilder();
                b.append("native " + this.name(this.native_set));
                if (this.conversion != null && this.conversion.length > 0) {
                    b.append(" conversion ");
                    int i = 0;
                    while (i < this.conversion.length) {
                        b.append(this.name(this.conversion[i]));
                        b.append(' ');
                        ++i;
                    }
                }
                b.append(' ');
                return b.toString();
            }

            public String toStringFormatted() {
                CPStringBuilder b = new CPStringBuilder();
                b.append("\n  Native set " + this.name(this.native_set));
                if (this.conversion != null && this.conversion.length > 0) {
                    b.append("\n  Other supported sets:\n    ");
                    int i = 0;
                    while (i < this.conversion.length) {
                        b.append(this.name(this.conversion[i]));
                        b.append(' ');
                        ++i;
                    }
                }
                b.append("\n");
                return b.toString();
            }

            public void write(OutputStream out) {
                out.write_long(this.native_set);
                ULongSeqHelper.write(out, this.conversion);
            }

            private String name(int set) {
                return "0x" + Integer.toHexString(set) + " (" + CharSets_OSF.getName(set) + ") ";
            }
        }
    }

    public class Internet_profile {
        public static final int TAG_INTERNET_IOP = 0;
        public String host;
        public Version version = new Version(1, 2);
        public int port;
        public CodeSets_profile CodeSets = new CodeSets_profile();
        ArrayList components = new ArrayList();

        public String toString() {
            CPStringBuilder b = new CPStringBuilder();
            b.append(this.host);
            b.append(":");
            b.append(this.port);
            b.append(" (v");
            b.append(this.version);
            b.append(")");
            if (this.components.size() > 0) {
                b.append(" " + this.components.size() + " extra components.");
            }
            return b.toString();
        }

        public void write(AbstractCdrOutput out) {
            try {
                AbstractCdrOutput b = out.createEncapsulation();
                this.version.write(b);
                b.write_string(this.host);
                b.write_ushort((short)(this.port & 0xFFFF));
                b.write_long(IOR.this.key.length);
                b.write(IOR.this.key);
                b.write_long(1 + this.components.size());
                b.write_long(1);
                this.CodeSets.write(b);
                int i = 0;
                while (i < this.components.size()) {
                    TaggedComponent t = (TaggedComponent)this.components.get(i);
                    TaggedComponentHelper.write(b, t);
                    ++i;
                }
                b.close();
            }
            catch (Exception e) {
                MARSHAL m = new MARSHAL("Unable to write Internet profile.");
                m.minor = 1195573273;
                m.initCause(e);
                throw m;
            }
        }
    }
}

