/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.util;

import gnu.classpath.jdwp.VMIdManager;
import gnu.classpath.jdwp.VMMethod;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.id.ClassReferenceTypeId;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Location {
    private VMMethod method;
    private long index;

    public Location(VMMethod method, long index) {
        this.method = method;
        this.index = index;
    }

    public Location(ByteBuffer bb) throws IOException, JdwpException {
        bb.get();
        ClassReferenceTypeId classId = (ClassReferenceTypeId)VMIdManager.getDefault().readReferenceTypeId(bb);
        Class klass = classId.getType();
        this.method = VMMethod.readId(klass, bb);
        this.index = bb.getLong();
    }

    public void write(DataOutputStream os) throws IOException {
        if (this.method != null) {
            VMIdManager idm = VMIdManager.getDefault();
            ClassReferenceTypeId crti = (ClassReferenceTypeId)idm.getReferenceTypeId(this.method.getDeclaringClass());
            crti.writeTagged(os);
            this.method.writeId(os);
            os.writeLong(this.index);
        } else {
            os.writeByte(1);
            os.writeLong(0L);
            os.writeLong(0L);
            os.writeLong(0L);
        }
    }

    public static Location getEmptyLocation() {
        return new Location(null, 0L);
    }

    public VMMethod getMethod() {
        return this.method;
    }

    public long getIndex() {
        return this.index;
    }

    public String toString() {
        return String.valueOf(this.method.toString()) + "." + this.index;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location l = (Location)obj;
            return this.getMethod().equals(l.getMethod()) && this.getIndex() == l.getIndex();
        }
        return false;
    }
}

