/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGData;
import gnu.javax.imageio.png.PNGException;
import gnu.javax.imageio.png.PNGFilter;
import gnu.javax.imageio.png.PNGHeader;
import gnu.javax.imageio.png.PNGICCProfile;
import gnu.javax.imageio.png.PNGPalette;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import java.util.zip.Deflater;

public class PNGEncoder {
    private static final int defaultChunkSize = 8192;
    private PNGHeader header;
    private PNGPalette palette;
    private int stride;
    private int bpp;
    private byte[] rawData;
    private PNGICCProfile profile;

    public PNGEncoder(BufferedImage bi) throws PNGException {
        int colorType;
        ColorModel c = bi.getColorModel();
        int width = bi.getWidth();
        int height = bi.getHeight();
        int depth = 0;
        boolean interlace = false;
        if (c instanceof IndexColorModel) {
            colorType = 3;
            int n = ((IndexColorModel)c).getMapSize();
            if (n <= 2) {
                depth = 1;
            } else if (n <= 4) {
                depth = 2;
            } else if (n <= 16) {
                depth = 4;
            } else if (n <= 256) {
                depth = 8;
            } else {
                throw new PNGException("Depth must be <= 8 bits for indexed color.");
            }
            this.palette = new PNGPalette((IndexColorModel)c);
        } else {
            ColorSpace grayCS;
            ColorSpace cs = c.getColorSpace();
            colorType = cs == (grayCS = ColorSpace.getInstance(1003)) || bi.getType() == 10 || bi.getType() == 11 ? (c.hasAlpha() ? 4 : 0) : (c.hasAlpha() ? 6 : 2);
            int[] bits = c.getComponentSize();
            depth = bits[0];
            int i = 1;
            while (i < bits.length) {
                if (bits[i] > depth) {
                    depth = bits[i];
                }
                ++i;
            }
            if (cs != grayCS && !cs.isCS_sRGB() && cs instanceof ICC_ColorSpace) {
                this.profile = new PNGICCProfile(((ICC_ColorSpace)cs).getProfile());
            }
        }
        this.header = new PNGHeader(width, height, depth, colorType, interlace);
        this.stride = this.header.getScanlineStride();
        this.bpp = this.header.bytesPerPixel();
        this.getRawData(bi);
    }

    public PNGHeader getHeader() {
        return this.header;
    }

    public PNGPalette getPalette() {
        return this.palette;
    }

    public PNGICCProfile getProfile() {
        return this.profile;
    }

    public Vector encodeImage() {
        PNGData chunk;
        Deflater deflater = new Deflater();
        boolean useFilter = PNGFilter.useFilter(this.header);
        byte[] lastScanline = new byte[this.stride];
        byte[] data = new byte[this.rawData.length + this.header.getHeight()];
        byte filterByte = 0;
        int i = 0;
        while (i < this.header.getHeight()) {
            byte[] scanline = new byte[this.stride];
            System.arraycopy(this.rawData, i * this.stride, scanline, 0, this.stride);
            if (useFilter && i > 0) {
                filterByte = PNGFilter.chooseFilter(scanline, lastScanline, this.bpp);
            }
            byte[] filtered = PNGFilter.filterScanline(filterByte, scanline, lastScanline, this.bpp);
            data[i * (this.stride + 1)] = filterByte;
            System.arraycopy(filtered, 0, data, 1 + i * (this.stride + 1), this.stride);
            lastScanline = scanline;
            ++i;
        }
        deflater.setInput(data);
        deflater.finish();
        Vector<PNGData> chunks = new Vector<PNGData>();
        do {
            chunk = new PNGData(8192);
            chunk.deflateToChunk(deflater);
            chunks.add(chunk);
        } while (chunk.chunkFull());
        chunk.shrink();
        return chunks;
    }

    private void getRawData(BufferedImage bi) throws PNGException {
        WritableRaster raster = bi.getRaster();
        this.rawData = new byte[this.stride * this.header.getHeight()];
        if (this.header.isIndexed()) {
            DataBuffer db = raster.getDataBuffer();
            if (!(db instanceof DataBufferByte)) {
                throw new PNGException("Unexpected DataBuffer for an IndexColorModel.");
            }
            byte[] data = ((DataBufferByte)db).getData();
            int i = 0;
            while (i < this.header.getHeight()) {
                System.arraycopy(data, i * this.stride, this.rawData, i * this.stride, this.stride);
                ++i;
            }
            return;
        }
        if (this.header.getDepth() == 16) {
            DataBuffer db = raster.getDataBuffer();
            if (!(db instanceof DataBufferUShort)) {
                throw new PNGException("Unexpected DataBuffer for 16-bit.");
            }
            short[] data = ((DataBufferUShort)db).getData();
            int i = 0;
            while (i < this.header.getHeight()) {
                int j = 0;
                while (j < this.stride >> 1) {
                    this.rawData[j * 2 + i * this.stride] = (byte)((data[j + i * (this.stride >> 1)] & 0xFF00) >> 8);
                    this.rawData[j * 2 + i * this.stride + 1] = (byte)(data[j + i * (this.stride >> 1)] & 0xFF);
                    ++j;
                }
                ++i;
            }
            return;
        }
        int size = this.header.getColorType() == 6 ? 4 : 3;
        int width = this.header.getWidth();
        int height = this.header.getHeight();
        int[] pixels = bi.getRGB(0, 0, width, height, null, 0, width);
        int i = 0;
        while (i < width * height) {
            this.rawData[i * size] = (byte)((pixels[i] & 0xFF0000) >> 16);
            this.rawData[i * size + 1] = (byte)((pixels[i] & 0xFF00) >> 8);
            this.rawData[i * size + 2] = (byte)(pixels[i] & 0xFF);
            ++i;
        }
        if (size == 4) {
            i = 0;
            while (i < width * height) {
                this.rawData[i * size + 3] = (byte)((pixels[i] & 0xFF000000) >> 24);
                ++i;
            }
        }
    }
}

