/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.ExtensionList;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public class ServerHello
implements Handshake.Body {
    protected static final int RANDOM_OFFSET = 2;
    protected static final int SESSID_OFFSET = 34;
    protected static final int SESSID_OFFSET2 = 35;
    protected ByteBuffer buffer;
    protected boolean disableExtensions;

    public ServerHello(ByteBuffer buffer) {
        this.buffer = buffer;
        this.disableExtensions = false;
    }

    public int length() {
        int sessionLen = this.buffer.get(34) & 0xFF;
        int len = 35 + sessionLen + 3;
        short elen = 0;
        if (!this.disableExtensions && len + 1 < this.buffer.limit() && (elen = this.buffer.getShort(len)) != 0) {
            len += 2 + elen;
        }
        return len;
    }

    public ProtocolVersion version() {
        return ProtocolVersion.getInstance(this.buffer.getShort(0));
    }

    public Random random() {
        ByteBuffer randomBuf = ((ByteBuffer)this.buffer.duplicate().position(2).limit(34)).slice();
        return new Random(randomBuf);
    }

    public byte[] sessionId() {
        int idlen = this.buffer.get(34) & 0xFF;
        byte[] sessionId = new byte[idlen];
        this.buffer.position(35);
        this.buffer.get(sessionId);
        return sessionId;
    }

    public CipherSuite cipherSuite() {
        int offset = 35 + (this.buffer.get(34) & 0xFF);
        return CipherSuite.forValue(this.buffer.getShort(offset)).resolve();
    }

    public CompressionMethod compressionMethod() {
        int offset = 35 + (this.buffer.get(34) & 0xFF) + 2;
        return CompressionMethod.getInstance(this.buffer.get(offset) & 0xFF);
    }

    public int extensionsLength() {
        int offset = 35 + (this.buffer.get(34) & 0xFF) + 3;
        if (offset + 1 >= this.buffer.limit()) {
            return 0;
        }
        return this.buffer.getShort(offset) & 0xFFFF;
    }

    public ExtensionList extensions() {
        int offset = 35 + (this.buffer.get(34) & 0xFF) + 3;
        if (offset + 1 >= this.buffer.limit()) {
            return null;
        }
        int len = this.buffer.getShort(offset) & 0xFFFF;
        if (len == 0) {
            len = this.buffer.limit() - offset - 2;
        }
        ByteBuffer ebuf = ((ByteBuffer)this.buffer.duplicate().position(offset).limit(offset + len + 2)).slice();
        return new ExtensionList(ebuf);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        String subprefix = "  ";
        if (prefix != null) {
            subprefix = String.valueOf(subprefix) + prefix;
        }
        out.print(subprefix);
        out.print("version: ");
        out.print(this.version());
        out.println(";");
        out.print(subprefix);
        out.println("random:");
        out.println(this.random().toString(subprefix));
        out.print(subprefix);
        out.print("sessionId:         ");
        out.print(Util.toHexString(this.sessionId(), ':'));
        out.println(";");
        out.print(subprefix);
        out.print("cipherSuite:       ");
        out.print(this.cipherSuite());
        out.println(";");
        out.print(subprefix);
        out.print("compressionMethod: ");
        out.print((Object)this.compressionMethod());
        out.println(";");
        ExtensionList exts = this.extensions();
        out.print(subprefix);
        out.println("extensions:");
        out.println(exts != null ? exts.toString(String.valueOf(subprefix) + "  ") : String.valueOf(subprefix) + "  (nil)");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} ServerHello;");
        return str.toString();
    }
}

